/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.remoting.Callable;
import hudson.slaves.SlaveComputer;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.Netrc;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    Launcher launcher;
    TaskListener listener;
    String gitExe;
    EnvVars environment;
    private Map<String, StandardCredentials> credentials = new HashMap<String, StandardCredentials>();
    private StandardCredentials defaultCredentials;
    public static int TIMEOUT;

    protected CliGitAPIImpl(String gitExe, File workspace, TaskListener listener, EnvVars environment) {
        super(workspace);
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        this.launcher = new Launcher.LocalLauncher(IGitAPI.verbose ? listener : TaskListener.NULL);
    }

    @Override
    public GitClient subGit(String subdir) {
        return new CliGitAPIImpl(this.gitExe, new File(this.workspace, subdir), this.listener, this.environment);
    }

    private int[] getGitVersion() throws InterruptedException {
        int minorVer = 1;
        int majorVer = 6;
        try {
            String v = this.firstLine(this.launchCommand("--version")).trim();
            this.listener.getLogger().println("git --version\n" + v);
            Pattern p = Pattern.compile("git version ([0-9]+)\\.([0-9+])\\..*");
            Matcher m = p.matcher(v);
            if (m.matches() && m.groupCount() >= 2) {
                try {
                    majorVer = Integer.parseInt(m.group(1));
                    minorVer = Integer.parseInt(m.group(2));
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (GitException ex) {
            this.listener.getLogger().println("Error trying to determine the git version: " + ex.getMessage());
            this.listener.getLogger().println("Assuming 1.6");
        }
        return new int[]{majorVer, minorVer};
    }

    @Override
    public void init() throws GitException, InterruptedException {
        if (this.hasGitRepo()) {
            throw new GitException(".git directory already exists! Has it already been initialised?");
        }
        Repository repo = this.getRepository();
        try {
            repo.create();
        }
        catch (IOException ioe) {
            throw new GitException("Error initiating git repo.", ioe);
        }
        finally {
            repo.close();
        }
    }

    @Override
    public boolean hasGitRepo() throws GitException, InterruptedException {
        if (this.hasGitRepo(".git")) {
            try {
                this.launchCommand("rev-parse", "--is-inside-work-tree");
            }
            catch (Exception ex) {
                ex.printStackTrace(this.listener.error("Workspace has a .git repository, but it appears to be corrupt."));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            File dotGit = new File(this.workspace, GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException, InterruptedException {
        List<IndexEntry> submodules = this.lsTree(treeIsh, true);
        Iterator<IndexEntry> it = submodules.iterator();
        while (it.hasNext()) {
            if (it.next().getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            public URIish url;
            public List<RefSpec> refspecs;
            public boolean prune;
            public boolean shallow;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            public FetchCommand prune() {
                this.prune = true;
                return this;
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                CliGitAPIImpl.this.listener.getLogger().println("Fetching upstream changes from " + this.url);
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"fetch", "--tags", "--progress"});
                StandardCredentials cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(this.url.toPrivateString());
                if (cred == null) {
                    cred = CliGitAPIImpl.this.defaultCredentials;
                }
                args.add((Object)this.url);
                if (this.refspecs != null) {
                    for (RefSpec rs : this.refspecs) {
                        if (rs == null) continue;
                        args.add(rs.toString());
                    }
                }
                if (this.prune) {
                    args.add("--prune");
                }
                if (this.shallow) {
                    args.add("--depth=1");
                }
                CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, this.url);
            }
        };
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException, InterruptedException {
        StandardCredentials cred;
        this.listener.getLogger().println("Fetching upstream changes" + (remoteName != null ? " from " + remoteName : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (remoteName == null) {
            remoteName = this.getDefaultRemote();
        }
        String url = this.getRemoteUrl(remoteName);
        args.add(url);
        if (refspec != null && refspec.length > 0) {
            for (RefSpec rs : refspec) {
                if (rs == null) continue;
                args.add(rs.toString());
            }
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, url);
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException, InterruptedException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    @Override
    public void reset(boolean hard) throws GitException, InterruptedException {
        try {
            this.validateRevision("HEAD");
        }
        catch (GitException e) {
            this.listener.getLogger().println("No valid HEAD. Skipping the resetting");
            return;
        }
        this.listener.getLogger().println("Resetting working tree");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add("reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public CloneCommand clone_() {
        return new CloneCommand(){
            String url;
            String origin;
            String reference;
            boolean shallow;
            boolean shared;

            public CloneCommand url(String url) {
                this.url = url;
                return this;
            }

            public CloneCommand repositoryName(String name) {
                this.origin = name;
                return this;
            }

            public CloneCommand shared() {
                this.shared = true;
                return this;
            }

            public CloneCommand shallow() {
                this.shallow = true;
                return this;
            }

            public CloneCommand reference(String reference) {
                this.reference = reference;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                URIish urIish = null;
                try {
                    urIish = new URIish(this.url);
                }
                catch (URISyntaxException e) {
                    CliGitAPIImpl.this.listener.getLogger().println("Invalid repository " + this.url);
                    throw new IllegalArgumentException("Invalid repository " + this.url, e);
                }
                CliGitAPIImpl.this.listener.getLogger().println("Cloning repository " + this.url);
                try {
                    Util.deleteContentsRecursive((File)CliGitAPIImpl.this.workspace);
                }
                catch (Exception e) {
                    e.printStackTrace(CliGitAPIImpl.this.listener.error("Failed to clean the workspace"));
                    throw new GitException("Failed to delete workspace", e);
                }
                CliGitAPIImpl.this.init();
                if (this.reference != null && !this.reference.equals("")) {
                    File referencePath = new File(this.reference);
                    if (!referencePath.exists()) {
                        CliGitAPIImpl.this.listener.error("Reference path does not exist: " + this.reference);
                    } else if (!referencePath.isDirectory()) {
                        CliGitAPIImpl.this.listener.error("Reference path is not a directory: " + this.reference);
                    } else {
                        try {
                            File alternates = new File(CliGitAPIImpl.this.workspace, ".git/objects/info/alternates");
                            PrintWriter w = new PrintWriter(alternates);
                            w.println(new File(referencePath, ".git/objects").getAbsolutePath());
                            w.close();
                        }
                        catch (FileNotFoundException e) {
                            CliGitAPIImpl.this.listener.error("Failed to setup reference");
                        }
                    }
                }
                if (this.shared) {
                    throw new UnsupportedOperationException("shared is unsupported, and considered dangerous");
                }
                RefSpec refSpec = new RefSpec("+refs/heads/*:refs/remotes/" + this.origin + "/*");
                CliGitAPIImpl.this.fetch_().from(urIish, Collections.singletonList(refSpec)).shallow(this.shallow).execute();
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            public ObjectId rev;
            public String strategy;

            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                this.strategy = strategy.toString();
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                try {
                    if (this.strategy != null && !this.strategy.isEmpty() && !this.strategy.equals(MergeCommand.Strategy.DEFAULT.toString())) {
                        CliGitAPIImpl.this.launchCommand("merge", "-s", this.strategy, this.rev.name());
                    } else {
                        CliGitAPIImpl.this.launchCommand("merge", this.rev.name());
                    }
                }
                catch (GitException e) {
                    throw new GitException("Could not merge " + this.rev, e);
                }
            }
        };
    }

    @Override
    public void clean() throws GitException, InterruptedException {
        this.reset(true);
        this.launchCommand("clean", "-fdx");
    }

    @Override
    public ObjectId revParse(String revName) throws GitException, InterruptedException {
        String arg = this.sanitize(revName + "^{commit}");
        String result = this.launchCommand("rev-parse", arg);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    private String sanitize(String arg) {
        if (Functions.isWindows()) {
            arg = '\"' + arg + '\"';
        }
        return arg;
    }

    public ObjectId validateRevision(String revName) throws GitException, InterruptedException {
        String result = this.launchCommand("rev-parse", "--verify", revName);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    @Override
    public String describe(String commitIsh) throws GitException, InterruptedException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        return this.firstLine(result).trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException, InterruptedException {
        if (this.getRemoteUrl(repository.getName()) != null && !this.getRemoteUrl(repository.getName()).equals("")) {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"remote", "prune", repository.getName()});
            this.launchCommand(args);
        }
    }

    @CheckForNull
    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public ChangelogCommand changelog() {
        return new ChangelogCommand(){
            final List<String> revs = new ArrayList<String>();
            Integer n = null;
            Writer out = null;

            public ChangelogCommand excludes(String rev) {
                this.revs.add(CliGitAPIImpl.this.sanitize('^' + rev));
                return this;
            }

            public ChangelogCommand excludes(ObjectId rev) {
                return this.excludes(rev.name());
            }

            public ChangelogCommand includes(String rev) {
                this.revs.add(rev);
                return this;
            }

            public ChangelogCommand includes(ObjectId rev) {
                return this.includes(rev.name());
            }

            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            public ChangelogCommand max(int n) {
                this.n = n;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder(new String[]{CliGitAPIImpl.this.gitExe, "whatchanged", "--no-abbrev", "-M", "--pretty=raw"});
                if (this.n != null) {
                    args.add("-n").add((Object)this.n);
                }
                for (String rev : this.revs) {
                    args.add(rev);
                }
                if (this.out == null) {
                    throw new IllegalStateException();
                }
                try {
                    WriterOutputStream w = new WriterOutputStream(this.out);
                    try {
                        if (CliGitAPIImpl.this.launcher.launch().cmds(args).envs((Map)CliGitAPIImpl.this.environment).stdout((OutputStream)w).stderr((OutputStream)CliGitAPIImpl.this.listener.getLogger()).pwd(CliGitAPIImpl.this.workspace).join() != 0) {
                            throw new GitException("Error launching git whatchanged");
                        }
                    }
                    finally {
                        w.flush();
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error launching git whatchanged", e);
                }
            }
        };
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"log", "--full-history", "--no-abbrev", "--format=raw", "-M", "-m", "--raw"});
        if (from != null) {
            args.add(from.name() + ".." + to.name());
        } else {
            args.add(new String[]{"-1", to.name()});
        }
        StringWriter writer = new StringWriter();
        writer.write(this.launchCommand(args));
        return new ArrayList<String>(Arrays.asList(writer.toString().split("\\n")));
    }

    @Override
    public void submoduleInit() throws GitException, InterruptedException {
        this.launchCommand("submodule", "init");
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException, InterruptedException {
        this.launchCommand("submodule", "add", remoteURL, subdir);
    }

    @Override
    public void submoduleSync() throws GitException, InterruptedException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException, InterruptedException {
        this.submoduleUpdate(recursive, null);
    }

    @Override
    public void submoduleUpdate(boolean recursive, String reference) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "update"});
        if (recursive) {
            args.add(new String[]{"--init", "--recursive"});
        }
        if (reference != null && !reference.equals("")) {
            File referencePath = new File(reference);
            if (!referencePath.exists()) {
                this.listener.error("Reference path does not exist: " + reference);
            } else if (!referencePath.isDirectory()) {
                this.listener.error("Reference path is not a directory: " + reference);
            } else {
                args.add(new String[]{"--reference", reference});
            }
        }
        this.launchCommand(args);
    }

    public void submoduleReset(boolean recursive, boolean hard) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException, InterruptedException {
        this.submoduleReset(true, true);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    @Override
    @CheckForNull
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @Override
    @CheckForNull
    public String getRemoteUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "--add", "remote." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        String result = this.launchCommand("--git-dir=" + GIT_DIR, "config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException, InterruptedException {
        return this.getDefaultRemote("origin");
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        String ret;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        return !"false".equals(this.firstLine(ret).trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could determine remote.origin.url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException, InterruptedException {
        String remote = null;
        for (Branch br : rev.getBranches()) {
            int slash;
            String b = br.getName();
            if (b != null && (slash = b.indexOf(47)) != -1) {
                remote = this.getDefaultRemote(b.substring(0, slash));
            }
            if (remote == null) continue;
            break;
        }
        if (remote == null) {
            remote = this.getDefaultRemote();
        }
        if (remote != null) {
            this.setupSubmoduleUrls(remote, listener);
        }
    }

    @Override
    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "append");
    }

    @Override
    public void addNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "add");
    }

    private void createNote(String note, String namespace, String command) throws GitException, InterruptedException {
        File msg = null;
        try {
            msg = File.createTempFile("git-note", "txt", this.workspace);
            FileUtils.writeStringToFile((File)msg, (String)note);
            this.launchCommand("notes", "--ref=" + namespace, command, "-F", msg.getAbsolutePath());
        }
        catch (IOException e) {
            throw new GitException("Could not apply note " + note, e);
        }
        catch (GitException e) {
            throw new GitException("Could not apply note " + note, e);
        }
        finally {
            if (msg != null) {
                msg.delete();
            }
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException, InterruptedException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException, InterruptedException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    public String launchCommandIn(File workDir, String ... args) throws GitException, InterruptedException {
        return this.launchCommandIn(new ArgumentListBuilder(args), this.workspace);
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull String url) throws GitException, InterruptedException {
        try {
            return this.launchCommandWithCredentials(args, workDir, credentials, new URIish(url));
        }
        catch (URISyntaxException e) {
            throw new GitException("Invalid URL " + url);
        }
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull URIish url) throws GitException, InterruptedException {
        String urlWithCrendentials;
        File store;
        File ssh;
        File key;
        block16: {
            key = null;
            ssh = null;
            File pass = null;
            store = null;
            EnvVars env = this.environment;
            try {
                if (credentials != null && credentials instanceof SSHUserPrivateKey) {
                    SSHUserPrivateKey sshUser = (SSHUserPrivateKey)credentials;
                    this.listener.getLogger().println("using GIT_SSH to set credentials " + sshUser.getDescription());
                    key = this.createSshKeyFile(key, sshUser);
                    if (this.launcher.isUnix()) {
                        ssh = this.createUnixGitSSH(key);
                        pass = this.createUnixSshAskpass(sshUser);
                    } else {
                        ssh = this.createWindowsGitSSH(key);
                        pass = this.createWindowsSshAskpass(sshUser);
                    }
                    env = new EnvVars(env);
                    env.put("GIT_SSH", ssh.getAbsolutePath());
                    env.put("SSH_ASKPASS", pass.getAbsolutePath());
                }
                if ("http".equalsIgnoreCase(url.getScheme()) || "https".equalsIgnoreCase(url.getScheme())) {
                    this.checkCredentials(url, credentials);
                    if (credentials != null) {
                        this.listener.getLogger().println("using .gitcredentials to set credentials");
                        urlWithCrendentials = this.getGitCrendentialsURL(url, credentials);
                        store = this.createGitCrendetialsStore(urlWithCrendentials);
                        this.launchCommandIn(workDir, "config", "--local", "credential.helper", "store --store=\"" + store.getAbsolutePath() + "\"");
                    }
                }
                urlWithCrendentials = this.launchCommandIn(args, workDir, env);
                if (pass == null) break block16;
                pass.delete();
            }
            catch (IOException e) {
                try {
                    throw new GitException("Failed to setup ssh credentials", e);
                }
                catch (Throwable throwable) {
                    if (pass != null) {
                        pass.delete();
                    }
                    if (key != null) {
                        key.delete();
                    }
                    if (ssh != null) {
                        ssh.delete();
                    }
                    if (store != null) {
                        store.delete();
                        this.launchCommandIn(workDir, "config", "--local", "--remove-section", "credential.helper");
                    }
                    throw throwable;
                }
            }
        }
        if (key != null) {
            key.delete();
        }
        if (ssh != null) {
            ssh.delete();
        }
        if (store != null) {
            store.delete();
            this.launchCommandIn(workDir, "config", "--local", "--remove-section", "credential.helper");
        }
        return urlWithCrendentials;
    }

    private File createGitCrendetialsStore(String urlWithCrendentials) throws IOException {
        File store = File.createTempFile("git", ".credentials");
        PrintWriter w = new PrintWriter(store);
        w.println(urlWithCrendentials);
        w.flush();
        w.close();
        return store;
    }

    private File createSshKeyFile(File key, SSHUserPrivateKey sshUser) throws IOException, InterruptedException {
        key = File.createTempFile("ssh", "key");
        PrintWriter w = new PrintWriter(key);
        List privateKeys = (List)SlaveComputer.getChannelToMaster().call((Callable)new GetPrivateKeys(sshUser));
        for (String s : privateKeys) {
            w.println(s);
        }
        w.close();
        new FilePath(key).chmod(256);
        return key;
    }

    private File createWindowsSshAskpass(SSHUserPrivateKey sshUser) throws IOException {
        File ssh = File.createTempFile("pass", ".bat");
        PrintWriter w = new PrintWriter(ssh);
        w.println("echo \"" + Secret.toString((Secret)sshUser.getPassphrase()) + "\"");
        w.flush();
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private File createUnixSshAskpass(SSHUserPrivateKey sshUser) throws IOException {
        File ssh = File.createTempFile("pass", ".sh");
        PrintWriter w = new PrintWriter(ssh);
        w.println("#!/bin/sh");
        w.println("/bin/echo \"" + Secret.toString((Secret)sshUser.getPassphrase()) + "\"");
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private File createWindowsGitSSH(File key) throws IOException {
        File ssh = File.createTempFile("ssh", ".bat");
        String progFiles = System.getenv("ProgramFiles");
        String sshPath = "/Git/bin/ssh.exe";
        File sshexe = new File(progFiles + sshPath);
        if (!sshexe.exists()) {
            sshexe = new File(progFiles + " (x86)" + sshPath);
        }
        if (!sshexe.exists()) {
            throw new RuntimeException("git plugin only support official git client http://git-scm.com/download/win");
        }
        PrintWriter w = new PrintWriter(ssh);
        w.println("@echo off");
        w.println("\"" + sshexe.getAbsolutePath() + "\" -i \"" + key.getAbsolutePath() + "\" -o StrictHostKeyChecking=no %* ");
        w.flush();
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private File createUnixGitSSH(File key) throws IOException {
        File ssh = File.createTempFile("ssh", ".sh");
        PrintWriter w = new PrintWriter(ssh);
        w.println("#!/bin/sh");
        w.println("ssh -i \"" + key.getAbsolutePath() + "\" -o StrictHostKeyChecking=no \"$@\"");
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir) throws GitException, InterruptedException {
        return this.launchCommandIn(args, workDir, this.environment);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir, EnvVars env) throws GitException, InterruptedException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        EnvVars environment = new EnvVars(env);
        if (!env.containsKey((Object)"SSH_ASKPASS")) {
            environment.put("GIT_ASKPASS", this.launcher.isUnix() ? "/bin/echo " : "echo ");
        }
        String command = "git " + StringUtils.join((Object[])args.toCommandArray(), (String)" ");
        try {
            args.prepend(new String[]{this.gitExe});
            Launcher.ProcStarter p = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)environment).stdout((OutputStream)fos).stderr((OutputStream)err);
            if (workDir != null) {
                p.pwd(workDir);
            }
            int status = p.start().joinWithTimeout((long)TIMEOUT, TimeUnit.MINUTES, this.listener);
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + command + "\" returned status code " + status + ":\nstdout: " + result + "\nstderr: " + err.toString());
            }
            return result;
        }
        catch (GitException e) {
            throw e;
        }
        catch (IOException e) {
            throw new GitException("Error performing command: " + command, e);
        }
        catch (Throwable t) {
            throw new GitException("Error performing git command", t);
        }
    }

    @Override
    public void push(URIish url, String refspec) throws GitException, InterruptedException {
        StandardCredentials cred;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", url.toPrivateASCIIString()});
        if (refspec != null) {
            args.add(refspec);
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, url);
    }

    @Override
    public void push(String remoteName, String refspec) throws GitException, InterruptedException {
        String url = this.getRemoteUrl(remoteName);
        if (url == null) {
            throw new GitException("bad remote name, URL not set in working copy");
        }
        try {
            this.push(new URIish(url), refspec);
        }
        catch (URISyntaxException e) {
            throw new GitException("bad repository URL", e);
        }
    }

    protected Set<Branch> parseBranches(String fos) throws GitException, InterruptedException {
        HashSet<Branch> branches = new HashSet<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                branches.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return branches;
    }

    @Override
    public Set<Branch> getBranches() throws GitException, InterruptedException {
        return this.parseBranches(this.launchCommand("branch", "-a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException {
        Repository db = this.getRepository();
        try {
            Map refs = db.getAllRefs();
            HashSet<Branch> branches = new HashSet<Branch>();
            for (Ref candidate : refs.values()) {
                if (!candidate.getName().startsWith("refs/remotes/")) continue;
                Branch buildBranch = new Branch(candidate);
                if (!GitClient.quietRemoteBranches) {
                    this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
                }
                branches.add(buildBranch);
            }
            if (branches.size() == 1) {
                this.listener.getLogger().println("Seen 1 remote branch");
            } else {
                this.listener.getLogger().println(MessageFormat.format("Seen {0} remote branches", branches.size()));
            }
            HashSet<Branch> hashSet = branches;
            return hashSet;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void checkout(String commit) throws GitException, InterruptedException {
        this.launchCommand("checkout", "-f", commit);
    }

    @Override
    public void checkout(String ref, String branch) throws GitException, InterruptedException {
        this.launchCommand("checkout", "-b", branch, ref);
    }

    @Override
    public void checkoutBranch(String branch, String ref) throws GitException, InterruptedException {
        try {
            this.checkout(ref);
            if (branch != null) {
                for (Branch b : this.getBranches()) {
                    if (!b.getName().equals(branch)) continue;
                    this.deleteBranch(branch);
                }
                this.checkout(ref, branch);
            }
        }
        catch (GitException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException, InterruptedException {
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", "-D", name);
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", recursive ? "-r" : null, treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public List<ObjectId> revListAll() throws GitException, InterruptedException {
        return this.doRevList("--all");
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException, InterruptedException {
        return this.doRevList(ref);
    }

    private List<ObjectId> doRevList(String ... extraArgs) throws GitException, InterruptedException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws InterruptedException {
        try {
            List<ObjectId> revs = this.revList(commit.name());
            return revs.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void add(String filePattern) throws GitException, InterruptedException {
        try {
            this.launchCommand("add", filePattern);
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, e);
        }
    }

    @Override
    public void branch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", name);
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(String message) throws GitException, InterruptedException {
        File f = null;
        try {
            f = File.createTempFile("gitcommit", ".txt");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(message.getBytes());
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            this.launchCommand("commit", "-F", f.getAbsolutePath());
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        catch (FileNotFoundException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        catch (IOException e) {
            throw new GitException("Cannot commit " + message, e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.credentials.put(url, credentials);
    }

    @Override
    public void clearCredentials() {
        this.credentials.clear();
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.defaultCredentials = credentials;
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.env("GIT_AUTHOR_NAME", name);
        this.env("GIT_AUTHOR_EMAIL", email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.env("GIT_COMMITTER_NAME", name);
        this.env("GIT_COMMITTER_EMAIL", email);
    }

    private void env(String name, String value) {
        if (value == null) {
            this.environment.remove((Object)name);
        } else {
            this.environment.put(name, value);
        }
    }

    @Override
    public Repository getRepository() throws GitException {
        try {
            return FileRepositoryBuilder.create((File)new File(this.workspace, ".git"));
        }
        catch (IOException e) {
            throw new GitException("Failed to open Git repository " + this.workspace, e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }

    @Override
    public String getTagMessage(String tagName) throws GitException, InterruptedException {
        String out = this.launchCommand("tag", "-l", tagName, "-n10000");
        return out.substring(tagName.length()).replaceAll("(?m)(^    )", "").trim();
    }

    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        String[] lines;
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        args.add(url);
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        HashMap<String, ObjectId> heads = new HashMap<String, ObjectId>();
        for (String line : lines = result.split("\n")) {
            if (line.length() < 41) {
                throw new GitException("unexpected ls-remote output " + line);
            }
            heads.put(line.substring(41), ObjectId.fromString((String)result.substring(0, 40)));
        }
        return heads;
    }

    @Override
    public ObjectId getHeadRev(String url, String branch) throws GitException, InterruptedException {
        String[] branchExploded = branch.split("/");
        branch = branchExploded[branchExploded.length - 1];
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        args.add(url);
        args.add(branch);
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        return result.length() >= 40 ? ObjectId.fromString((String)result.substring(0, 40)) : null;
    }

    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        try {
            this.launchCommand("merge", refSpec);
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + refSpec, e);
        }
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        URIish uri = (URIish)repository.getURIs().get(0);
        String url = uri.toPrivateString();
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        args.add(new String[]{"push", url});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, uri);
    }

    @Override
    @Deprecated
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        return new ArrayList<Branch>(this.parseBranches(this.launchCommand("branch", "-a", "--contains", revspec)));
    }

    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws InterruptedException {
        try {
            String result;
            try {
                result = this.launchCommand("merge-base", id1.name(), id2.name());
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing merge base", e);
        }
        catch (GitException e) {
            throw new GitException("Error parsing merge base", e);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws InterruptedException {
        return this.launchCommand("log", "--all", "--pretty=format:'%H#%ct'", branch);
    }

    private String getGitCrendentialsURL(String url, StandardCredentials cred) {
        try {
            return this.getGitCrendentialsURL(new URIish(url), cred);
        }
        catch (URISyntaxException e) {
            throw new GitException("invalid repository URL " + url, e);
        }
    }

    private String getGitCrendentialsURL(URIish u, StandardCredentials cred) {
        String scheme = u.getScheme();
        URIish uri = new URIish().setScheme(scheme).setUser(u.getUser()).setPass(u.getPass()).setHost(u.getHost()).setPort(u.getPort());
        if (cred != null && cred instanceof UsernamePasswordCredentialsImpl) {
            UsernamePasswordCredentialsImpl up = (UsernamePasswordCredentialsImpl)cred;
            uri = uri.setUser(up.getUsername()).setPass(Secret.toString((Secret)up.getPassword()));
        }
        return uri.toString();
    }

    private void checkCredentials(URIish u, StandardCredentials cred) {
        Object defaultcreds;
        String url = u.toPrivateString();
        HttpClient client = new HttpClient();
        if (cred != null && cred instanceof UsernamePasswordCredentialsImpl) {
            UsernamePasswordCredentialsImpl up = (UsernamePasswordCredentialsImpl)cred;
            defaultcreds = new UsernamePasswordCredentials(up.getUsername(), Secret.toString((Secret)up.getPassword()));
        } else {
            defaultcreds = u.getUser() != null && u.getPass() != null ? new UsernamePasswordCredentials(u.getUser(), u.getPass()) : Netrc.getInstance().getCredentials(u.getHost());
        }
        if (defaultcreds != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, defaultcreds);
        }
        if (this.proxy != null) {
            boolean shouldProxy = true;
            for (Pattern p : this.proxy.getNoProxyHostPatterns()) {
                if (!p.matcher(u.getHost()).matches()) continue;
                shouldProxy = false;
                break;
            }
            if (shouldProxy) {
                client.getHostConfiguration().setProxy(this.proxy.name, this.proxy.port);
                if (this.proxy.getUserName() != null && this.proxy.getPassword() != null) {
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxy.getUserName(), this.proxy.getPassword()));
                }
            }
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(url + "/info/refs");
        candidates.add(url + "/info/refs?service=git-upload-pack");
        if (!url.endsWith(".git")) {
            candidates.add(url + ".git/info/refs");
            candidates.add(url + ".git/info/refs?service=git-upload-pack");
        }
        int status = 0;
        try {
            for (String candidate : candidates) {
                GetMethod get = new GetMethod(candidate);
                get.setFollowRedirects(true);
                get.getParams().setParameter("http.useragent", (Object)"git/1.7.0");
                status = client.executeMethod((HttpMethod)get);
                if (status != 200) continue;
                break;
            }
            if (status != 200) {
                throw new GitException("Failed to connect to " + u.toString() + (cred != null ? " using credentials " + cred.getDescription() : "") + " (status = " + status + ")");
            }
        }
        catch (IOException e) {
            throw new GitException("Failed to connect to " + u.toString() + (cred != null ? " using credentials " + cred.getDescription() : ""));
        }
        catch (IllegalArgumentException e) {
            throw new GitException("Invalid URL " + u.toString());
        }
    }

    static {
        if (Boolean.getBoolean(GitClient.class.getName() + ".untrustedSSL")) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
        }
        TIMEOUT = Integer.getInteger(Git.class.getName() + ".timeOut", 10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetPrivateKeys
    implements Callable<List<String>, RuntimeException> {
        private final SSHUserPrivateKey sshUser;

        public GetPrivateKeys(SSHUserPrivateKey sshUser) {
            this.sshUser = sshUser;
        }

        public List<String> call() throws RuntimeException {
            return this.sshUser.getPrivateKeys();
        }
    }
}

