/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.AddNoteCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.ShowNoteCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.ProgressMonitor;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;
import org.jenkinsci.plugins.gitclient.trilead.TrileadSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    private final TaskListener listener;
    private PersonIdent author;
    private PersonIdent committer;
    private CredentialsProvider provider;
    private Repository db;
    private ObjectReader or;

    JGitAPIImpl(File workspace, TaskListener listener) {
        super(workspace);
        this.listener = listener;
        SshSessionFactory.setInstance((SshSessionFactory)new TrileadSessionFactory());
    }

    @Override
    public void clearCredentials() {
        this.asSmartCredentialsProvider().clearCredentials();
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addCredentials(url, credentials);
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addDefaultCredentials(credentials);
    }

    private synchronized SmartCredentialsProvider asSmartCredentialsProvider() {
        if (!(this.provider instanceof SmartCredentialsProvider)) {
            this.provider = new SmartCredentialsProvider(this.listener);
        }
        return (SmartCredentialsProvider)this.provider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider prov) {
        this.provider = prov;
    }

    private synchronized CredentialsProvider getProvider() {
        return this.provider;
    }

    private Repository db() throws GitException {
        if (this.db == null) {
            this.db = this.getRepository();
            this.or = this.db.newObjectReader();
        }
        return this.db;
    }

    @Override
    public GitClient subGit(String subdir) {
        return new JGitAPIImpl(new File(this.workspace, subdir), this.listener);
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.author = new PersonIdent(name, email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.committer = new PersonIdent(name, email);
    }

    @Override
    public void init() throws GitException {
        try {
            Git.init().setDirectory(this.workspace).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void checkout(String ref) throws GitException {
        boolean retried = false;
        block4: while (true) {
            try {
                this.git().checkout().setName(ref).setForce(true).call();
                return;
            }
            catch (CheckoutConflictException e) {
                if (retried) {
                    throw new GitException("Could not checkout " + ref, e);
                }
                retried = true;
                Iterator i$ = e.getConflictingPaths().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block4;
                    String path = (String)i$.next();
                    File conflict = new File(this.db().getWorkTree(), path);
                    conflict.delete();
                }
            }
            catch (GitAPIException e) {
                throw new GitException("Could not checkout " + ref, e);
            }
            catch (JGitInternalException e) {
                if (Pattern.matches("Cannot lock.+", e.getMessage())) {
                    throw new GitException("Could not checkout " + ref, e);
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public void checkout(String ref, String branch) throws GitException {
        try {
            if (ref == null) {
                ref = this.db().resolve("HEAD").name();
            }
            Git git = Git.wrap((Repository)this.db());
            git.checkout().setName(branch).setCreateBranch(true).setForce(true).setStartPoint(ref).call();
        }
        catch (IOException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
        catch (GitAPIException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
    }

    @Override
    public void checkoutBranch(String branch, String ref) throws GitException {
        try {
            RefUpdate refUpdate = branch == null ? this.db().updateRef("HEAD", true) : this.db().updateRef("refs/heads/" + branch);
            refUpdate.setNewObjectId((AnyObjectId)this.db().resolve(ref));
            switch (refUpdate.forceUpdate()) {
                case NOT_ATTEMPTED: 
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: 
                case RENAMED: {
                    throw new GitException("Could not update " + (branch != null ? branch : "") + " to " + ref);
                }
            }
            if (branch != null) {
                this.checkout(branch);
            }
        }
        catch (IOException e) {
            throw new GitException("Could not checkout " + (branch != null ? branch : "") + " with start point " + ref, e);
        }
    }

    @Override
    public void add(String filePattern) throws GitException {
        try {
            this.git().add().addFilepattern(filePattern).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    private Git git() {
        return Git.wrap((Repository)this.getRepository());
    }

    @Override
    public void commit(String message) throws GitException {
        try {
            CommitCommand cmd = this.git().commit().setMessage(message);
            if (this.author != null) {
                cmd.setAuthor(this.author);
            }
            if (this.committer != null) {
                cmd.setCommitter(new PersonIdent(this.committer, new Date()));
            }
            cmd.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        try {
            this.git().branchCreate().setName(name).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        try {
            this.git().branchDelete().setForce(true).setBranchNames(new String[]{name}).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<Branch> getBranches() throws GitException {
        try {
            List refs = this.git().branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            HashSet<Branch> branches = new HashSet<Branch>(refs.size());
            for (Ref ref : refs) {
                branches.add(new Branch(ref));
            }
            return branches;
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException {
        try {
            List refs = this.git().branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            HashSet<Branch> branches = new HashSet<Branch>(refs.size());
            for (Ref ref : refs) {
                branches.add(new Branch(ref));
            }
            return branches;
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void tag(String name, String message) throws GitException {
        try {
            this.git().tag().setName(name).setMessage(message).setForceUpdate(true).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        try {
            Ref tag = this.db().getRefDatabase().getRef("refs/tags/" + tagName);
            return tag != null;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            public URIish url;
            public List<RefSpec> refspecs;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            public FetchCommand prune() {
                throw new UnsupportedOperationException("JGit don't (yet) support pruning during fetch");
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                throw new UnsupportedOperationException("JGit don't (yet) support fetch --depth");
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                try {
                    Git git = Git.wrap((Repository)JGitAPIImpl.this.getRepository());
                    org.eclipse.jgit.api.FetchCommand fetch = git.fetch().setTagOpt(TagOpt.FETCH_TAGS);
                    fetch.setRemote(this.url.toString());
                    fetch.setCredentialsProvider(JGitAPIImpl.this.getProvider());
                    ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
                    refSpecs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
                    if (this.refspecs != null) {
                        for (RefSpec rs : this.refspecs) {
                            if (rs == null) continue;
                            refSpecs.add(rs);
                        }
                    }
                    fetch.setRefSpecs(refSpecs);
                    fetch.call();
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
            }
        };
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException {
        try {
            Git git = Git.wrap((Repository)this.getRepository());
            org.eclipse.jgit.api.FetchCommand fetch = git.fetch().setTagOpt(TagOpt.FETCH_TAGS);
            if (remoteName != null) {
                fetch.setRemote(remoteName);
            }
            fetch.setCredentialsProvider(this.getProvider());
            ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
            refSpecs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            if (refspec != null && refspec.length > 0) {
                for (RefSpec rs : refspec) {
                    if (rs == null) continue;
                    refSpecs.add(rs);
                }
            }
            fetch.setRefSpecs(refSpecs);
            fetch.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        HashMap<String, ObjectId> heads = new HashMap<String, ObjectId>();
        try {
            Repository repo = this.openDummyRepository();
            Transport tn = Transport.open((Repository)repo, (URIish)new URIish(url));
            tn.setCredentialsProvider(this.getProvider());
            FetchConnection c = tn.openFetch();
            try {
                for (Ref r : c.getRefs()) {
                    heads.put(r.getName(), r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId());
                }
            }
            finally {
                c.close();
                tn.close();
                repo.close();
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (URISyntaxException e) {
            throw new GitException(e);
        }
        return heads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branch) throws GitException {
        try {
            if (!branch.startsWith("refs/heads/")) {
                branch = "refs/heads/" + branch;
            }
            Repository repo = this.openDummyRepository();
            Transport tn = Transport.open((Repository)repo, (URIish)new URIish(remoteRepoUrl));
            tn.setCredentialsProvider(this.getProvider());
            FetchConnection c = tn.openFetch();
            try {
                Ref r;
                Iterator i$ = c.getRefs().iterator();
                do {
                    if (!i$.hasNext()) return null;
                } while (!branch.equals((r = (Ref)i$.next()).getName()));
                ObjectId objectId = r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId();
                return objectId;
            }
            finally {
                c.close();
                tn.close();
                repo.close();
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (URISyntaxException e) {
            throw new GitException(e);
        }
    }

    private Repository openDummyRepository() throws IOException {
        final File tempDir = Util.createTempDir();
        return new FileRepository(tempDir){

            public void close() {
                super.close();
                try {
                    Util.deleteRecursive((File)tempDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        return this.db().getConfig().getString("remote", name, "url");
    }

    @Override
    public Repository getRepository() throws GitException {
        try {
            return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.workspace)).build();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        try {
            StoredConfig config = this.db().getConfig();
            config.setString("remote", name, "url", url);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        try {
            StoredConfig config = this.db().getConfig();
            ArrayList<String> urls = new ArrayList<String>();
            urls.addAll(Arrays.asList(config.getStringList("remote", name, "url")));
            urls.add(url);
            config.setStringList("remote", name, "url", urls);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addNote(String note, String namespace) throws GitException {
        try {
            ObjectId head = this.db().resolve("HEAD");
            AddNoteCommand cmd = this.git().notesAdd();
            cmd.setMessage(this.normalizeNote(note));
            cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
            RevWalk walk = new RevWalk(this.or);
            cmd.setObjectId(walk.parseAny((AnyObjectId)head));
            cmd.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private String normalizeNote(String note) {
        note = note.trim();
        note = note.replaceAll("\r\n", "\n").replaceAll("\n{3,}", "\n\n");
        note = note + "\n";
        return note;
    }

    private String qualifyNotesNamespace(String namespace) {
        if (!namespace.startsWith("refs/")) {
            namespace = "refs/notes/" + namespace;
        }
        return namespace;
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException {
        try {
            ObjectId head = this.db().resolve("HEAD");
            ShowNoteCommand cmd = this.git().notesShow();
            cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
            RevWalk walk = new RevWalk(this.or);
            cmd.setObjectId(walk.parseAny((AnyObjectId)head));
            Note n = cmd.call();
            if (n == null) {
                this.addNote(note, namespace);
            } else {
                ObjectLoader ol = this.or.open((AnyObjectId)n.getData());
                StringWriter sw = new StringWriter();
                IOUtils.copy((Reader)new InputStreamReader((InputStream)ol.openStream(), Constants.CHARSET), (Writer)sw);
                sw.write("\n");
                this.addNote(sw.toString() + this.normalizeNote(note), namespace);
            }
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public ChangelogCommand changelog() {
        this.db();
        return new ChangelogCommand(){
            RevWalk walk;
            Writer out;
            {
                this.walk = new RevWalk(JGitAPIImpl.this.or);
            }

            public ChangelogCommand excludes(String rev) {
                try {
                    return this.excludes(JGitAPIImpl.this.db().resolve(rev));
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand excludes(ObjectId rev) {
                try {
                    this.walk.markUninteresting(this.walk.lookupCommit((AnyObjectId)rev));
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand includes(String rev) {
                try {
                    return this.includes(JGitAPIImpl.this.db().resolve(rev));
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand includes(ObjectId rev) {
                try {
                    this.walk.markStart(this.walk.lookupCommit((AnyObjectId)rev));
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            public ChangelogCommand max(int n) {
                this.walk.setRevFilter(MaxCountRevFilter.create((int)n));
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                PrintWriter pw = new PrintWriter(this.out, false);
                try {
                    RawFormatter formatter = new RawFormatter();
                    for (RevCommit commit : this.walk) {
                        if (commit.getParentCount() > 1) continue;
                        formatter.format(commit, null, pw);
                    }
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
                finally {
                    pw.flush();
                }
            }
        };
    }

    @Override
    public void clean() throws GitException {
        try {
            Git git = this.git();
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            git.clean().setCleanDirectories(true).setIgnore(false).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public CloneCommand clone_() {
        final org.eclipse.jgit.api.CloneCommand base = new org.eclipse.jgit.api.CloneCommand();
        base.setDirectory(this.workspace);
        base.setProgressMonitor((org.eclipse.jgit.lib.ProgressMonitor)new ProgressMonitor(this.listener));
        base.setCredentialsProvider(this.getProvider());
        return new CloneCommand(){

            public CloneCommand url(String url) {
                base.setURI(url);
                return this;
            }

            public CloneCommand repositoryName(String name) {
                base.setRemote(name);
                return this;
            }

            public CloneCommand shallow() {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support shallow clone. This flag is ignored");
                return this;
            }

            public CloneCommand shared() {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support shared flag. This flag is ignored");
                return this;
            }

            public CloneCommand reference(String reference) {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support reference repository. This flag is ignored.");
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                try {
                    if (JGitAPIImpl.this.workspace.exists()) {
                        Util.deleteContentsRecursive((File)JGitAPIImpl.this.workspace);
                    }
                    base.call();
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            ObjectId rev;
            MergeStrategy strategy;

            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                if (strategy != null && !strategy.toString().isEmpty() && strategy != MergeCommand.Strategy.DEFAULT) {
                    if (strategy == MergeCommand.Strategy.OURS) {
                        this.strategy = MergeStrategy.OURS;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.RESOLVE) {
                        this.strategy = MergeStrategy.RESOLVE;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.OCTOPUS) {
                        this.strategy = MergeStrategy.SIMPLE_TWO_WAY_IN_CORE;
                        return this;
                    }
                    JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't fully support merge strategies. This flag is ignored");
                }
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                try {
                    Git git = JGitAPIImpl.this.git();
                    MergeResult mergeResult = this.strategy != null ? git.merge().setStrategy(this.strategy).include((AnyObjectId)this.rev).call() : git.merge().include((AnyObjectId)this.rev).call();
                    if (!mergeResult.getMergeStatus().isSuccessful()) {
                        git.reset().setMode(ResetCommand.ResetType.HARD).call();
                        throw new GitException("Failed to merge " + this.rev);
                    }
                }
                catch (GitAPIException e) {
                    throw new GitException("Failed to merge " + this.rev, e);
                }
            }
        };
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        try {
            this.git().tagDelete().setTags(new String[]{tagName}).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public String getTagMessage(String tagName) throws GitException {
        try {
            this.db();
            RevWalk walk = new RevWalk(this.or);
            String s = walk.parseTag((AnyObjectId)this.db().resolve(tagName)).getFullMessage();
            walk.dispose();
            return s.trim();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        try {
            ArrayList<IndexEntry> r = new ArrayList<IndexEntry>();
            Repository db = this.db();
            RevWalk w = new RevWalk(this.or);
            RevTree t = w.parseTree((AnyObjectId)db.resolve(treeIsh));
            SubmoduleWalk walk = new SubmoduleWalk(db);
            walk.setTree((AnyObjectId)t);
            walk.setRootTree((AnyObjectId)t);
            while (walk.next()) {
                r.add(new IndexEntry(walk));
            }
            return r;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException {
        try {
            this.git().submoduleAdd().setPath(subdir).setURI(remoteURL).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        if (tagPattern == null) {
            tagPattern = "*";
        }
        try {
            HashSet<String> tags = new HashSet<String>();
            FileNameMatcher matcher = new FileNameMatcher(tagPattern, Character.valueOf('/'));
            Map refList = this.db().getRefDatabase().getRefs("refs/tags/");
            for (Ref ref : refList.values()) {
                String name = ref.getName().substring("refs/tags/".length());
                matcher.reset();
                matcher.append(name);
                if (!matcher.isMatch()) continue;
                tags.add(name);
            }
            return tags;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (InvalidPatternException e) {
            throw new GitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGitRepo() throws GitException {
        Repository db = null;
        try {
            db = this.getRepository();
            boolean bl = db.getObjectDatabase().exists();
            return bl;
        }
        catch (GitException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException {
        return this.db().hasObject((AnyObjectId)commit);
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        try {
            String remote = repository.getName();
            String prefix = "refs/remotes/" + remote + "/";
            Set<String> branches = this.listRemoteBranches(remote);
            for (Ref r : new ArrayList(this.db().getAllRefs().values())) {
                if (!r.getName().startsWith(prefix) || branches.contains(r.getName())) continue;
                RefUpdate update = this.db().updateRef(r.getName());
                update.setRefLogMessage("remote branch pruned", false);
                update.setForceUpdate(true);
                RefUpdate.Result res = update.delete();
            }
        }
        catch (URISyntaxException e) {
            throw new GitException(e);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> listRemoteBranches(String remote) throws NotSupportedException, TransportException, URISyntaxException {
        StoredConfig config = this.db().getConfig();
        HashSet<String> branches = new HashSet<String>();
        Transport tn = Transport.open((Repository)this.db(), (URIish)new URIish(config.getString("remote", remote, "url")));
        tn.setCredentialsProvider(this.getProvider());
        FetchConnection c = tn.openFetch();
        try {
            for (Ref r : c.getRefs()) {
                if (!r.getName().startsWith("refs/heads/")) continue;
                branches.add("refs/remotes/" + remote + "/" + r.getName().substring("refs/heads/".length()));
            }
        }
        finally {
            c.close();
            tn.close();
        }
        return branches;
    }

    @Override
    public void push(URIish url, String refspec) throws GitException, InterruptedException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void push(String remoteName, String refspec) throws GitException {
        RefSpec ref = refspec != null ? new RefSpec(refspec) : Transport.REFSPEC_PUSH_ALL;
        try {
            ((PushCommand)this.git().push().setRemote(remoteName).setRefSpecs(new RefSpec[]{ref}).setProgressMonitor((org.eclipse.jgit.lib.ProgressMonitor)new ProgressMonitor(this.listener)).setCredentialsProvider(this.getProvider())).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        try {
            this.db();
            RevWalk walk = new RevWalk(this.or);
            this.markAllRefs(walk);
            return this.revList(walk);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException {
        try {
            this.db();
            RevWalk walk = new RevWalk(this.or);
            walk.markStart(walk.parseCommit((AnyObjectId)this.db().resolve(ref)));
            return this.revList(walk);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private List<ObjectId> revList(RevWalk walk) {
        walk.setRetainBody(false);
        walk.sort(RevSort.COMMIT_TIME_DESC);
        ArrayList<ObjectId> r = new ArrayList<ObjectId>();
        for (RevCommit c : walk) {
            r.add(c.copy());
        }
        return r;
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        try {
            ObjectId id = this.db().resolve(revName + "^{commit}");
            if (id == null) {
                throw new GitException("Unknown git object " + revName);
            }
            return id;
        }
        catch (IOException e) {
            throw new GitException("Failed to resolve git reference " + revName, e);
        }
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException {
        try {
            this.db();
            RevWalk w = new RevWalk(this.or);
            w.markStart(w.parseCommit((AnyObjectId)to));
            if (from != null) {
                w.markUninteresting(w.parseCommit((AnyObjectId)from));
            } else {
                w.setRevFilter(MaxCountRevFilter.create((int)1));
            }
            ArrayList<String> r = new ArrayList<String>();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            RawFormatter f = new RawFormatter();
            for (RevCommit c : w) {
                if (c.getParentCount() == 1) {
                    f.format(c, null, pw);
                } else {
                    for (RevCommit p : c.getParents()) {
                        f.format(c, p, pw);
                    }
                }
                pw.flush();
                r.addAll(Arrays.asList(sw.toString().split("\n")));
                sw.getBuffer().setLength(0);
            }
            return r;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private Iterable<JGitAPIImpl> submodules() throws IOException {
        ArrayList<JGitAPIImpl> submodules = new ArrayList<JGitAPIImpl>();
        SubmoduleWalk generator = SubmoduleWalk.forIndex((Repository)this.db());
        while (generator.next()) {
            submodules.add(new JGitAPIImpl(generator.getDirectory(), this.listener));
        }
        return submodules;
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        try {
            for (JGitAPIImpl sub : this.submodules()) {
                sub.clean();
                if (!recursive) continue;
                sub.submoduleClean(true);
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException {
        try {
            this.git().submoduleUpdate().call();
            if (recursive) {
                for (JGitAPIImpl sub : this.submodules()) {
                    sub.submoduleUpdate(recursive);
                }
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void submoduleUpdate(boolean recursive, String reference) throws GitException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        try {
            this.merge(this.db().resolve(refSpec));
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        this.push(repository.getName(), refspec);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        try {
            this.db();
            RevWalk walk = new RevWalk(this.or);
            walk.setRetainBody(false);
            walk.sort(RevSort.TOPO);
            ObjectId id = this.db().resolve(revspec);
            if (id == null) {
                throw new GitException("Invalid commit: " + revspec);
            }
            RevCommit target = walk.parseCommit((AnyObjectId)id);
            ArrayList<RevFlag> flags = new ArrayList<RevFlag>(24);
            for (int i = 0; i < 24; ++i) {
                flags.add(walk.newFlag("branch" + i));
            }
            walk.carry(flags);
            ArrayList<Branch> result = new ArrayList<Branch>();
            List<Ref> branches = this.getAllBranchRefs();
            while (!branches.isEmpty()) {
                RevCommit c;
                List<Ref> batch = branches.subList(0, Math.min(flags.size(), branches.size()));
                branches = branches.subList(batch.size(), branches.size());
                walk.reset();
                int idx = 0;
                for (Ref r : batch) {
                    RevCommit c2 = walk.parseCommit((AnyObjectId)r.getObjectId());
                    walk.markStart(c2);
                    c2.add((RevFlag)flags.get(idx));
                    ++idx;
                }
                for (RevCommit p : target.getParents()) {
                    walk.markUninteresting(p);
                }
                Iterator<Ref> i$ = walk.iterator();
                while (i$.hasNext() && !(c = (RevCommit)i$.next()).equals((AnyObjectId)target)) {
                }
                idx = 0;
                for (Ref r : batch) {
                    if (target.has((RevFlag)flags.get(idx))) {
                        result.add(new Branch(r));
                    }
                    ++idx;
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private List<Ref> getAllBranchRefs() {
        ArrayList<Ref> branches = new ArrayList<Ref>();
        for (Ref r : this.db().getAllRefs().values()) {
            if (!r.getName().startsWith("refs/heads/")) continue;
            branches.add(r);
        }
        return branches;
    }

    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws InterruptedException {
        try {
            this.db();
            RevWalk walk = new RevWalk(this.or);
            walk.setRetainBody(false);
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(walk.parseCommit((AnyObjectId)id1));
            walk.markStart(walk.parseCommit((AnyObjectId)id2));
            RevCommit base = walk.next();
            if (base == null) {
                return null;
            }
            return base.getId();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws InterruptedException {
        try {
            StringBuilder w = new StringBuilder();
            this.db();
            RevWalk walk = new RevWalk(this.or);
            this.markAllRefs(walk);
            walk.setRetainBody(false);
            for (RevCommit c : walk) {
                w.append('\'').append(c.name()).append('#').append(c.getCommitTime()).append("'\n");
            }
            return w.toString().trim();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private void markAllRefs(RevWalk walk) throws IOException {
        this.markRefs(walk, (Predicate<Ref>)Predicates.alwaysTrue());
    }

    private void markRefs(RevWalk walk, Predicate<Ref> filter) throws IOException {
        for (Ref r : this.db().getAllRefs().values()) {
            if (!filter.apply((Object)r)) continue;
            RevCommit c = walk.parseCommit((AnyObjectId)r.getObjectId());
            walk.markStart(c);
        }
    }

    @Override
    @Deprecated
    public void submoduleInit() throws GitException, InterruptedException {
        try {
            this.git().submoduleInit().call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void submoduleSync() throws GitException, InterruptedException {
        try {
            this.git().submoduleSync().call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        String v = this.db().getConfig().getString("submodule", name, "url");
        if (v == null) {
            throw new GitException("No such submodule: " + name);
        }
        return v.trim();
    }

    @Override
    @Deprecated
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        try {
            StoredConfig config = this.db().getConfig();
            config.setString("submodule", name, "url", url);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @Deprecated
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String describe(String tip) throws GitException, InterruptedException {
        try {
            RevCommit c;
            this.db();
            final RevWalk w = new RevWalk(this.or);
            w.setRetainBody(false);
            HashMap<ObjectId, Ref> tags = new HashMap<ObjectId, Ref>();
            for (Ref r : this.db().getTags().values()) {
                ObjectId key = this.db.peel(r).getPeeledObjectId();
                if (key == null) {
                    key = r.getObjectId();
                }
                tags.put(key, r);
            }
            final RevFlagSet allFlags = new RevFlagSet();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Candidate {
                final RevCommit commit;
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag) {
                    this.commit = commit;
                    this.tag = tag;
                    this.flag = w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                public boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                public String describe(ObjectId tip) throws IOException {
                    return String.format("%s-%d-g%s", this.tag.getName().substring("refs/tags/".length()), this.depth, JGitAPIImpl.this.or.abbreviate((AnyObjectId)tip).name());
                }
            }
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            ObjectId tipId = this.db().resolve(tip);
            Ref lucky = (Ref)tags.get(tipId);
            if (lucky != null) {
                return lucky.getName().substring("refs/tags/".length());
            }
            w.markStart(w.parseCommit((AnyObjectId)tipId));
            int maxCandidates = 10;
            int seen = 0;
            while ((c = w.next()) != null) {
                Ref t;
                if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                    Candidate cd = new Candidate(c, t);
                    candidates.add(cd);
                    cd.depth = seen;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= maxCandidates) break;
                ++seen;
            }
            while ((c = w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                throw new GitException("No tags can describe " + tip);
            }
            Collections.sort(candidates, new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    return o1.depth - o2.depth;
                }
            });
            return ((Candidate)candidates.get(0)).describe(tipId);
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        try {
            this.db();
            RevWalk w = new RevWalk(this.or);
            TreeWalk tree = new TreeWalk(this.or);
            tree.addTree((AnyObjectId)w.parseTree((AnyObjectId)this.db().resolve(treeIsh)));
            tree.setRecursive(recursive);
            ArrayList<IndexEntry> r = new ArrayList<IndexEntry>();
            while (tree.next()) {
                RevObject rev = w.parseAny((AnyObjectId)tree.getObjectId(0));
                r.add(new IndexEntry(String.format("%06o", tree.getRawMode(0)), Constants.typeString((int)rev.getType()), tree.getObjectId(0).name(), tree.getNameString()));
            }
            return r;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void reset(boolean hard) throws GitException, InterruptedException {
        try {
            ResetCommand reset = new ResetCommand(this.db());
            reset.setMode(hard ? ResetCommand.ResetType.HARD : ResetCommand.ResetType.MIXED);
            reset.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        if (StringUtils.isBlank((String)GIT_DIR)) {
            return this.db().isBare();
        }
        return new File(this.workspace, GIT_DIR).getName().equals(".git");
    }

    @Override
    @Deprecated
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        Set remotes = this.getConfig(null).getNames("remote");
        if (remotes.contains(_default_)) {
            return _default_;
        }
        return (String)Iterables.getFirst((Iterable)remotes, null);
    }

    @Override
    @Deprecated
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        this.getConfig(GIT_DIR).setString("remote", name, "url", url);
    }

    @Override
    @Deprecated
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        return this.getConfig(GIT_DIR).getString("remote", name, "url");
    }

    private StoredConfig getConfig(String GIT_DIR) {
        Object config = StringUtils.isBlank((String)GIT_DIR) ? this.db().getConfig() : new FileBasedConfig(new File(this.workspace, GIT_DIR), this.db().getFS());
        return config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrefixPredicate
    implements Predicate<Ref> {
        private final String prefix;

        PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(Ref r) {
            return r.getName().startsWith(this.prefix);
        }
    }

    class RawFormatter {
        private final RenameDetector rd;

        RawFormatter() {
            this.rd = new RenameDetector(JGitAPIImpl.this.db());
        }

        private boolean hasNewPath(DiffEntry d) {
            return d.getChangeType() == DiffEntry.ChangeType.COPY || d.getChangeType() == DiffEntry.ChangeType.RENAME;
        }

        private String statusOf(DiffEntry d) {
            switch (d.getChangeType()) {
                case ADD: {
                    return "A";
                }
                case MODIFY: {
                    return "M";
                }
                case DELETE: {
                    return "D";
                }
                case RENAME: {
                    return "R" + d.getScore();
                }
                case COPY: {
                    return "C" + d.getScore();
                }
            }
            throw new AssertionError((Object)("Unexpected change type: " + d.getChangeType()));
        }

        void format(RevCommit commit, @Nullable RevCommit parent, PrintWriter pw) throws IOException {
            if (parent != null) {
                pw.printf("commit %s (from %s)\n", commit.name(), parent.name());
            } else {
                pw.printf("commit %s\n", commit.name());
            }
            pw.printf("tree %s\n", commit.getTree().name());
            for (RevCommit p : commit.getParents()) {
                pw.printf("parent %s\n", p.name());
            }
            pw.printf("author %s\n", commit.getAuthorIdent().toExternalString());
            pw.printf("committer %s\n", commit.getCommitterIdent().toExternalString());
            String msg = commit.getFullMessage();
            if (msg.endsWith("\n")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            msg = msg.replace("\n", "\n    ");
            msg = "    " + msg + "\n";
            pw.println(msg);
            TreeWalk tw = new TreeWalk(JGitAPIImpl.this.or);
            tw.reset(new AnyObjectId[]{parent != null ? parent.getTree() : commit.getParent(0).getTree(), commit.getTree()});
            tw.setRecursive(true);
            tw.setFilter(TreeFilter.ANY_DIFF);
            this.rd.reset();
            this.rd.addAll((Collection)DiffEntry.scan((TreeWalk)tw));
            List diffs = this.rd.compute(JGitAPIImpl.this.or, null);
            for (DiffEntry diff : diffs) {
                pw.printf(":%06o %06o %s %s %s\t%s", diff.getOldMode().getBits(), diff.getNewMode().getBits(), diff.getOldId().name(), diff.getNewId().name(), this.statusOf(diff), diff.getChangeType() == DiffEntry.ChangeType.ADD ? diff.getNewPath() : diff.getOldPath());
                if (this.hasNewPath(diff)) {
                    pw.printf(" %s", diff.getNewPath());
                }
                pw.println();
                pw.println();
            }
        }
    }
}

