/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.Tag;
import hudson.remoting.Channel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.AbstractGitAPIImpl;
import org.jenkinsci.plugins.gitclient.GitClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LegacyCompatibleGitAPIImpl
extends AbstractGitAPIImpl
implements IGitAPI {
    protected final File workspace;

    @Override
    public boolean isBareRepository() throws GitException, InterruptedException {
        return this.isBareRepository("");
    }

    protected LegacyCompatibleGitAPIImpl(File workspace) {
        this.workspace = workspace;
    }

    @Override
    @Deprecated
    public boolean hasGitModules(String treeIsh) throws GitException {
        try {
            return new File(this.workspace, ".gitmodules").exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    @Deprecated
    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    @Override
    @Deprecated
    public void fetch(String repository, String refspec) throws GitException, InterruptedException {
        this.fetch(repository, new RefSpec(refspec));
    }

    @Override
    @Deprecated
    public void fetch(RemoteConfig remoteRepository) throws InterruptedException {
        this.fetch((URIish)remoteRepository.getURIs().get(0), remoteRepository.getFetchRefSpecs());
    }

    @Override
    @Deprecated
    public void fetch() throws GitException, InterruptedException {
        this.fetch((String)null, (RefSpec)null);
    }

    @Override
    public void reset() throws GitException, InterruptedException {
        this.reset(false);
    }

    @Override
    @Deprecated
    public void clone(RemoteConfig source) throws GitException, InterruptedException {
        this.clone(source, false);
    }

    @Override
    @Deprecated
    public void clone(RemoteConfig rc, boolean useShallowClone) throws GitException, InterruptedException {
        String source = ((URIish)rc.getURIs().get(0)).toPrivateString();
        this.clone(source, rc.getName(), useShallowClone, null);
    }

    @Override
    @Deprecated
    public List<ObjectId> revListBranch(String branchId) throws GitException, InterruptedException {
        return this.revList(branchId);
    }

    @Override
    @Deprecated
    public List<String> showRevision(Revision r) throws GitException, InterruptedException {
        return this.showRevision(null, r.getSha1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        try {
            ObjectId commit = db.resolve(revName);
            ArrayList<Tag> ret = new ArrayList<Tag>();
            for (Map.Entry tag : db.getTags().entrySet()) {
                ObjectId tagId = ((Ref)tag.getValue()).getObjectId();
                if (!commit.equals((AnyObjectId)tagId)) continue;
                ret.add(new Tag((String)tag.getKey(), tagId));
            }
            ArrayList<Tag> arrayList = ret;
            return arrayList;
        }
        finally {
            db.close();
        }
    }

    @Override
    public final List<IndexEntry> lsTree(String treeIsh) throws GitException, InterruptedException {
        return this.lsTree(treeIsh, false);
    }

    @Override
    protected Object writeReplace() {
        return this.remoteProxyFor((GitClient)Channel.current().export(IGitAPI.class, (Object)this));
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            File dotGit = new File(this.workspace, ".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    public List<String> showRevision(ObjectId r) throws GitException, InterruptedException {
        return this.showRevision(null, r);
    }
}

