/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceRequest;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchDiscoveryTrait
extends SCMSourceTrait {
    private int strategyId;

    @DataBoundConstructor
    public BranchDiscoveryTrait(int strategyId) {
        this.strategyId = strategyId;
    }

    public BranchDiscoveryTrait(boolean buildBranch, boolean buildBranchWithPr) {
        this.strategyId = (buildBranch ? 1 : 0) + (buildBranchWithPr ? 2 : 0);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranch() {
        return (this.strategyId & 1) != 0;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranchesWithPR() {
        return (this.strategyId & 2) != 0;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitHubSCMSourceContext ctx = (GitHubSCMSourceContext)context;
        ctx.wantBranches(true);
        ctx.withAuthority(new BranchSCMHeadAuthority());
        switch (this.strategyId) {
            case 1: {
                ctx.wantOriginPRs(true);
                ctx.withFilter(new ExcludeOriginPRBranchesSCMHeadFilter());
                break;
            }
            case 2: {
                ctx.wantOriginPRs(true);
                ctx.withFilter(new OnlyOriginPRBranchesSCMHeadFilter());
                break;
            }
        }
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    public static class OnlyOriginPRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GitHubSCMSourceRequest) {
                for (GHPullRequest p : ((GitHubSCMSourceRequest)request).getPullRequests()) {
                    GHRepository headRepo = p.getHead().getRepository();
                    if (headRepo == null || !p.getBase().getRepository().getFullName().equalsIgnoreCase(headRepo.getFullName()) || !p.getHead().getRef().equals(head.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class ExcludeOriginPRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GitHubSCMSourceRequest) {
                for (GHPullRequest p : ((GitHubSCMSourceRequest)request).getPullRequests()) {
                    GHRepository headRepo = p.getHead().getRepository();
                    if (headRepo == null || !p.getBase().getRepository().getFullName().equalsIgnoreCase(headRepo.getFullName()) || !p.getHead().getRef().equals(head.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class BranchSCMHeadAuthority
    extends SCMHeadAuthority<SCMSourceRequest, BranchSCMHead, SCMRevision> {
        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull BranchSCMHead head) {
            return true;
        }

        @Symbol(value={"gitHubBranchHeadAuthority"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.BranchDiscoveryTrait_authorityDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Default.class.isAssignableFrom(originClass);
            }
        }
    }

    @Symbol(value={"gitHubBranchDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.BranchDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitHubSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitHubSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.BranchDiscoveryTrait_excludePRs(), "1");
            result.add(Messages.BranchDiscoveryTrait_onlyPRs(), "2");
            result.add(Messages.BranchDiscoveryTrait_allBranches(), "3");
            return result;
        }
    }
}

