/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubWebHook;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.github_branch_source.GitHubConsoleNote;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMProbe;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.extras.OkHttpConnector;

public class Connector {
    private static final Logger LOGGER = Logger.getLogger(Connector.class.getName());
    private static final Map<GitHub, Long> lastUsed = new HashMap<GitHub, Long>();
    private static final Map<Details, GitHub> githubs = new HashMap<Details, GitHub>();
    private static final Map<GitHub, Integer> usage = new HashMap<GitHub, Integer>();
    private static final Map<TaskListener, Map<GitHub, Void>> checked = new WeakHashMap<TaskListener, Map<GitHub, Void>>();
    private static final long API_URL_REVALIDATE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final Map<String, Long> apiUrlValid = new LinkedHashMap<String, Long>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
            Long t = eldest.getValue();
            return t == null || t < System.currentTimeMillis() - API_URL_REVALIDATE_MILLIS;
        }
    };
    private static final double MILLIS_PER_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final Random ENTROPY = new Random();
    private static final String SALT = Long.toHexString(ENTROPY.nextLong());
    public static final RateLimitHandler CUSTOMIZED = new RateLimitHandler(){

        public void onError(IOException e, HttpURLConnection uc) throws IOException {
            try {
                long limit = Long.parseLong(uc.getHeaderField("X-RateLimit-Limit"));
                long remaining = Long.parseLong(uc.getHeaderField("X-RateLimit-Remaining"));
                long reset = Long.parseLong(uc.getHeaderField("X-RateLimit-Reset"));
                throw new RateLimitExceededException("GitHub API rate limit exceeded", limit, remaining, reset);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        }
    };

    private Connector() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    @NonNull
    public static ListBoxModel listScanCredentials(@CheckForNull SCMSourceOwner context, String apiUri) {
        return Connector.listScanCredentials((Item)context, apiUri);
    }

    @NonNull
    public static ListBoxModel listScanCredentials(@CheckForNull Item context, String apiUri) {
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, Connector.githubDomainRequirements(apiUri), Connector.githubScanCredentialsMatcher());
    }

    @Deprecated
    public static FormValidation checkScanCredentials(@CheckForNull SCMSourceOwner context, String apiUri, String scanCredentialsId) {
        return Connector.checkScanCredentials((Item)context, apiUri, scanCredentialsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation checkScanCredentials(@CheckForNull Item context, String apiUri, String scanCredentialsId) {
        if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
            return FormValidation.ok();
        }
        if (!scanCredentialsId.isEmpty()) {
            FormValidation formValidation;
            ListBoxModel options = Connector.listScanCredentials(context, apiUri);
            boolean found = false;
            for (ListBoxModel.Option b : options) {
                if (!scanCredentialsId.equals(b.value)) continue;
                found = true;
                break;
            }
            if (!found) {
                return FormValidation.error((String)"Credentials not found");
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok((String)"Credentials found");
            }
            StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, scanCredentialsId);
            if (credentials == null) {
                return FormValidation.error((String)"Credentials not found");
            }
            GitHub connector = Connector.connect(apiUri, credentials);
            try {
                formValidation = FormValidation.ok((String)"User %s", (Object[])new Object[]{connector.getMyself().getLogin()});
            }
            catch (IOException e) {
                FormValidation formValidation2;
                try {
                    formValidation2 = FormValidation.error((String)"Invalid credentials");
                }
                catch (Throwable throwable) {
                    try {
                        Connector.release(connector);
                        throw throwable;
                    }
                    catch (IOException e2) {
                        LOGGER.log(Level.WARNING, "Exception validating credentials {0} on {1}", new Object[]{CredentialsNameProvider.name((Credentials)credentials), apiUri});
                        return FormValidation.error((String)"Exception validating credentials");
                    }
                }
                Connector.release(connector);
                return formValidation2;
            }
            Connector.release(connector);
            return formValidation;
        }
        return FormValidation.warning((String)"Credentials are recommended");
    }

    @Deprecated
    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull SCMSourceOwner context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        return Connector.lookupScanCredentials((Item)context, apiUri, scanCredentialsId);
    }

    @CheckForNull
    public static StandardCredentials lookupScanCredentials(@CheckForNull Item context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        if (Util.fixEmpty((String)scanCredentialsId) == null) {
            return null;
        }
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), Connector.githubDomainRequirements(apiUri)), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), Connector.githubScanCredentialsMatcher()}));
    }

    @NonNull
    public static ListBoxModel listCheckoutCredentials(@CheckForNull SCMSourceOwner context, String apiUri) {
        return Connector.listCheckoutCredentials((Item)context, apiUri);
    }

    @NonNull
    public static ListBoxModel listCheckoutCredentials(@CheckForNull Item context, String apiUri) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        result.add("- same as scan credentials -", "SAME");
        result.add("- anonymous -", "ANONYMOUS");
        return result.includeMatchingAs(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, Connector.githubDomainRequirements(apiUri), GitClient.CREDENTIALS_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkApiUrlValidity(@Nonnull GitHub gitHub, @CheckForNull StandardCredentials credentials) throws IOException {
        String hash;
        if (credentials == null) {
            hash = "anonymous";
        } else if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
            hash = Util.getDigestOf((String)(c.getPassword().getPlainText() + SALT));
        } else {
            throw new IOException("Unsupported credential type: " + credentials.getClass().getName());
        }
        String key = gitHub.getApiUrl() + "::" + hash;
        Map<String, Long> map = apiUrlValid;
        synchronized (map) {
            Long last = apiUrlValid.get(key);
            if (last != null && last > System.currentTimeMillis() - API_URL_REVALIDATE_MILLIS) {
                return;
            }
            gitHub.checkApiUrlValidity();
            apiUrlValid.put(key, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static GitHub connect(@CheckForNull String apiUri, @CheckForNull StandardCredentials credentials) throws IOException {
        String authHash;
        String hash;
        String password;
        String username;
        String apiUrl = Util.fixEmptyAndTrim((String)apiUri);
        apiUrl = apiUrl != null ? apiUrl : "https://api.github.com";
        Jenkins jenkins = Jenkins.get();
        if (credentials == null) {
            username = null;
            password = null;
            hash = "anonymous";
            authHash = "anonymous";
        } else if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
            username = c.getUsername();
            password = c.getPassword().getPlainText();
            hash = Util.getDigestOf((String)(password + SALT));
            authHash = Util.getDigestOf((String)(password + "::" + jenkins.getLegacyInstanceId()));
        } else {
            throw new IOException("Unsupported credential type: " + credentials.getClass().getName());
        }
        Map<Details, GitHub> map = githubs;
        synchronized (map) {
            String host;
            Details details = new Details(apiUrl, hash);
            GitHub hub = githubs.get(details);
            if (hub != null) {
                Integer count = usage.get(hub);
                usage.put(hub, count == null ? 1 : Math.max(count + 1, 1));
                return hub;
            }
            try {
                host = new URL(apiUrl).getHost();
            }
            catch (MalformedURLException e) {
                throw new IOException("Invalid GitHub API URL: " + apiUrl, e);
            }
            GitHubBuilder gb = new GitHubBuilder();
            gb.withEndpoint(apiUrl);
            gb.withRateLimitHandler(CUSTOMIZED);
            OkHttpClient client = new OkHttpClient().setProxy(Connector.getProxy(host));
            int cacheSize = GitHubSCMSource.getCacheSize();
            if (cacheSize > 0) {
                File cacheBase = new File(jenkins.getRootDir(), GitHubSCMProbe.class.getName() + ".cache");
                File cacheDir = null;
                try {
                    MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                    sha256.update(apiUrl.getBytes(StandardCharsets.UTF_8));
                    sha256.update("::".getBytes(StandardCharsets.UTF_8));
                    if (username != null) {
                        sha256.update(username.getBytes(StandardCharsets.UTF_8));
                    }
                    sha256.update("::".getBytes(StandardCharsets.UTF_8));
                    sha256.update(authHash.getBytes(StandardCharsets.UTF_8));
                    cacheDir = new File(cacheBase, Base64.encodeBase64URLSafeString((byte[])sha256.digest()));
                }
                catch (NoSuchAlgorithmException sha256) {
                    // empty catch block
                }
                if (cacheDir != null) {
                    Cache cache = new Cache(cacheDir, (long)cacheSize * 1024L * 1024L);
                    client.setCache(cache);
                }
            }
            if (client.getCache() != null) {
                gb.withConnector((HttpConnector)new ForceValidationOkHttpConnector(new OkUrlFactory(client)));
            } else {
                gb.withConnector((HttpConnector)new OkHttpConnector(new OkUrlFactory(client)));
            }
            if (username != null) {
                gb.withPassword(username, password);
            }
            hub = gb.build();
            githubs.put(details, hub);
            usage.put(hub, 1);
            lastUsed.remove(hub);
            return hub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(@CheckForNull GitHub hub) {
        if (hub == null) {
            return;
        }
        Map<Details, GitHub> map = githubs;
        synchronized (map) {
            Integer count = usage.get(hub);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                usage.put(hub, 0);
                lastUsed.put(hub, System.currentTimeMillis());
            } else {
                usage.put(hub, count - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unused(@Nonnull GitHub hub) {
        Map<Details, GitHub> map = githubs;
        synchronized (map) {
            Integer count = usage.get(hub);
            if (count == null) {
                return;
            }
            if (count <= 1) {
                usage.remove(hub);
                Iterator<Map.Entry<Details, GitHub>> iterator = githubs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Details, GitHub> entry = iterator.next();
                    if (hub != entry.getValue()) continue;
                    iterator.remove();
                    break;
                }
            }
        }
    }

    private static CredentialsMatcher githubScanCredentialsMatcher() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
    }

    static List<DomainRequirement> githubDomainRequirements(String apiUri) {
        return URIRequirementBuilder.fromUri((String)StringUtils.defaultIfEmpty((String)apiUri, (String)"https://github.com")).build();
    }

    @Nonnull
    private static Proxy getProxy(@Nonnull String host) {
        Jenkins jenkins = GitHubWebHook.getJenkinsInstance();
        if (jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }

    static boolean isCredentialValid(GitHub gitHub) {
        if (gitHub.isAnonymous()) {
            return true;
        }
        try {
            gitHub.getMyself();
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception validating credentials on " + gitHub.getApiUrl(), e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkConnectionValidity(String apiUri, @NonNull TaskListener listener, StandardCredentials credentials, GitHub github) throws IOException {
        Map<Details, GitHub> map = githubs;
        synchronized (map) {
            Map<GitHub, Void> hubs = checked.get(listener);
            if (hubs != null && hubs.containsKey(github)) {
                return;
            }
            if (hubs == null) {
                hubs = new WeakHashMap<GitHub, Void>();
                checked.put(listener, hubs);
            }
            hubs.put(github, null);
        }
        if (credentials != null && !Connector.isCredentialValid(github)) {
            String message = String.format("Invalid scan credentials %s to connect to %s, skipping", CredentialsNameProvider.name((Credentials)credentials), apiUri == null ? "https://api.github.com" : apiUri);
            throw new AbortException(message);
        }
        if (!github.isAnonymous()) {
            assert (credentials != null);
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Connecting to %s using %s", apiUri == null ? "https://api.github.com" : apiUri, CredentialsNameProvider.name((Credentials)credentials))));
        } else {
            listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("Connecting to %s with no credentials, anonymous access", apiUri == null ? "https://api.github.com" : apiUri)));
        }
    }

    static void checkApiRateLimit(@NonNull TaskListener listener, GitHub github) throws IOException, InterruptedException {
        boolean check = true;
        block0: while (check) {
            long expiration;
            int burst;
            check = false;
            long start = System.currentTimeMillis();
            GHRateLimit rateLimit = github.rateLimit();
            long rateLimitResetMillis = rateLimit.getResetDate().getTime() - start;
            double resetProgress = (double)rateLimitResetMillis / MILLIS_PER_HOUR;
            int buffer = Math.max(15, rateLimit.limit / 20);
            int ideal = (int)((double)(rateLimit.limit - buffer - (burst = rateLimit.limit < 1000 ? Math.max(5, rateLimit.limit / 10) : Math.max(200, rateLimit.limit / 5))) * resetProgress) + buffer;
            if (rateLimit.remaining >= ideal && rateLimit.remaining < ideal + buffer) {
                listener.getLogger().println(GitHubConsoleNote.create(start, String.format("GitHub API Usage: Current quota has %d remaining (%d under budget). Next quota of %d in %s", rateLimit.remaining, rateLimit.remaining - ideal, rateLimit.limit, Util.getTimeSpanString((long)rateLimitResetMillis))));
                continue;
            }
            if (rateLimit.remaining >= ideal) continue;
            check = true;
            if (rateLimit.remaining < buffer) {
                if (rateLimitResetMillis < 0L) {
                    expiration = System.currentTimeMillis() + (long)ENTROPY.nextInt(65536);
                    listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("GitHub API Usage: Current quota has %d remaining (%d over budget). Next quota of %d due now. Sleeping for %s.", rateLimit.remaining, ideal - rateLimit.remaining, rateLimit.limit, Util.getTimeSpanString((long)(expiration - System.currentTimeMillis())))));
                } else {
                    expiration = rateLimit.getResetDate().getTime() + (long)ENTROPY.nextInt(65536);
                    listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("GitHub API Usage: Current quota has %d remaining (%d over budget). Next quota of %d in %s. Sleeping until reset.", rateLimit.remaining, ideal - rateLimit.remaining, rateLimit.limit, Util.getTimeSpanString((long)rateLimitResetMillis))));
                }
            } else {
                double targetFraction = ((double)rateLimit.remaining - (double)buffer * 1.1) / (double)(rateLimit.limit - buffer - burst);
                expiration = rateLimit.getResetDate().getTime() - Math.max(0L, (long)(targetFraction * MILLIS_PER_HOUR)) + (long)ENTROPY.nextInt(1000);
                listener.getLogger().println(GitHubConsoleNote.create(System.currentTimeMillis(), String.format("GitHub API Usage: Current quota has %d remaining (%d over budget). Next quota of %d in %s. Sleeping for %s.", rateLimit.remaining, ideal - rateLimit.remaining, rateLimit.limit, Util.getTimeSpanString((long)rateLimitResetMillis), Util.getTimeSpanString((long)(expiration - System.currentTimeMillis())))));
            }
            long nextNotify = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(3L);
            while (expiration > System.currentTimeMillis()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long sleep = Math.min(expiration, nextNotify) - System.currentTimeMillis();
                if (sleep > 0L) {
                    Thread.sleep(sleep);
                }
                nextNotify += TimeUnit.SECONDS.toMillis(180L);
                long now = System.currentTimeMillis();
                if (now >= expiration) continue;
                GHRateLimit current = github.getRateLimit();
                if (current.remaining > rateLimit.remaining || current.getResetDate().getTime() > rateLimit.getResetDate().getTime()) {
                    listener.getLogger().println(GitHubConsoleNote.create(now, "GitHub API Usage: The quota may have been refreshed earlier than expected, rechecking..."));
                    continue block0;
                }
                listener.getLogger().println(GitHubConsoleNote.create(now, String.format("GitHub API Usage: Still sleeping, now only %s remaining.", Util.getTimeSpanString((long)(expiration - now)))));
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    static class ForceValidationOkHttpConnector
    implements HttpConnector {
        private static final String FORCE_VALIDATION = new CacheControl.Builder().maxAge(0, TimeUnit.SECONDS).build().toString();
        private static final String HEADER_NAME = "Cache-Control";
        private final OkHttpConnector delegate;

        public ForceValidationOkHttpConnector(OkUrlFactory okUrlFactory) {
            this.delegate = new OkHttpConnector(okUrlFactory);
        }

        OkHttpConnector getDelegate() {
            return this.delegate;
        }

        public HttpURLConnection connect(URL url) throws IOException {
            HttpURLConnection connection = this.delegate.connect(url);
            connection.setRequestProperty(HEADER_NAME, FORCE_VALIDATION);
            return connection;
        }
    }

    private static class Details {
        private final String apiUrl;
        private final String credentialsHash;

        private Details(String apiUrl, String credentialsHash) {
            this.apiUrl = apiUrl;
            this.credentialsHash = credentialsHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Details details = (Details)o;
            if (this.apiUrl == null ? details.apiUrl != null : !this.apiUrl.equals(details.apiUrl)) {
                return false;
            }
            return StringUtils.equals((String)this.credentialsHash, (String)details.credentialsHash);
        }

        public int hashCode() {
            return this.apiUrl != null ? this.apiUrl.hashCode() : 0;
        }

        public String toString() {
            return "Details{apiUrl='" + this.apiUrl + '\'' + ", credentialsHash=" + this.credentialsHash + '}';
        }
    }

    @Extension
    public static class UnusedConnectionDestroyer
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(15L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            long threshold = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
            Map map = githubs;
            synchronized (map) {
                Iterator iterator = lastUsed.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Long lastUse = (Long)entry.getValue();
                    if (lastUse != null && lastUse >= threshold) continue;
                    iterator.remove();
                    Connector.unused((GitHub)entry.getKey());
                }
            }
        }
    }
}

