/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import java.net.URL;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.kohsuke.stapler.Stapler;

public class GitHubLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;

    public GitHubLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
    }

    public GitHubLink(String iconClassName, URL url) {
        this(iconClassName, url.toExternalForm());
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getIconClassName() {
        return this.iconClassName;
    }

    public String getIconFileName() {
        Icon icon;
        String iconClassName = this.getIconClassName();
        if (iconClassName != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.GitHubLink_DisplayName();
    }

    public String getUrlName() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHubLink that = (GitHubLink)o;
        if (!this.iconClassName.equals(that.iconClassName)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.iconClassName.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public String toString() {
        return "GitHubLink{iconClassName='" + this.iconClassName + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

