/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.kohsuke.github.GHCommitState;

public final class GitHubNotificationContext {
    private final Job<?, ?> job;
    private final Run<?, ?> build;
    private final SCMSource source;
    private final SCMHead head;

    private GitHubNotificationContext(Job<?, ?> job, Run<?, ?> build, SCMSource source, SCMHead head) {
        this.job = job;
        this.build = build;
        this.source = source;
        this.head = head;
    }

    public static GitHubNotificationContext build(@Nullable Job<?, ?> job, @Nullable Run<?, ?> build, SCMSource source, SCMHead head) {
        return new GitHubNotificationContext(job, build, source, head);
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public SCMSource getSource() {
        return this.source;
    }

    public SCMHead getHead() {
        return this.head;
    }

    public String toString() {
        return "GitHubNotificationContext{job=" + this.job + ", build=" + this.build + ", source=" + this.source + ", head=" + this.head + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitHubNotificationContext that = (GitHubNotificationContext)o;
        if (this.job != null ? !this.job.equals(that.job) : that.job != null) {
            return false;
        }
        if (this.build != null ? !this.build.equals(that.build) : that.build != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals((Object)that.source) : that.source != null) {
            return false;
        }
        return this.head != null ? this.head.equals((Object)that.head) : that.head == null;
    }

    public int hashCode() {
        int result = this.job != null ? this.job.hashCode() : 0;
        result = 31 * result + (this.build != null ? this.build.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.head != null ? this.head.hashCode() : 0);
        return result;
    }

    public String getDefaultContext(TaskListener listener) {
        if (this.head instanceof PullRequestSCMHead) {
            if (((PullRequestSCMHead)this.head).isMerge()) {
                return "continuous-integration/jenkins/pr-merge";
            }
            return "continuous-integration/jenkins/pr-head";
        }
        return "continuous-integration/jenkins/branch";
    }

    public String getDefaultUrl(TaskListener listener) {
        String url = null;
        try {
            if (null != this.build) {
                url = DisplayURLProvider.get().getRunURL(this.build);
            } else if (null != this.job) {
                url = DisplayURLProvider.get().getJobURL(this.job);
            }
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("Can not determine Jenkins root URL. Commit status notifications are sent without URL until a root URL is configured in Jenkins global configuration.");
        }
        return url;
    }

    public String getDefaultMessage(TaskListener listener) {
        if (null != this.build) {
            Result result = this.build.getResult();
            if (Result.SUCCESS.equals(result)) {
                return Messages.GitHubBuildStatusNotification_CommitStatus_Good();
            }
            if (Result.UNSTABLE.equals(result)) {
                return Messages.GitHubBuildStatusNotification_CommitStatus_Unstable();
            }
            if (Result.FAILURE.equals(result)) {
                return Messages.GitHubBuildStatusNotification_CommitStatus_Failure();
            }
            if (Result.ABORTED.equals(result)) {
                return Messages.GitHubBuildStatusNotification_CommitStatus_Aborted();
            }
            if (result != null) {
                return Messages.GitHubBuildStatusNotification_CommitStatus_Other();
            }
            return Messages.GitHubBuildStatusNotification_CommitStatus_Pending();
        }
        return Messages.GitHubBuildStatusNotification_CommitStatus_Queued();
    }

    public GHCommitState getDefaultState(TaskListener listener) {
        if (null != this.build && !this.build.isBuilding()) {
            Result result = this.build.getResult();
            if (Result.SUCCESS.equals(result)) {
                return GHCommitState.SUCCESS;
            }
            if (Result.UNSTABLE.equals(result)) {
                return GHCommitState.FAILURE;
            }
            if (Result.FAILURE.equals(result)) {
                return GHCommitState.ERROR;
            }
            if (Result.ABORTED.equals(result)) {
                return GHCommitState.ERROR;
            }
            if (result != null) {
                return GHCommitState.ERROR;
            }
        }
        return GHCommitState.PENDING;
    }

    public boolean getDefaultIgnoreError(TaskListener listener) {
        return null == this.build || null == this.build.getResult();
    }
}

