/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceEvent;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;

@Extension
public class GitHubRepositoryEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(GitHubRepositoryEventSubscriber.class.getName());
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected boolean isApplicable(@Nullable Item item) {
        if (item instanceof SCMNavigatorOwner) {
            for (SCMNavigator navigator : ((SCMNavigatorOwner)item).getSCMNavigators()) {
                if (!(navigator instanceof GitHubSCMNavigator)) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.REPOSITORY, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            GHEventPayload.Repository p = (GHEventPayload.Repository)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.Repository.class);
            String action = p.getAction();
            String repoUrl = p.getRepository().getHtmlUrl().toExternalForm();
            LOGGER.log(Level.FINE, "Received {0} for {1} from {2}", new Object[]{event.getGHEvent(), repoUrl, event.getOrigin()});
            boolean fork = p.getRepository().isFork();
            Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
            if (matcher.matches()) {
                GitHubRepositoryName repo = GitHubRepositoryName.create((String)repoUrl);
                if (repo == null) {
                    LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
                    return;
                }
                if (!"created".equals(action)) {
                    LOGGER.log(Level.FINE, "Repository {0} was {1} not created, will be ignored", new Object[]{repo.getRepositoryName(), action});
                    return;
                }
                if (!fork) {
                    LOGGER.log(Level.FINE, "Repository {0} was created but it is empty, will be ignored", repo.getRepositoryName());
                    return;
                }
                NewSCMSourceEvent e = new NewSCMSourceEvent(event.getTimestamp(), event.getOrigin(), p, repo);
                SCMSourceEvent.fireLater((SCMSourceEvent)e, (long)GitHubSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
            } else {
                LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
            }
        }
        catch (IOException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Could not parse {0} event from {1} with payload: {2}");
            lr.setParameters(new Object[]{event.getGHEvent(), event.getOrigin(), event.getPayload()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
    }

    private static class NewSCMSourceEvent
    extends SCMSourceEvent<GHEventPayload.Repository> {
        private final String repoHost;
        private final String repoOwner;
        private final String repository;

        public NewSCMSourceEvent(long timestamp, String origin, GHEventPayload.Repository event, GitHubRepositoryName repo) {
            super(SCMEvent.Type.CREATED, timestamp, (Object)event, origin);
            this.repoHost = repo.getHost();
            this.repoOwner = event.getRepository().getOwnerName();
            this.repository = event.getRepository().getName();
        }

        private boolean isApiMatch(String apiUri) {
            return this.repoHost.equalsIgnoreCase(RepositoryUriResolver.hostnameFromApiUri(apiUri));
        }

        public boolean isMatch(@NonNull SCMNavigator navigator) {
            return navigator instanceof GitHubSCMNavigator && this.isApiMatch(((GitHubSCMNavigator)navigator).getApiUri()) && this.repoOwner.equalsIgnoreCase(((GitHubSCMNavigator)navigator).getRepoOwner());
        }

        public boolean isMatch(@NonNull SCMSource source) {
            return source instanceof GitHubSCMSource && this.isApiMatch(((GitHubSCMSource)source).getApiUri()) && this.repoOwner.equalsIgnoreCase(((GitHubSCMSource)source).getRepoOwner()) && this.repository.equalsIgnoreCase(((GitHubSCMSource)source).getRepository());
        }

        @NonNull
        public String getSourceName() {
            return this.repository;
        }
    }
}

