/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.apache.commons.lang.time.FastDateFormat;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubClosable;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMFile;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubTagSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTagObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.PagedIterator;

public class GitHubSCMFileSystem
extends SCMFileSystem
implements GitHubClosable {
    private final GitHub gitHub;
    private final GHRepository repo;
    private final String ref;
    private boolean open;

    protected GitHubSCMFileSystem(GitHub gitHub, GHRepository repo, String refName, @CheckForNull SCMRevision rev) throws IOException {
        super(rev);
        this.gitHub = gitHub;
        this.open = true;
        this.repo = repo;
        if (rev != null) {
            if (rev.getHead() instanceof PullRequestSCMHead) {
                PullRequestSCMHead pr = (PullRequestSCMHead)rev.getHead();
                assert (!pr.isMerge());
                this.ref = ((PullRequestSCMRevision)rev).getPullHash();
            } else {
                this.ref = rev instanceof AbstractGitSCMSource.SCMRevisionImpl ? ((AbstractGitSCMSource.SCMRevisionImpl)rev).getHash() : refName;
            }
        } else {
            this.ref = refName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        GitHubSCMFileSystem gitHubSCMFileSystem = this;
        synchronized (gitHubSCMFileSystem) {
            if (!this.open) {
                return;
            }
            this.open = false;
        }
        Connector.release(this.gitHub);
    }

    @Override
    public synchronized boolean isOpen() {
        return this.open;
    }

    public long lastModified() throws IOException {
        return this.repo.getCommit(this.ref).getCommitDate().getTime();
    }

    public boolean changesSince(SCMRevision revision, @NonNull OutputStream changeLogStream) throws UnsupportedOperationException, IOException, InterruptedException {
        GHCommit commit;
        if (Objects.equals(this.getRevision(), revision)) {
            return false;
        }
        int count = 0;
        FastDateFormat iso = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZ");
        StringBuilder log = new StringBuilder(1024);
        String endHash = revision instanceof AbstractGitSCMSource.SCMRevisionImpl ? ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash().toLowerCase(Locale.ENGLISH) : null;
        PagedIterator pagedIterator = this.repo.queryCommits().from(this.ref).pageSize(GitSCM.MAX_CHANGELOG).list().iterator();
        while (pagedIterator.hasNext() && !(commit = (GHCommit)pagedIterator.next()).getSHA1().toLowerCase(Locale.ENGLISH).equals(endHash)) {
            log.setLength(0);
            log.append("commit ").append(commit.getSHA1()).append('\n');
            log.append("tree ").append(commit.getTree().getSha()).append('\n');
            log.append("parent");
            for (String parent : commit.getParentSHA1s()) {
                log.append(' ').append(parent);
            }
            log.append('\n');
            GHCommit.ShortInfo info = commit.getCommitShortInfo();
            log.append("author ").append(info.getAuthor().getName()).append(" <").append(info.getAuthor().getEmail()).append("> ").append(iso.format(info.getAuthoredDate())).append('\n');
            log.append("committer ").append(info.getCommitter().getName()).append(" <").append(info.getCommitter().getEmail()).append("> ").append(iso.format(info.getCommitDate())).append('\n');
            log.append('\n');
            String msg = info.getMessage();
            if (msg.endsWith("\r\n")) {
                msg = msg.substring(0, msg.length() - 2);
            } else if (msg.endsWith("\n")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            msg = msg.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "\n    ");
            log.append("    ").append(msg).append('\n');
            changeLogStream.write(log.toString().getBytes(StandardCharsets.UTF_8));
            changeLogStream.flush();
            if (++count < GitSCM.MAX_CHANGELOG) continue;
            break;
        }
        return count > 0;
    }

    @NonNull
    public SCMFile getRoot() {
        return new GitHubSCMFile(this, this.repo, this.ref);
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof GitHubSCMSource;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return scmSourceDescriptor instanceof GitHubSCMSource.DescriptorImpl;
        }

        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) {
            return null;
        }

        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            GitHubSCMSource src = (GitHubSCMSource)source;
            String apiUri = src.getApiUri();
            StandardCredentials credentials = Connector.lookupScanCredentials((Item)src.getOwner(), apiUri, src.getScanCredentialsId());
            GitHub github = Connector.connect(apiUri, credentials);
            try {
                String refName;
                try {
                    Connector.checkApiUrlValidity(github, credentials);
                }
                catch (HttpException e) {
                    String message = String.format("It seems %s is unreachable", apiUri == null ? "https://api.github.com" : apiUri);
                    throw new IOException(message);
                }
                if (head instanceof BranchSCMHead) {
                    refName = "heads/" + head.getName();
                } else if (head instanceof GitHubTagSCMHead) {
                    refName = "tags/" + head.getName();
                } else {
                    if (head instanceof PullRequestSCMHead) {
                        PullRequestSCMHead pr = (PullRequestSCMHead)head;
                        if (!pr.isMerge() && pr.getSourceRepo() != null) {
                            GHUser user = github.getUser(pr.getSourceOwner());
                            if (user == null) {
                                Connector.release(github);
                                return null;
                            }
                            GHRepository repo = user.getRepository(pr.getSourceRepo());
                            if (repo == null) {
                                Connector.release(github);
                                return null;
                            }
                            return new GitHubSCMFileSystem(github, repo, pr.getSourceBranch(), rev);
                        }
                        Connector.release(github);
                        return null;
                    }
                    Connector.release(github);
                    return null;
                }
                GHUser user = github.getUser(src.getRepoOwner());
                if (user == null) {
                    Connector.release(github);
                    return null;
                }
                GHRepository repo = user.getRepository(src.getRepository());
                if (repo == null) {
                    Connector.release(github);
                    return null;
                }
                if (rev == null) {
                    GHRef ref = repo.getRef(refName);
                    if ("tag".equalsIgnoreCase(ref.getObject().getType())) {
                        GHTagObject tag = repo.getTagObject(ref.getObject().getSha());
                        rev = head instanceof GitHubTagSCMHead ? new GitTagSCMRevision((GitTagSCMHead)((GitHubTagSCMHead)head), tag.getObject().getSha()) : new GitTagSCMRevision((GitTagSCMHead)new GitHubTagSCMHead(head.getName(), tag.getTagger().getDate().getTime()), tag.getObject().getSha());
                    } else {
                        rev = new AbstractGitSCMSource.SCMRevisionImpl(head, ref.getObject().getSha());
                    }
                }
                return new GitHubSCMFileSystem(github, repo, refName, rev);
            }
            catch (IOException | RuntimeException e) {
                Connector.release(github);
                throw e;
            }
        }
    }
}

