/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.GitHubTagSCMHead;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

@Extension
public class PushGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(PushGHEventSubscriber.class.getName());
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected boolean isApplicable(@Nullable Item project) {
        if (project != null) {
            SCMSourceOwner owner;
            if (project instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project;
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
            if (project.getParent() instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project.getParent();
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PUSH, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            GHEventPayload.Push p = (GHEventPayload.Push)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.Push.class);
            String repoUrl = p.getRepository().getHtmlUrl().toExternalForm();
            LOGGER.log(Level.FINE, "Received {0} for {1} from {2}", new Object[]{event.getGHEvent(), repoUrl, event.getOrigin()});
            Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
            if (matcher.matches()) {
                GitHubRepositoryName changedRepository = GitHubRepositoryName.create((String)repoUrl);
                if (changedRepository == null) {
                    LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
                    return;
                }
                if (p.isCreated()) {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.CREATED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                } else if (p.isDeleted()) {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.REMOVED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                } else {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.UPDATED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                }
            } else {
                LOGGER.log(Level.WARNING, "{0} does not match expected repository name pattern", repoUrl);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Could not parse {0} event from {1} with payload: {2}");
            lr.setParameters(new Object[]{event.getGHEvent(), event.getOrigin(), event.getPayload()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
    }

    private void fireAfterDelay(SCMHeadEventImpl e) {
        SCMHeadEvent.fireLater((SCMHeadEvent)e, (long)GitHubSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
    }

    private static class SCMHeadEventImpl
    extends SCMHeadEvent<GHEventPayload.Push> {
        private static final String R_HEADS = "refs/heads/";
        private static final String R_TAGS = "refs/tags/";
        private final String repoHost;
        private final String repoOwner;
        private final String repository;

        public SCMHeadEventImpl(SCMEvent.Type type, long timestamp, GHEventPayload.Push pullRequest, GitHubRepositoryName repo, String origin) {
            super(type, timestamp, (Object)pullRequest, origin);
            this.repoHost = repo.getHost();
            this.repoOwner = pullRequest.getRepository().getOwnerName();
            this.repository = pullRequest.getRepository().getName();
        }

        private boolean isApiMatch(String apiUri) {
            return this.repoHost.equalsIgnoreCase(RepositoryUriResolver.hostnameFromApiUri(apiUri));
        }

        public boolean isMatch(@NonNull SCMNavigator navigator) {
            return navigator instanceof GitHubSCMNavigator && this.repoOwner.equalsIgnoreCase(((GitHubSCMNavigator)navigator).getRepoOwner());
        }

        public String descriptionFor(@NonNull SCMNavigator navigator) {
            String ref = ((GHEventPayload.Push)this.getPayload()).getRef();
            if (ref.startsWith(R_TAGS)) {
                ref = ref.substring(R_TAGS.length());
                return "Push event for tag " + ref + " in repository " + this.repository;
            }
            if (ref.startsWith(R_HEADS)) {
                ref = ref.substring(R_HEADS.length());
            }
            return "Push event to branch " + ref + " in repository " + this.repository;
        }

        public String descriptionFor(SCMSource source) {
            String ref = ((GHEventPayload.Push)this.getPayload()).getRef();
            if (ref.startsWith(R_TAGS)) {
                ref = ref.substring(R_TAGS.length());
                return "Push event for tag " + ref;
            }
            if (ref.startsWith(R_HEADS)) {
                ref = ref.substring(R_HEADS.length());
            }
            return "Push event to branch " + ref;
        }

        public String description() {
            String ref = ((GHEventPayload.Push)this.getPayload()).getRef();
            if (ref.startsWith(R_TAGS)) {
                ref = ref.substring(R_TAGS.length());
                return "Push event for tag " + ref + " in repository " + this.repoOwner + "/" + this.repository;
            }
            if (ref.startsWith(R_HEADS)) {
                ref = ref.substring(R_HEADS.length());
            }
            return "Push event to branch " + ref + " in repository " + this.repoOwner + "/" + this.repository;
        }

        @NonNull
        public String getSourceName() {
            return this.repository;
        }

        @NonNull
        public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
            boolean excluded;
            Object head;
            if (!(source instanceof GitHubSCMSource && this.isApiMatch(((GitHubSCMSource)source).getApiUri()) && this.repoOwner.equalsIgnoreCase(((GitHubSCMSource)source).getRepoOwner()) && this.repository.equalsIgnoreCase(((GitHubSCMSource)source).getRepository()))) {
                return Collections.emptyMap();
            }
            GitHubSCMSource src = (GitHubSCMSource)source;
            GHEventPayload.Push push = (GHEventPayload.Push)this.getPayload();
            GHRepository repo = push.getRepository();
            String repoName = repo.getName();
            if (!repoName.matches("^[0-9A-Za-z._-]+$")) {
                return Collections.emptyMap();
            }
            String repoOwner = push.getRepository().getOwnerName();
            if (!repoOwner.matches("^[A-Za-z0-9](?:[A-Za-z0-9]|-(?=[A-Za-z0-9])){0,38}$")) {
                return Collections.emptyMap();
            }
            if (!push.getHead().matches("^[a-fA-F0-9]{40}$")) {
                return Collections.emptyMap();
            }
            GitHubSCMSourceContext context = (GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(src.getTraits());
            String ref = push.getRef();
            if (context.wantBranches() && !ref.startsWith(R_TAGS)) {
                head = ref.startsWith(R_HEADS) ? new BranchSCMHead(ref.substring(R_HEADS.length())) : new BranchSCMHead(ref);
                excluded = false;
                for (SCMHeadPrefilter prefilter : context.prefilters()) {
                    if (!prefilter.isExcluded(source, (SCMHead)head)) continue;
                    excluded = true;
                    break;
                }
                if (!excluded) {
                    return Collections.singletonMap(head, new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, push.getHead()));
                }
            }
            if (context.wantTags() && ref.startsWith(R_TAGS)) {
                head = new GitHubTagSCMHead(ref.substring(R_TAGS.length()), this.getTimestamp());
                excluded = false;
                for (SCMHeadPrefilter prefilter : context.prefilters()) {
                    if (!prefilter.isExcluded(source, (SCMHead)head)) continue;
                    excluded = true;
                    break;
                }
                if (!excluded) {
                    return Collections.singletonMap(head, new GitTagSCMRevision((GitTagSCMHead)head, push.getHead()));
                }
            }
            return Collections.emptyMap();
        }

        public boolean isMatch(@NonNull SCM scm) {
            return false;
        }
    }
}

