/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.model.Action;
import hudson.model.Actionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractBuildScanAction
implements Action {
    private transient String scanUrl;
    protected transient Actionable target;
    private List<String> scanUrls = new ArrayList<String>();

    public String getIconFileName() {
        return "/plugin/gradle/images/48x48/gradle-build-scan.png";
    }

    public String getDisplayName() {
        return "Build Scan";
    }

    public String getUrlName() {
        return "buildScan";
    }

    public void addScanUrl(String scanUrl) {
        if (!this.scanUrls.contains(scanUrl)) {
            this.scanUrls.add(scanUrl);
        }
    }

    @Exported
    public List<String> getScanUrls() {
        return Collections.unmodifiableList(this.scanUrls);
    }

    private Object readResolve() {
        if (this.scanUrl != null) {
            this.scanUrls = Collections.singletonList(this.scanUrl);
        }
        return this;
    }

    public Actionable getTarget() {
        return this.target;
    }
}

