/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolInstaller;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

@Extension
public class GetGradleCommand
extends CLICommand {
    @Option(name="--name", required=false, usage="[Optional] The name of the gradle installation.  If name is not provided, list all available installations.")
    public String name = null;
    @Option(name="--help", required=false, usage="Print this usage statement")
    public boolean help = false;
    private static final int OK = 0;
    private static final int NOT_FOUND = 1;

    public String getName() {
        return "get-gradle";
    }

    public String getShortDescription() {
        return "List available gradle installations";
    }

    protected int run() throws Exception {
        if (this.help) {
            this.printUsage(this.stderr, new CmdLineParser((Object)this));
            return 0;
        }
        GradleInstallation[] installations = ((GradleInstallation.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(GradleInstallation.DescriptorImpl.class)).getInstallations();
        HashMap map = new HashMap();
        for (GradleInstallation installation : installations) {
            for (Map.Entry entry : installation.getProperties().toMap().entrySet()) {
                DescribableList installers = ((InstallSourceProperty)entry.getValue()).installers;
                ArrayList<String> list = new ArrayList<String>();
                for (ToolInstaller installer : installers) {
                    list.add(((DownloadFromUrlInstaller)installer).id);
                }
                map.put(installation.getName(), list);
            }
        }
        if (this.name == null) {
            JSONObject jsonObject = JSONObject.fromObject(map);
            this.stdout.println(jsonObject);
        } else {
            List returnList = (List)map.get(this.name);
            if (returnList == null) {
                this.stderr.println("Requested gradle installation not found: " + this.name);
                return 1;
            }
            JSONArray jsonArray = JSONArray.fromObject((Object)returnList);
            this.stdout.println(jsonArray);
        }
        return 0;
    }
}

