/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstaller;
import hudson.plugins.gradle.Messages;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class GradleInstallation
extends ToolInstallation
implements EnvironmentSpecific<GradleInstallation>,
NodeSpecific<GradleInstallation>,
Serializable {
    public static final String UNIX_GRADLE_COMMAND = "gradle";
    public static final String WINDOWS_GRADLE_COMMAND = "gradle.bat";
    public static final String UNIX_GRADLE_WRAPPER_COMMAND = "gradlew";
    public static final String WINDOWS_GRADLE_WRAPPER_COMMAND = "gradlew.bat";
    private final String gradleHome = super.getHome();

    @DataBoundConstructor
    public GradleInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, GradleInstallation.launderHome(home), properties);
    }

    private static String launderHome(String home) {
        if (home != null && (home.endsWith("/") || home.endsWith("\\"))) {
            return home.substring(0, home.length() - 1);
        }
        return home;
    }

    public String getHome() {
        if (this.gradleHome != null) {
            return this.gradleHome;
        }
        return super.getHome();
    }

    public void buildEnvVars(EnvVars env) {
        env.put("PATH+GRADLE", this.getHome() + "/bin");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                File exe = GradleInstallation.this.getExeFile();
                if (exe.exists()) {
                    return exe.getPath();
                }
                return null;
            }
        });
    }

    private File getExeFile() {
        String execName = Functions.isWindows() ? WINDOWS_GRADLE_COMMAND : UNIX_GRADLE_COMMAND;
        String antHome = Util.replaceMacro((String)this.gradleHome, (Map)EnvVars.masterEnvVars);
        return new File(antHome, "bin/" + execName);
    }

    public GradleInstallation forEnvironment(EnvVars environment) {
        return new GradleInstallation(this.getName(), environment.expand(this.gradleHome), this.getProperties().toList());
    }

    public GradleInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GradleInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    @Extension
    @Symbol(value={"gradle"})
    public static class DescriptorImpl
    extends ToolDescriptor<GradleInstallation> {
        public String getDisplayName() {
            return Messages.installer_displayName();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new GradleInstaller(null));
        }

        public GradleInstallation[] getInstallations() {
            return DescriptorImpl.getGradleDescriptor().getInstallations();
        }

        public void setInstallations(GradleInstallation ... installations) {
            DescriptorImpl.getGradleDescriptor().setInstallations(installations);
        }

        private static Gradle.DescriptorImpl getGradleDescriptor() {
            return (Gradle.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(Gradle.DescriptorImpl.class);
        }
    }
}

