/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.gradle.BuildScanAction;
import hudson.plugins.gradle.BuildScanFlowAction;
import hudson.plugins.gradle.GradleTaskListenerDecorator;
import hudson.plugins.gradle.WithGradle;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class WithGradleExecution
extends StepExecution {
    public WithGradleExecution(StepContext context, WithGradle withGradle) {
        super(context);
    }

    public boolean start() throws IOException, InterruptedException {
        GradleTaskListenerDecorator decorator = new GradleTaskListenerDecorator();
        this.getContext().newBodyInvoker().withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)this.getContext().get(TaskListenerDecorator.class)), (TaskListenerDecorator)decorator)).withCallback((BodyExecutionCallback)new BuildScanCallback(decorator, this.getContext())).start();
        return false;
    }

    private static class BuildScanCallback
    extends BodyExecutionCallback {
        private final GradleTaskListenerDecorator decorator;
        private final StepContext parentContext;

        public BuildScanCallback(GradleTaskListenerDecorator decorator, StepContext parentContext) {
            this.decorator = decorator;
            this.parentContext = parentContext;
        }

        public void onSuccess(StepContext context, Object result) {
            this.parentContext.onSuccess(this.extractBuildScans(context));
        }

        private List<String> extractBuildScans(StepContext context) {
            try {
                PrintStream logger = ((TaskListener)context.get(TaskListener.class)).getLogger();
                if (this.decorator == null) {
                    logger.println("WARNING: No decorator found, not looking for build scans");
                    return Collections.emptyList();
                }
                List<String> buildScans = this.decorator.getBuildScans();
                if (buildScans.isEmpty()) {
                    return Collections.emptyList();
                }
                Run run = (Run)context.get(Run.class);
                FlowNode flowNode = (FlowNode)context.get(FlowNode.class);
                flowNode.getParents().stream().findFirst().ifPresent(parent -> {
                    BuildScanFlowAction nodeBuildScanAction = new BuildScanFlowAction((FlowNode)parent);
                    buildScans.forEach(nodeBuildScanAction::addScanUrl);
                    parent.addAction((Action)nodeBuildScanAction);
                });
                BuildScanAction existingAction = (BuildScanAction)run.getAction(BuildScanAction.class);
                BuildScanAction buildScanAction = existingAction == null ? new BuildScanAction() : existingAction;
                buildScans.forEach(buildScanAction::addScanUrl);
                if (existingAction == null) {
                    run.addAction((Action)buildScanAction);
                }
                return buildScans;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public void onFailure(StepContext context, Throwable t) {
            this.parentContext.onFailure(t);
            this.extractBuildScans(context);
        }
    }
}

