/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.plugins.gradle.BuildScanPublishedListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildScanLogScanner {
    private final BuildScanPublishedListener listener;
    private int linesSinceBuildScanPublishingMessage = Integer.MAX_VALUE;
    private static final Pattern BUILD_SCAN_PATTERN = Pattern.compile("Publishing (build scan|build information)\\.\\.\\.");
    private static final Pattern URL_PATTERN = Pattern.compile("https?://\\S*");

    public BuildScanLogScanner(BuildScanPublishedListener listener) {
        this.listener = listener;
    }

    void scanLine(String line) {
        if (this.linesSinceBuildScanPublishingMessage < 10) {
            ++this.linesSinceBuildScanPublishingMessage;
            Matcher matcher = URL_PATTERN.matcher(line);
            if (matcher.find()) {
                this.linesSinceBuildScanPublishingMessage = Integer.MAX_VALUE;
                String buildScanUrl = matcher.group();
                this.listener.onBuildScanPublished(buildScanUrl);
            }
        }
        if (BUILD_SCAN_PATTERN.matcher(line).find()) {
            this.linesSinceBuildScanPublishingMessage = 0;
        }
    }
}

