/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.console.LineTransformationOutputStream;
import hudson.plugins.gradle.BuildScanLogScanner;
import hudson.plugins.gradle.BuildScanPublishedListener;
import hudson.plugins.gradle.GradleOutcomeNote;
import hudson.plugins.gradle.GradleTaskNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class GradleConsoleAnnotator
extends LineTransformationOutputStream {
    private static final int MAX_LINE_LENGTH = 500;
    private final OutputStream out;
    private final Charset charset;
    private final boolean annotateGradleOutput;
    private final BuildScanLogScanner buildScanLogScanner;

    public GradleConsoleAnnotator(OutputStream out, Charset charset, boolean annotateGradleOutput, BuildScanPublishedListener buildScanListener) {
        this.out = out;
        this.charset = charset;
        this.annotateGradleOutput = annotateGradleOutput;
        this.buildScanLogScanner = new BuildScanLogScanner(buildScanListener);
    }

    protected void eol(byte[] b, int len) throws IOException {
        if (len < 500) {
            String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
            line = this.trimEOL(line);
            if (this.annotateGradleOutput) {
                if (line.startsWith(":") || line.startsWith("> Task :")) {
                    new GradleTaskNote().encodeTo(this.out);
                }
                if (line.startsWith("BUILD SUCCESSFUL") || line.startsWith("BUILD FAILED")) {
                    new GradleOutcomeNote().encodeTo(this.out);
                }
            }
            this.buildScanLogScanner.scanLine(line);
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

