/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.gradle.injection.BuildScanInjection;
import hudson.plugins.gradle.injection.GradleBuildScanInjection;
import hudson.plugins.gradle.injection.MavenBuildScanInjection;
import hudson.slaves.ComputerListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class BuildScanInjectionListener
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(BuildScanInjectionListener.class.getName());
    private final List<BuildScanInjection> injections = Arrays.asList(new GradleBuildScanInjection(), new MavenBuildScanInjection());

    public void onOnline(Computer c, TaskListener listener) {
        try {
            EnvVars envGlobal = c.buildEnvironment(listener);
            EnvVars envComputer = c.getEnvironment();
            this.inject(c, envGlobal, envComputer);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.info("Error processing scan injection - " + e.getMessage());
        }
    }

    public void onConfigurationChange() {
        EnvironmentVariablesNodeProperty envProperty = (EnvironmentVariablesNodeProperty)Jenkins.get().getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class);
        EnvVars envGlobal = envProperty != null ? envProperty.getEnvVars() : null;
        for (Computer c : Jenkins.get().getComputers()) {
            try {
                EnvVars envComputer = c.getEnvironment();
                this.inject(c, envGlobal, envComputer);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.info("Error processing scan injection - " + e.getMessage());
            }
        }
    }

    private void inject(Computer c, EnvVars envGlobal, EnvVars envComputer) {
        this.injections.forEach(injection -> injection.inject(c.getNode(), envGlobal, envComputer));
    }
}

