/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.EnvVars;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class MavenOptsSetter {
    private static final String MAVEN_OPTS_VAR = "MAVEN_OPTS";
    private final Set<String> keys;

    public MavenOptsSetter(String ... keys) {
        this.keys = new HashSet<String>(Arrays.asList(keys));
    }

    void appendIfMissing(Node node, List<String> mavenOptsKeyValuePairs) throws IOException, InterruptedException {
        String mavenOpts = this.removeSystemProperties(this.getMavenOpts(node)) + " " + String.join((CharSequence)" ", mavenOptsKeyValuePairs);
        this.setMavenOpts(node, mavenOpts);
    }

    void remove(Node node) throws IOException, InterruptedException {
        String mavenOpts = this.removeSystemProperties(this.getMavenOpts(node));
        this.setMavenOpts(node, mavenOpts);
    }

    private String getMavenOpts(Node node) throws IOException, InterruptedException {
        EnvVars nodeEnvVars = EnvVars.getRemote((VirtualChannel)node.getChannel());
        return (String)nodeEnvVars.get((Object)MAVEN_OPTS_VAR);
    }

    private void setMavenOpts(Node node, String mavenOpts) {
        node.getNodeProperties().add((Object)new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry(MAVEN_OPTS_VAR, mavenOpts)}));
    }

    private String removeSystemProperties(String mavenOpts) throws RuntimeException {
        return Optional.ofNullable(mavenOpts).map(this::filterMavenOpts).orElse("");
    }

    private String filterMavenOpts(String mavenOpts) {
        return Arrays.stream(mavenOpts.split(" ")).filter(this::shouldBeKept).collect(Collectors.joining(" ")).trim();
    }

    private boolean shouldBeKept(String seg) {
        return this.keys.stream().noneMatch(seg::contains);
    }
}

