/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.groovy.Groovy;
import hudson.plugins.groovy.GroovyInstaller;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyInstallation
extends ToolInstallation
implements EnvironmentSpecific<GroovyInstallation>,
NodeSpecific<GroovyInstallation> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GroovyInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getExecutable(VirtualChannel channel) throws IOException, InterruptedException {
        return (String)channel.call((Callable)new MasterToSlaveCallable<String, IOException>(){
            private static final long serialVersionUID = 1L;

            public String call() throws IOException {
                File exe = GroovyInstallation.this.getExeFile("groovy");
                if (exe.exists()) {
                    return exe.getPath();
                }
                return null;
            }
        });
    }

    private File getExeFile(String execName) {
        String groovyHome = Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars);
        File binDir = new File(groovyHome, "bin/");
        if (File.separatorChar == '\\') {
            execName = new File(binDir, execName + ".exe").exists() ? execName + ".exe" : execName + ".bat";
        }
        return new File(binDir, execName);
    }

    public GroovyInstallation forEnvironment(EnvVars environment) {
        return new GroovyInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public GroovyInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GroovyInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<GroovyInstallation> {
        public String getDisplayName() {
            return "Groovy";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new GroovyInstaller(null));
        }

        public GroovyInstallation[] getInstallations() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins instance is null - Jenkins is shutting down?");
            }
            return ((Groovy.DescriptorImpl)jenkins.getDescriptorByType(Groovy.DescriptorImpl.class)).getInstallations();
        }

        public void setInstallations(GroovyInstallation ... installations) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins != null) {
                ((Groovy.DescriptorImpl)jenkins.getDescriptorByType(Groovy.DescriptorImpl.class)).setInstallations(installations);
            }
        }
    }
}

