/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ui.icon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconSet {
    public static final IconSet icons = new IconSet();
    private Map<String, Icon> iconsByCSSSelector = new ConcurrentHashMap<String, Icon>();
    private Map<String, Icon> iconsByUrl = new ConcurrentHashMap<String, Icon>();
    private Map<String, Icon> iconsByClassSpec = new ConcurrentHashMap<String, Icon>();
    private Map<String, Icon> coreIcons = new ConcurrentHashMap<String, Icon>();
    private static final Icon NO_ICON = new Icon("_", "_", "_");

    public Map<String, Icon> getCoreIcons() {
        return this.coreIcons;
    }

    public static void initPageVariables(JellyContext context) {
        context.setVariable("icons", (Object)icons);
    }

    public IconSet addIcon(Icon icon) {
        this.iconsByCSSSelector.put(icon.getNormalizedSelector(), icon);
        if (icon.getUrl() != null) {
            this.iconsByUrl.put(icon.getUrl(), icon);
        }
        this.iconsByClassSpec.clear();
        return this;
    }

    public Icon getIconByNormalizedCSSSelector(Object cssSelector) {
        if (cssSelector == null) {
            return null;
        }
        return this.getIconByNormalizedCSSSelector(cssSelector.toString());
    }

    private Icon getIconByNormalizedCSSSelector(String cssSelector) {
        if (cssSelector == null) {
            return null;
        }
        return this.iconsByCSSSelector.get(cssSelector);
    }

    public Icon getIconByClassSpec(Object iconClassSpec) {
        if (iconClassSpec == null) {
            return null;
        }
        return this.getIconByClassSpec(iconClassSpec.toString());
    }

    private Icon getIconByClassSpec(String iconClassSpec) {
        if (iconClassSpec == null) {
            return null;
        }
        Icon icon = this.iconsByClassSpec.get(iconClassSpec);
        if (icon == NO_ICON) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        String normalizedCSSSelector = Icon.toNormalizedCSSSelector(iconClassSpec);
        icon = this.getIconByNormalizedCSSSelector(normalizedCSSSelector);
        if (icon != null) {
            this.iconsByClassSpec.put(iconClassSpec, icon);
            return icon;
        }
        this.iconsByClassSpec.put(iconClassSpec, NO_ICON);
        return null;
    }

    public Icon getIconByUrl(Object url) {
        if (url == null) {
            return null;
        }
        return this.getIconByUrl(url.toString());
    }

    private Icon getIconByUrl(String url) {
        if (url == null) {
            return null;
        }
        url = Icon.toNormalizedIconUrl(url);
        return this.iconsByUrl.get(url);
    }

    public static String toNormalizedIconNameClass(Object string) {
        if (string == null) {
            return null;
        }
        return IconSet.toNormalizedIconNameClass(string.toString());
    }

    private static String toNormalizedIconNameClass(String string) {
        return Icon.toNormalizedIconNameClass(string);
    }

    public static String toNormalizedIconSizeClass(Object string) {
        if (string == null) {
            return null;
        }
        return IconSet.toNormalizedIconSizeClass(string.toString());
    }

    private static String toNormalizedIconSizeClass(String string) {
        return Icon.toNormalizedIconSizeClass(string);
    }

    public static String toNormalizedIconUrl(Object url) {
        if (url == null) {
            return null;
        }
        return IconSet.toNormalizedIconUrl(url.toString());
    }

    private static String toNormalizedIconUrl(String url) {
        return Icon.toNormalizedIconUrl(url);
    }

    static {
        icons.addIcon(new Icon("icon-aborted icon-sm", "16x16/aborted.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-aborted-anime icon-sm", "16x16/aborted_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-blue icon-sm", "16x16/blue.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-blue-anime icon-sm", "16x16/blue_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-clock icon-sm", "16x16/clock.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-clock-anime icon-sm", "16x16/clock_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-computer-flash icon-sm", "16x16/computer-flash.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-computer-x icon-sm", "16x16/computer-x.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-computer icon-sm", "16x16/computer.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-disabled icon-sm", "16x16/disabled.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-disabled-anime icon-sm", "16x16/disabled_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-add icon-sm", "16x16/document_add.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-delete icon-sm", "16x16/document_delete.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-edit icon-sm", "16x16/document_edit.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-edit-delete icon-sm", "16x16/edit-delete.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-edit-select-all icon-sm", "16x16/edit-select-all.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-empty icon-sm", "16x16/empty.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-error icon-sm", "16x16/error.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-sm", "16x16/fingerprint.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder-error icon-sm", "16x16/folder-error.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder-open icon-sm", "16x16/folder-open.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder icon-sm", "16x16/folder.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-gear2 icon-sm", "16x16/gear2.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-go-next icon-sm", "16x16/go-next.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-green icon-sm", "16x16/green.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-green-anime icon-sm", "16x16/green_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-grey icon-sm", "16x16/grey.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-grey-anime icon-sm", "16x16/grey_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-sm", "16x16/health-00to19.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-sm", "16x16/health-20to39.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-sm", "16x16/health-40to59.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-sm", "16x16/health-60to79.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-sm", "16x16/health-80plus.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-help icon-sm", "16x16/help.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-hourglass icon-sm", "16x16/hourglass.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-lock icon-sm", "16x16/lock.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-sm", "16x16/nobuilt.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-nobuilt-anime icon-sm", "16x16/nobuilt_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-notepad icon-sm", "16x16/notepad.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-package icon-sm", "16x16/package.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-person icon-sm", "16x16/person.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-plugin icon-sm", "16x16/plugin.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-red icon-sm", "16x16/red.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-red-anime icon-sm", "16x16/red_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-redo icon-sm", "16x16/redo.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-save icon-sm", "16x16/save.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-search icon-sm", "16x16/search.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-star-gold icon-sm", "16x16/star-gold.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-star icon-sm", "16x16/star.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-stop icon-sm", "16x16/stop.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-terminal icon-sm", "16x16/terminal.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-text-error icon-sm", "16x16/text-error.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-text icon-sm", "16x16/text.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-user icon-sm", "16x16/user.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-warning icon-sm", "16x16/warning.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-yellow icon-sm", "16x16/yellow.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-yellow-anime icon-sm", "16x16/yellow_anime.gif", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-aborted icon-sm", "16x16/aborted.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-accept icon-sm", "16x16/accept.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-attribute icon-sm", "16x16/attribute.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-blue icon-sm", "16x16/blue.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-clock icon-sm", "16x16/clock.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-collapse icon-sm", "16x16/collapse.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-computer-x icon-sm", "16x16/computer-x.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-computer icon-sm", "16x16/computer.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-disabled icon-sm", "16x16/disabled.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-add icon-sm", "16x16/document_add.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-delete icon-sm", "16x16/document_delete.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-document-edit icon-sm", "16x16/document_edit.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-edit-delete icon-sm", "16x16/edit-delete.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-edit-select-all icon-sm", "16x16/edit-select-all.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-empty icon-sm", "16x16/empty.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-error icon-sm", "16x16/error.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-expand icon-sm", "16x16/expand.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-sm", "16x16/fingerprint.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder-error icon-sm", "16x16/folder-error.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder-open icon-sm", "16x16/folder-open.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-folder icon-sm", "16x16/folder.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-gear2 icon-sm", "16x16/gear2.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-go-next icon-sm", "16x16/go-next.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-grey icon-sm", "16x16/grey.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-sm", "16x16/health-00to19.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-sm", "16x16/health-20to39.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-sm", "16x16/health-40to59.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-sm", "16x16/health-60to79.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-sm", "16x16/health-80plus.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-help icon-sm", "16x16/help.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-hourglass icon-sm", "16x16/hourglass.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-lock icon-sm", "16x16/lock.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-sm", "16x16/nobuilt.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-notepad icon-sm", "16x16/notepad.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-orange-square icon-sm", "16x16/orange-square.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-package icon-sm", "16x16/package.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-person icon-sm", "16x16/person.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-plugin icon-sm", "16x16/plugin.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-red icon-sm", "16x16/red.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-redo icon-sm", "16x16/redo.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-save icon-sm", "16x16/save.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-search icon-sm", "16x16/search.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-secure icon-sm", "16x16/secure.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-setting icon-sm", "16x16/setting.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-star-gold icon-sm", "16x16/star-gold.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-star icon-sm", "16x16/star.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-stop icon-sm", "16x16/stop.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-terminal icon-sm", "16x16/terminal.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-text-error icon-sm", "16x16/text-error.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-text icon-sm", "16x16/text.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-user icon-sm", "16x16/user.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-warning icon-sm", "16x16/warning.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-yellow icon-sm", "16x16/yellow.png", "width: 16px; height: 16px;"));
        icons.addIcon(new Icon("icon-aborted icon-md", "24x24/aborted.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-aborted-anime icon-md", "24x24/aborted_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-blue icon-md", "24x24/blue.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-blue-anime icon-md", "24x24/blue_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-clipboard icon-md", "24x24/clipboard.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-clock icon-md", "24x24/clock.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-clock-anime icon-md", "24x24/clock_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-computer-flash icon-md", "24x24/computer-flash.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-computer-x icon-md", "24x24/computer-x.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-computer icon-md", "24x24/computer.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-delete-document icon-md", "24x24/delete-document.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-disabled icon-md", "24x24/disabled.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-disabled-anime icon-md", "24x24/disabled_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-document-properties icon-md", "24x24/document-properties.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-document icon-md", "24x24/document.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-edit-delete icon-md", "24x24/edit-delete.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-empty icon-md", "24x24/empty.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-md", "24x24/fingerprint.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-folder-delete icon-md", "24x24/folder-delete.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-folder icon-md", "24x24/folder.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-gear icon-md", "24x24/gear.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-gear2 icon-md", "24x24/gear2.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-graph icon-md", "24x24/graph.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-green icon-md", "24x24/green.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-green-anime icon-md", "24x24/green_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-grey icon-md", "24x24/grey.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-grey-anime icon-md", "24x24/grey_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-md", "24x24/health-00to19.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-md", "24x24/health-20to39.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-md", "24x24/health-40to59.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-md", "24x24/health-60to79.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-md", "24x24/health-80plus.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-help icon-md", "24x24/help.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-installer icon-md", "24x24/installer.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-monitor icon-md", "24x24/monitor.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-computer icon-md", "24x24/new-computer.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-document icon-md", "24x24/new-document.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-package icon-md", "24x24/new-package.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-user icon-md", "24x24/new-user.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-next icon-md", "24x24/next.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-md", "24x24/nobuilt.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-nobuilt-anime icon-md", "24x24/nobuilt_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-notepad icon-md", "24x24/notepad.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-orange-square icon-md", "24x24/orange-square.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-package icon-md", "24x24/package.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-previous icon-md", "24x24/previous.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-red icon-md", "24x24/red.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-red-anime icon-md", "24x24/red_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-redo icon-md", "24x24/redo.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-refresh icon-md", "24x24/refresh.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-save icon-md", "24x24/save.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-search icon-md", "24x24/search.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-setting icon-md", "24x24/setting.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-star-gold icon-md", "24x24/star-gold.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-star icon-md", "24x24/star.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-terminal icon-md", "24x24/terminal.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-up icon-md", "24x24/up.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-user icon-md", "24x24/user.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-yellow icon-md", "24x24/yellow.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-yellow-anime icon-md", "24x24/yellow_anime.gif", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-aborted icon-md", "24x24/aborted.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-accept icon-md", "24x24/accept.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-attribute icon-md", "24x24/attribute.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-blue icon-md", "24x24/blue.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-clipboard icon-md", "24x24/clipboard.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-clock icon-md", "24x24/clock.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-computer-x icon-md", "24x24/computer-x.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-computer icon-md", "24x24/computer.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-delete-document icon-md", "24x24/delete-document.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-disabled icon-md", "24x24/disabled.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-document-properties icon-md", "24x24/document-properties.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-document icon-md", "24x24/document.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-edit-delete icon-md", "24x24/edit-delete.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-empty icon-md", "24x24/empty.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-md", "24x24/fingerprint.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-folder-delete icon-md", "24x24/folder-delete.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-folder icon-md", "24x24/folder.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-gear icon-md", "24x24/gear.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-gear2 icon-md", "24x24/gear2.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-graph icon-md", "24x24/graph.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-grey icon-md", "24x24/grey.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-md", "24x24/health-00to19.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-md", "24x24/health-20to39.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-md", "24x24/health-40to59.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-md", "24x24/health-60to79.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-md", "24x24/health-80plus.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-help icon-md", "24x24/help.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-installer icon-md", "24x24/installer.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-lock icon-md", "24x24/lock.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-monitor icon-md", "24x24/monitor.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-computer icon-md", "24x24/new-computer.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-document icon-md", "24x24/new-document.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-package icon-md", "24x24/new-package.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-new-user icon-md", "24x24/new-user.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-next icon-md", "24x24/next.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-md", "24x24/nobuilt.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-notepad icon-md", "24x24/notepad.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-orange-square icon-md", "24x24/orange-square.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-package icon-md", "24x24/package.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-plugin icon-md", "24x24/plugin.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-previous icon-md", "24x24/previous.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-red icon-md", "24x24/red.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-redo icon-md", "24x24/redo.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-refresh icon-md", "24x24/refresh.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-save icon-md", "24x24/save.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-search icon-md", "24x24/search.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-secure icon-md", "24x24/secure.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-setting icon-md", "24x24/setting.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-star-gold icon-md", "24x24/star-gold.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-star icon-md", "24x24/star.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-terminal icon-md", "24x24/terminal.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-up icon-md", "24x24/up.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-user icon-md", "24x24/user.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-yellow icon-md", "24x24/yellow.png", "width: 24px; height: 24px;"));
        icons.addIcon(new Icon("icon-aborted icon-lg", "32x32/aborted.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-aborted-anime icon-lg", "32x32/aborted_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-blue icon-lg", "32x32/blue.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-blue-anime icon-lg", "32x32/blue_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-clipboard icon-lg", "32x32/clipboard.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-clock icon-lg", "32x32/clock.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-clock-anime icon-lg", "32x32/clock_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-computer-flash icon-lg", "32x32/computer-flash.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-computer-x icon-lg", "32x32/computer-x.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-computer icon-lg", "32x32/computer.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-disabled icon-lg", "32x32/disabled.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-disabled-anime icon-lg", "32x32/disabled_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-empty icon-lg", "32x32/empty.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-error icon-lg", "32x32/error.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-folder icon-lg", "32x32/folder.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-graph icon-lg", "32x32/graph.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-green icon-lg", "32x32/green.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-green-anime icon-lg", "32x32/green_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-grey icon-lg", "32x32/grey.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-grey-anime icon-lg", "32x32/grey_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-lg", "32x32/health-00to19.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-lg", "32x32/health-20to39.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-lg", "32x32/health-40to59.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-lg", "32x32/health-60to79.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-lg", "32x32/health-80plus.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-lg", "32x32/nobuilt.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-nobuilt-anime icon-lg", "32x32/nobuilt_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-plugin icon-lg", "32x32/plugin.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-red icon-lg", "32x32/red.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-red-anime icon-lg", "32x32/red_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-setting icon-lg", "32x32/setting.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-star-gold icon-lg", "32x32/star-gold.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-star icon-lg", "32x32/star.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-user icon-lg", "32x32/user.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-yellow icon-lg", "32x32/yellow.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-yellow-anime icon-lg", "32x32/yellow_anime.gif", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-aborted icon-lg", "32x32/aborted.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-accept icon-lg", "32x32/accept.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-attribute icon-lg", "32x32/attribute.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-blue icon-lg", "32x32/blue.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-clipboard icon-lg", "32x32/clipboard.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-clock icon-lg", "32x32/clock.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-computer-x icon-lg", "32x32/computer-x.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-computer icon-lg", "32x32/computer.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-disabled icon-lg", "32x32/disabled.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-empty icon-lg", "32x32/empty.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-error icon-lg", "32x32/error.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-folder icon-lg", "32x32/folder.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-gear2 icon-lg", "32x32/gear2.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-graph icon-lg", "32x32/graph.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-grey icon-lg", "32x32/grey.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-lg", "32x32/health-00to19.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-lg", "32x32/health-20to39.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-lg", "32x32/health-40to59.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-lg", "32x32/health-60to79.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-lg", "32x32/health-80plus.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-lock icon-lg", "32x32/lock.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-lg", "32x32/nobuilt.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-orange-square icon-lg", "32x32/orange-square.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-package icon-lg", "32x32/package.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-plugin icon-lg", "32x32/plugin.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-red icon-lg", "32x32/red.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-secure icon-lg", "32x32/secure.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-setting icon-lg", "32x32/setting.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-star-gold icon-lg", "32x32/star-gold.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-star icon-lg", "32x32/star.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-user icon-lg", "32x32/user.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-yellow icon-lg", "32x32/yellow.png", "width: 32px; height: 32px;"));
        icons.addIcon(new Icon("icon-aborted icon-xlg", "48x48/aborted.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-aborted-anime icon-xlg", "48x48/aborted_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-blue icon-xlg", "48x48/blue.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-blue-anime icon-xlg", "48x48/blue_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-clipboard icon-xlg", "48x48/clipboard.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-computer-flash icon-xlg", "48x48/computer-flash.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-computer-x icon-xlg", "48x48/computer-x.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-computer icon-xlg", "48x48/computer.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-disabled icon-xlg", "48x48/disabled.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-disabled-anime icon-xlg", "48x48/disabled_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-document icon-xlg", "48x48/document.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-empty icon-xlg", "48x48/empty.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-error icon-xlg", "48x48/error.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-xlg", "48x48/fingerprint.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-folder-delete icon-xlg", "48x48/folder-delete.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-folder icon-xlg", "48x48/folder.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-gear2 icon-xlg", "48x48/gear2.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-graph icon-xlg", "48x48/graph.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-green icon-xlg", "48x48/green.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-green-anime icon-xlg", "48x48/green_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-grey icon-xlg", "48x48/grey.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-grey-anime icon-xlg", "48x48/grey_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-xlg", "48x48/health-00to19.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-xlg", "48x48/health-20to39.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-xlg", "48x48/health-40to59.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-xlg", "48x48/health-60to79.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-xlg", "48x48/health-80plus.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-help icon-xlg", "48x48/help.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-installer icon-xlg", "48x48/installer.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-monitor icon-xlg", "48x48/monitor.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-network icon-xlg", "48x48/network.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-xlg", "48x48/nobuilt.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-nobuilt-anime icon-xlg", "48x48/nobuilt_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-notepad icon-xlg", "48x48/notepad.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-orange-square icon-xlg", "48x48/orange-square.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-package icon-xlg", "48x48/package.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-plugin icon-xlg", "48x48/plugin.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-red icon-xlg", "48x48/red.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-red-anime icon-xlg", "48x48/red_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-redo icon-xlg", "48x48/redo.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-refresh icon-xlg", "48x48/refresh.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-search icon-xlg", "48x48/search.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-secure icon-xlg", "48x48/secure.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-setting icon-xlg", "48x48/setting.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-star-gold icon-xlg", "48x48/star-gold.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-star icon-xlg", "48x48/star.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-system-log-out icon-xlg", "48x48/system-log-out.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-terminal icon-xlg", "48x48/terminal.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-user icon-xlg", "48x48/user.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-warning icon-xlg", "48x48/warning.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-yellow icon-xlg", "48x48/yellow.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-yellow-anime icon-xlg", "48x48/yellow_anime.gif", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-aborted icon-xlg", "48x48/aborted.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-accept icon-xlg", "48x48/accept.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-attribute icon-xlg", "48x48/attribute.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-blue icon-xlg", "48x48/blue.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-clipboard icon-xlg", "48x48/clipboard.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-computer-x icon-xlg", "48x48/computer-x.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-computer icon-xlg", "48x48/computer.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-disabled icon-xlg", "48x48/disabled.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-document icon-xlg", "48x48/document.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-empty icon-xlg", "48x48/empty.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-error icon-xlg", "48x48/error.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-fingerprint icon-xlg", "48x48/fingerprint.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-folder-delete icon-xlg", "48x48/folder-delete.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-folder icon-xlg", "48x48/folder.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-gear2 icon-xlg", "48x48/gear2.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-graph icon-xlg", "48x48/graph.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-grey icon-xlg", "48x48/grey.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-00to19 icon-xlg", "48x48/health-00to19.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-20to39 icon-xlg", "48x48/health-20to39.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-40to59 icon-xlg", "48x48/health-40to59.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-60to79 icon-xlg", "48x48/health-60to79.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-health-80plus icon-xlg", "48x48/health-80plus.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-help icon-xlg", "48x48/help.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-installer icon-xlg", "48x48/installer.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-lock icon-xlg", "48x48/lock.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-monitor icon-xlg", "48x48/monitor.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-network icon-xlg", "48x48/network.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-nobuilt icon-xlg", "48x48/nobuilt.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-notepad icon-xlg", "48x48/notepad.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-orange-square icon-xlg", "48x48/orange-square.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-package icon-xlg", "48x48/package.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-plugin icon-xlg", "48x48/plugin.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-red icon-xlg", "48x48/red.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-redo icon-xlg", "48x48/redo.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-refresh icon-xlg", "48x48/refresh.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-search icon-xlg", "48x48/search.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-secure icon-xlg", "48x48/secure.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-setting icon-xlg", "48x48/setting.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-star-gold icon-xlg", "48x48/star-gold.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-star icon-xlg", "48x48/star.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-system-log-out icon-xlg", "48x48/system-log-out.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-terminal icon-xlg", "48x48/terminal.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-user icon-xlg", "48x48/user.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-warning icon-xlg", "48x48/warning.png", "width: 48px; height: 48px;"));
        icons.addIcon(new Icon("icon-yellow icon-xlg", "48x48/yellow.png", "width: 48px; height: 48px;"));
        IconSet.icons.coreIcons.putAll(IconSet.icons.iconsByCSSSelector);
    }
}

