// CHECKSTYLE:OFF

package hudson.plugins.jacoco;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildAction.Classes}: {@code Classes {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Classes {0} ({1}%).}
     */
    public static String BuildAction_Classes(Object arg0, Object arg1) {
        return holder.format("BuildAction.Classes", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Classes}: {@code Classes {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Classes {0} ({1}%).}
     */
    public static Localizable _BuildAction_Classes(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Classes", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Blocks}: {@code Blocks {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blocks {0} ({1}%).}
     */
    public static String BuildAction_Blocks(Object arg0, Object arg1) {
        return holder.format("BuildAction.Blocks", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Blocks}: {@code Blocks {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blocks {0} ({1}%).}
     */
    public static Localizable _BuildAction_Blocks(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Blocks", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Instructions}: {@code Instructions {0}
     * ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Instructions {0} ({1}%).}
     */
    public static String BuildAction_Instructions(Object arg0, Object arg1) {
        return holder.format("BuildAction.Instructions", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Instructions}: {@code Instructions {0}
     * ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Instructions {0} ({1}%).}
     */
    public static Localizable _BuildAction_Instructions(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Instructions", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.DisplayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String BuildAction_DisplayName() {
        return holder.format("BuildAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.DisplayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _BuildAction_DisplayName() {
        return new Localizable(holder, "BuildAction.DisplayName");
    }

    /**
     * Key {@code CoverageObject.Legend.Missed}: {@code {0} missed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} missed}
     */
    public static String CoverageObject_Legend_Missed(Object arg0) {
        return holder.format("CoverageObject.Legend.Missed", arg0);
    }

    /**
     * Key {@code CoverageObject.Legend.Missed}: {@code {0} missed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} missed}
     */
    public static Localizable _CoverageObject_Legend_Missed(Object arg0) {
        return new Localizable(holder, "CoverageObject.Legend.Missed", arg0);
    }

    /**
     * Key {@code CoverageObject.Legend.Instructions}: {@code instructions}.
     * 
     * @return
     *     {@code instructions}
     */
    public static String CoverageObject_Legend_Instructions() {
        return holder.format("CoverageObject.Legend.Instructions");
    }

    /**
     * Key {@code CoverageObject.Legend.Instructions}: {@code instructions}.
     * 
     * @return
     *     {@code instructions}
     */
    public static Localizable _CoverageObject_Legend_Instructions() {
        return new Localizable(holder, "CoverageObject.Legend.Instructions");
    }

    /**
     * Key {@code CoverageObject.Legend.Method}: {@code method}.
     * 
     * @return
     *     {@code method}
     */
    public static String CoverageObject_Legend_Method() {
        return holder.format("CoverageObject.Legend.Method");
    }

    /**
     * Key {@code CoverageObject.Legend.Method}: {@code method}.
     * 
     * @return
     *     {@code method}
     */
    public static Localizable _CoverageObject_Legend_Method() {
        return new Localizable(holder, "CoverageObject.Legend.Method");
    }

    /**
     * Key {@code BuildAction.Methods}: {@code Methods {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Methods {0} ({1}%).}
     */
    public static String BuildAction_Methods(Object arg0, Object arg1) {
        return holder.format("BuildAction.Methods", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Methods}: {@code Methods {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Methods {0} ({1}%).}
     */
    public static Localizable _BuildAction_Methods(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Methods", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Perfect}: {@code All coverage targets have been
     * met.}.
     * 
     * @return
     *     {@code All coverage targets have been met.}
     */
    public static String BuildAction_Perfect() {
        return holder.format("BuildAction.Perfect");
    }

    /**
     * Key {@code BuildAction.Perfect}: {@code All coverage targets have been
     * met.}.
     * 
     * @return
     *     {@code All coverage targets have been met.}
     */
    public static Localizable _BuildAction_Perfect() {
        return new Localizable(holder, "BuildAction.Perfect");
    }

    /**
     * Key {@code JacocoPublisher.DisplayName}: {@code Record JaCoCo coverage
     * report}.
     * 
     * @return
     *     {@code Record JaCoCo coverage report}
     */
    public static String JacocoPublisher_DisplayName() {
        return holder.format("JacocoPublisher.DisplayName");
    }

    /**
     * Key {@code JacocoPublisher.DisplayName}: {@code Record JaCoCo coverage
     * report}.
     * 
     * @return
     *     {@code Record JaCoCo coverage report}
     */
    public static Localizable _JacocoPublisher_DisplayName() {
        return new Localizable(holder, "JacocoPublisher.DisplayName");
    }

    /**
     * Key {@code CoverageObject.Legend.Line}: {@code line}.
     * 
     * @return
     *     {@code line}
     */
    public static String CoverageObject_Legend_Line() {
        return holder.format("CoverageObject.Legend.Line");
    }

    /**
     * Key {@code CoverageObject.Legend.Line}: {@code line}.
     * 
     * @return
     *     {@code line}
     */
    public static Localizable _CoverageObject_Legend_Line() {
        return new Localizable(holder, "CoverageObject.Legend.Line");
    }

    /**
     * Key {@code BuildAction.Lines}: {@code Lines {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Lines {0} ({1}%).}
     */
    public static String BuildAction_Lines(Object arg0, Object arg1) {
        return holder.format("BuildAction.Lines", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Lines}: {@code Lines {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Lines {0} ({1}%).}
     */
    public static Localizable _BuildAction_Lines(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Lines", arg0, arg1);
    }

    /**
     * Key {@code CoverageObject.Legend.Branch}: {@code branch}.
     * 
     * @return
     *     {@code branch}
     */
    public static String CoverageObject_Legend_Branch() {
        return holder.format("CoverageObject.Legend.Branch");
    }

    /**
     * Key {@code CoverageObject.Legend.Branch}: {@code branch}.
     * 
     * @return
     *     {@code branch}
     */
    public static Localizable _CoverageObject_Legend_Branch() {
        return new Localizable(holder, "CoverageObject.Legend.Branch");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Coverage Trend}.
     * 
     * @return
     *     {@code Coverage Trend}
     */
    public static String ProjectAction_DisplayName() {
        return holder.format("ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Coverage Trend}.
     * 
     * @return
     *     {@code Coverage Trend}
     */
    public static Localizable _ProjectAction_DisplayName() {
        return new Localizable(holder, "ProjectAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.Branches}: {@code Branches {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branches {0} ({1}%).}
     */
    public static String BuildAction_Branches(Object arg0, Object arg1) {
        return holder.format("BuildAction.Branches", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Branches}: {@code Branches {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branches {0} ({1}%).}
     */
    public static Localizable _BuildAction_Branches(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Branches", arg0, arg1);
    }

    /**
     * Key {@code CoverageObject.Legend.Covered}: {@code {0} covered}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} covered}
     */
    public static String CoverageObject_Legend_Covered(Object arg0) {
        return holder.format("CoverageObject.Legend.Covered", arg0);
    }

    /**
     * Key {@code CoverageObject.Legend.Covered}: {@code {0} covered}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} covered}
     */
    public static Localizable _CoverageObject_Legend_Covered(Object arg0) {
        return new Localizable(holder, "CoverageObject.Legend.Covered", arg0);
    }

    /**
     * Key {@code CoverageObject.Legend.Class}: {@code class}.
     * 
     * @return
     *     {@code class}
     */
    public static String CoverageObject_Legend_Class() {
        return holder.format("CoverageObject.Legend.Class");
    }

    /**
     * Key {@code CoverageObject.Legend.Class}: {@code class}.
     * 
     * @return
     *     {@code class}
     */
    public static Localizable _CoverageObject_Legend_Class() {
        return new Localizable(holder, "CoverageObject.Legend.Class");
    }

    /**
     * Key {@code CoverageObject.Legend.Complexity}: {@code complexity}.
     * 
     * @return
     *     {@code complexity}
     */
    public static String CoverageObject_Legend_Complexity() {
        return holder.format("CoverageObject.Legend.Complexity");
    }

    /**
     * Key {@code CoverageObject.Legend.Complexity}: {@code complexity}.
     * 
     * @return
     *     {@code complexity}
     */
    public static Localizable _CoverageObject_Legend_Complexity() {
        return new Localizable(holder, "CoverageObject.Legend.Complexity");
    }

    /**
     * Key {@code BuildAction.Description}: {@code Coverage: {0} {1} {2} {3}
     * {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage: {0} {1} {2} {3} {4}}
     */
    public static String BuildAction_Description(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("BuildAction.Description", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code BuildAction.Description}: {@code Coverage: {0} {1} {2} {3}
     * {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage: {0} {1} {2} {3} {4}}
     */
    public static Localizable _BuildAction_Description(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "BuildAction.Description", arg0, arg1, arg2, arg3, arg4);
    }

}
