// CHECKSTYLE:OFF

package hudson.plugins.jacoco.portlet;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code gridTitle}: {@code JaCoCo Coverage Statistics Grid}.
     * 
     * @return
     *     {@code JaCoCo Coverage Statistics Grid}
     */
    public static String gridTitle() {
        return holder.format("gridTitle");
    }

    /**
     * Key {@code gridTitle}: {@code JaCoCo Coverage Statistics Grid}.
     * 
     * @return
     *     {@code JaCoCo Coverage Statistics Grid}
     */
    public static Localizable _gridTitle() {
        return new Localizable(holder, "gridTitle");
    }

    /**
     * Key {@code chartTitle}: {@code JaCoCo Coverage Trend Chart}.
     * 
     * @return
     *     {@code JaCoCo Coverage Trend Chart}
     */
    public static String chartTitle() {
        return holder.format("chartTitle");
    }

    /**
     * Key {@code chartTitle}: {@code JaCoCo Coverage Trend Chart}.
     * 
     * @return
     *     {@code JaCoCo Coverage Trend Chart}
     */
    public static Localizable _chartTitle() {
        return new Localizable(holder, "chartTitle");
    }

}
