/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageElement;
import java.io.Serializable;

public class JacocoHealthReportThresholds
implements Serializable {
    private int minClass;
    private int maxClass;
    private int minMethod;
    private int maxMethod;
    private int minLine;
    private int maxLine;
    private int minBranch;
    private int maxBranch;
    private int minInstruction;
    private int maxInstruction;
    private int minComplexity;
    private int maxComplexity;

    public JacocoHealthReportThresholds() {
    }

    public JacocoHealthReportThresholds(int minClass, int maxClass, int minMethod, int maxMethod, int minLine, int maxLine, int minBranch, int maxBranch, int minInstruction, int maxInstruction, int minComplexity, int maxComplexity) {
        this.minClass = minClass;
        this.maxClass = maxClass;
        this.minMethod = minMethod;
        this.maxMethod = maxMethod;
        this.minLine = minLine;
        this.maxLine = maxLine;
        this.minBranch = minBranch;
        this.maxBranch = maxBranch;
        this.minInstruction = minInstruction;
        this.maxInstruction = maxInstruction;
        this.minComplexity = minComplexity;
        this.maxComplexity = maxComplexity;
        this.ensureValid();
    }

    private int applyRange(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void ensureValid() {
        this.maxClass = this.applyRange(0, this.maxClass, 100);
        this.minClass = this.applyRange(0, this.minClass, this.maxClass);
        this.maxMethod = this.applyRange(0, this.maxMethod, 100);
        this.minMethod = this.applyRange(0, this.minMethod, this.maxMethod);
        this.maxLine = this.applyRange(0, this.maxLine, 100);
        this.minLine = this.applyRange(0, this.minLine, this.maxLine);
        this.maxBranch = this.applyRange(0, this.maxBranch, 100);
        this.minBranch = this.applyRange(0, this.minBranch, this.maxBranch);
        this.maxInstruction = this.applyRange(0, this.maxInstruction, 100);
        this.minInstruction = this.applyRange(0, this.minInstruction, this.maxInstruction);
        this.maxComplexity = this.applyRange(0, this.maxComplexity, 100);
        this.minComplexity = this.applyRange(0, this.minComplexity, this.maxComplexity);
    }

    public int getMinClass() {
        return this.minClass;
    }

    public void setMinClass(int minClass) {
        this.minClass = minClass;
    }

    public int getMaxClass() {
        return this.maxClass;
    }

    public void setMaxClass(int maxClass) {
        this.maxClass = maxClass;
    }

    public int getMinMethod() {
        return this.minMethod;
    }

    public void setMinMethod(int minMethod) {
        this.minMethod = minMethod;
    }

    public int getMaxMethod() {
        return this.maxMethod;
    }

    public void setMaxMethod(int maxMethod) {
        this.maxMethod = maxMethod;
    }

    public int getMinLine() {
        return this.minLine;
    }

    public void setMinLine(int minLine) {
        this.minLine = minLine;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }

    public int getMinBranch() {
        return this.minBranch;
    }

    public int getMaxBranch() {
        return this.maxBranch;
    }

    public int getMinInstruction() {
        return this.minInstruction;
    }

    public int getMaxInstruction() {
        return this.maxInstruction;
    }

    public int getMinComplexity() {
        return this.minComplexity;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public void setMinBranch(int minBranch) {
        this.minBranch = minBranch;
    }

    public void setMaxBranch(int maxBranch) {
        this.maxBranch = maxBranch;
    }

    public void setMinInstruction(int minInstruction) {
        this.minInstruction = minInstruction;
    }

    public void setMaxInstruction(int maxInstruction) {
        this.maxInstruction = maxInstruction;
    }

    public void setMinComplexity(int minComplexity) {
        this.minComplexity = minComplexity;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    public RESULT getResultByTypeAndRatio(Coverage ratio) {
        RESULT result = RESULT.ABOVEMAXIMUM;
        CoverageElement.Type covType = ratio.getType();
        float percentage = ratio.getPercentageFloat();
        if (covType == CoverageElement.Type.INSTRUCTION) {
            if (percentage < (float)this.minInstruction) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxInstruction) {
                result = RESULT.BETWEENMINMAX;
            }
        } else if (covType == CoverageElement.Type.BRANCH) {
            if (percentage < (float)this.minBranch) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxBranch) {
                result = RESULT.BETWEENMINMAX;
            }
        } else if (covType == CoverageElement.Type.LINE) {
            if (percentage < (float)this.minLine) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxLine) {
                result = RESULT.BETWEENMINMAX;
            }
        } else if (covType == CoverageElement.Type.COMPLEXITY) {
            if (percentage < (float)this.minComplexity) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxComplexity) {
                result = RESULT.BETWEENMINMAX;
            }
        } else if (covType == CoverageElement.Type.METHOD) {
            if (percentage < (float)this.minMethod) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxMethod) {
                result = RESULT.BETWEENMINMAX;
            }
        } else if (covType == CoverageElement.Type.CLASS) {
            if (percentage < (float)this.minClass) {
                result = RESULT.BELOWMINIMUM;
            } else if (percentage < (float)this.maxClass) {
                result = RESULT.BETWEENMINMAX;
            }
        }
        return result;
    }

    public String toString() {
        return "JacocoHealthReportThresholds [minClass=" + this.minClass + ", maxClass=" + this.maxClass + ", minMethod=" + this.minMethod + ", maxMethod=" + this.maxMethod + ", minLine=" + this.minLine + ", maxLine=" + this.maxLine + ", minBranch=" + this.minBranch + ", maxBranch=" + this.maxBranch + ", minInstruction=" + this.minInstruction + ", maxInstruction=" + this.maxInstruction + ", minComplexity=" + this.minComplexity + ", maxComplexity=" + this.maxComplexity + "]";
    }

    public static enum RESULT {
        BELOWMINIMUM,
        BETWEENMINMAX,
        ABOVEMAXIMUM;

    }
}

