/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.plugins.jacoco.ExecutionFileLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JacocoReportDir {
    private final File root;

    public JacocoReportDir(File rootDir) {
        this.root = new File(rootDir, "jacoco");
    }

    public File getClassesDir() {
        return new File(this.root, "classes");
    }

    public int saveClassesFrom(@NonNull FilePath dir, @NonNull String fileMask) throws IOException, InterruptedException {
        FilePath d = new FilePath(this.getClassesDir());
        d.mkdirs();
        return dir.copyRecursiveTo(fileMask, d);
    }

    public File getSourcesDir() {
        return new File(this.root, "sources");
    }

    public int saveSourcesFrom(@NonNull FilePath dir, @NonNull String inclusionMask, @NonNull String exclusionMask) throws IOException, InterruptedException {
        FilePath d = new FilePath(this.getSourcesDir());
        d.mkdirs();
        return dir.copyRecursiveTo(inclusionMask, exclusionMask, d);
    }

    public File getExecFilesDir() {
        return new File(this.root, "execFiles");
    }

    public List<File> getExecFiles() {
        File checkPath;
        ArrayList<File> r = new ArrayList<File>();
        int i = 0;
        File root = this.getExecFilesDir();
        while ((checkPath = new File(root, "exec" + i)).exists()) {
            r.add(new File(checkPath, "jacoco.exec"));
            ++i;
        }
        return r;
    }

    public void addExecFiles(Iterable<FilePath> execFiles) throws IOException, InterruptedException {
        FilePath root = new FilePath(this.getExecFilesDir());
        int i = 0;
        for (FilePath file : execFiles) {
            FilePath separateExecDir;
            while ((separateExecDir = new FilePath(root, "exec" + i++)).exists()) {
            }
            FilePath fullExecName = separateExecDir.child("jacoco.exec");
            file.copyTo(fullExecName);
        }
    }

    public ExecutionFileLoader parse(String[] includes, String ... excludes) throws IOException {
        ExecutionFileLoader efl = new ExecutionFileLoader();
        for (File exec : this.getExecFiles()) {
            efl.addExecFile(new FilePath(exec));
        }
        efl.setIncludes(includes);
        efl.setExcludes(excludes);
        efl.setClassDir(new FilePath(this.getClassesDir()));
        efl.setSrcDir(new FilePath(this.getSourcesDir()));
        efl.loadBundleCoverage();
        return efl;
    }

    public String toString() {
        return this.root.toString();
    }
}

