/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.model;

import hudson.Util;
import hudson.model.Api;
import hudson.model.Run;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.model.CoverageGraphLayout;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jacoco.core.analysis.ICoverageNode;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class CoverageObject<SELF extends CoverageObject<SELF>> {
    public Coverage clazz = new Coverage();
    public Coverage method = new Coverage();
    public Coverage line = new Coverage();
    public Coverage complexity = new Coverage();
    public Coverage instruction = new Coverage();
    public Coverage branch = new Coverage();
    public int maxClazz = 1;
    public int maxMethod = 1;
    public int maxLine = 1;
    public int maxComplexity = 1;
    public int maxInstruction = 1;
    public int maxBranch = 1;
    private volatile boolean failed = false;
    static NumberFormat dataFormat = new DecimalFormat("000.00", new DecimalFormatSymbols(Locale.US));
    static NumberFormat percentFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    static NumberFormat intFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));

    public int getMaxClazz() {
        return this.maxClazz;
    }

    public void setMaxClazz(int maxClazz) {
        this.maxClazz = maxClazz;
    }

    public int getMaxMethod() {
        return this.maxMethod;
    }

    public void setMaxMethod(int maxMethod) {
        this.maxMethod = maxMethod;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    public int getMaxInstruction() {
        return this.maxInstruction;
    }

    public void setMaxInstruction(int maxInstruction) {
        this.maxInstruction = maxInstruction;
    }

    public int getMaxBranch() {
        return this.maxBranch;
    }

    public void setMaxBranch(int maxBranch) {
        this.maxBranch = maxBranch;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = true;
    }

    @Exported(inline=true)
    public Coverage getClassCoverage() {
        return this.clazz;
    }

    @Exported(inline=true)
    public Coverage getMethodCoverage() {
        return this.method;
    }

    @Exported(inline=true)
    public Coverage getComplexityScore() {
        return this.complexity;
    }

    @Exported(inline=true)
    public Coverage getInstructionCoverage() {
        return this.instruction;
    }

    @Exported(inline=true)
    public Coverage getBranchCoverage() {
        return this.branch;
    }

    @Exported(inline=true)
    public Coverage getLineCoverage() {
        return this.line;
    }

    public abstract Run<?, ?> getBuild();

    @Exported
    public abstract SELF getPreviousResult();

    public CoverageObject<?> getParent() {
        return null;
    }

    public String printFourCoverageColumns() {
        StringBuilder buf = new StringBuilder();
        this.instruction.setType(CoverageElement.Type.INSTRUCTION);
        this.clazz.setType(CoverageElement.Type.CLASS);
        this.complexity.setType(CoverageElement.Type.COMPLEXITY);
        this.branch.setType(CoverageElement.Type.BRANCH);
        this.line.setType(CoverageElement.Type.LINE);
        this.method.setType(CoverageElement.Type.METHOD);
        this.printRatioCell(this.isFailed(), this.instruction, buf);
        this.printRatioCell(this.isFailed(), this.branch, buf);
        this.printRatioCell(this.isFailed(), this.complexity, buf);
        this.printRatioCell(this.isFailed(), this.line, buf);
        this.printRatioCell(this.isFailed(), this.method, buf);
        this.printRatioCell(this.isFailed(), this.clazz, buf);
        return buf.toString();
    }

    public boolean hasLineCoverage() {
        return this.line.isInitialized();
    }

    public boolean hasClassCoverage() {
        return this.clazz.isInitialized();
    }

    protected void printRatioCell(boolean failed, Coverage ratio, StringBuilder buf) {
        if (ratio != null && ratio.isInitialized()) {
            buf.append("<td class='").append("").append("'");
            buf.append(" data='").append(dataFormat.format(ratio.getPercentageFloat()));
            buf.append("'>\n");
            this.printRatioTable(ratio, buf);
            buf.append("</td>\n");
        }
    }

    protected void printRatioTable(Coverage ratio, StringBuilder buf) {
        String numerator = intFormat.format(ratio.getMissed());
        String denominator = intFormat.format(ratio.getCovered());
        int maximum = 1;
        if (ratio.getType().equals((Object)CoverageElement.Type.INSTRUCTION)) {
            maximum = this.getParent().maxInstruction;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.BRANCH)) {
            maximum = this.getParent().maxBranch;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.COMPLEXITY)) {
            maximum = this.getParent().maxComplexity;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.LINE)) {
            maximum = this.getParent().maxLine;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.METHOD)) {
            maximum = this.getParent().maxMethod;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.CLASS)) {
            maximum = this.getParent().maxClazz;
        }
        float redBar = (float)ratio.getMissed() / (float)maximum * 100.0f;
        float greenBar = (float)ratio.getTotal() / (float)maximum * 100.0f;
        buf.append("<table class='percentgraph' cellpadding='0px' cellspacing='0px'>").append("<tr><td class='percentgraph' colspan='2'><span class='text'><b>M:</b> ").append(numerator).append(" <b>C:</b> ").append(denominator).append("</span></td></tr>").append("<tr>").append("<td width='40px' class='data'>").append(ratio.getPercentage()).append("%</td>").append("<td>").append("<div class='percentgraph' style='width: ").append(greenBar).append("px;'>").append("<div class='redbar' style='width: ").append(redBar).append("px;'>").append("</td></tr>").append("</table>");
    }

    protected <ReportLevel extends AggregatedReport<?, ?, ?>> void setAllCovTypes(ReportLevel reportToSet, ICoverageNode covReport) {
        Coverage tempCov = new Coverage();
        tempCov.accumulate(covReport.getClassCounter().getMissedCount(), covReport.getClassCounter().getCoveredCount());
        reportToSet.clazz = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getBranchCounter().getMissedCount(), covReport.getBranchCounter().getCoveredCount());
        reportToSet.branch = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getLineCounter().getMissedCount(), covReport.getLineCounter().getCoveredCount());
        reportToSet.line = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getInstructionCounter().getMissedCount(), covReport.getInstructionCounter().getCoveredCount());
        reportToSet.instruction = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getMethodCounter().getMissedCount(), covReport.getMethodCounter().getCoveredCount());
        reportToSet.method = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getComplexityCounter().getMissedCount(), covReport.getComplexityCounter().getCoveredCount());
        reportToSet.complexity = tempCov;
    }

    public <ReportLevel extends AggregatedReport<?, ?, ?>> void setCoverage(ReportLevel reportToSet, ICoverageNode covReport) {
        this.setAllCovTypes(reportToSet, covReport);
        if (this.maxClazz < reportToSet.clazz.getTotal()) {
            this.maxClazz = reportToSet.clazz.getTotal();
        }
        if (this.maxBranch < reportToSet.branch.getTotal()) {
            this.maxBranch = reportToSet.branch.getTotal();
        }
        if (this.maxLine < reportToSet.line.getTotal()) {
            this.maxLine = reportToSet.line.getTotal();
        }
        if (this.maxInstruction < reportToSet.instruction.getTotal()) {
            this.maxInstruction = reportToSet.instruction.getTotal();
        }
        if (this.maxMethod < reportToSet.method.getTotal()) {
            this.maxMethod = reportToSet.method.getTotal();
        }
        if (this.maxComplexity < reportToSet.complexity.getTotal()) {
            this.maxComplexity = reportToSet.complexity.getTotal();
        }
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Run<?, ?> build = this.getBuild();
        Calendar t = build.getTimestamp();
        String w = Util.fixEmptyAndTrim((String)req.getParameter("width"));
        String h = Util.fixEmptyAndTrim((String)req.getParameter("height"));
        int width = w != null ? Integer.parseInt(w) : 500;
        int height = h != null ? Integer.parseInt(h) : 200;
        CoverageGraphLayout layout = new CoverageGraphLayout().baseStroke(4.0f).axis().plot().type(CoverageGraphLayout.CoverageType.LINE).value(CoverageGraphLayout.CoverageValue.MISSED).color(Color.RED).plot().type(CoverageGraphLayout.CoverageType.LINE).value(CoverageGraphLayout.CoverageValue.COVERED).color(Color.GREEN);
        this.createGraph(t, width, height, layout).doPng(req, rsp);
    }

    GraphImpl createGraph(Calendar t, int width, int height, final CoverageGraphLayout layout) throws IOException {
        return new GraphImpl(this, t, width, height, layout){

            @Override
            protected Map<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>> createDataSetBuilder(CoverageObject<SELF> obj) {
                LinkedHashMap<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>> builders = new LinkedHashMap<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>>();
                for (CoverageGraphLayout.Axis axis : layout.getAxes()) {
                    builders.put(axis, new DataSetBuilder());
                    if (!axis.isCrop()) continue;
                    this.bounds.put(axis, new GraphImpl.Bounds());
                }
                HashMap<CoverageGraphLayout.Plot, Number> last = new HashMap<CoverageGraphLayout.Plot, Number>();
                for (CoverageObject a = obj; a != null; a = a.getPreviousResult()) {
                    ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getBuild());
                    for (CoverageGraphLayout.Plot plot : layout.getPlots()) {
                        Number value = plot.getValue(a);
                        CoverageGraphLayout.Axis axis = plot.getAxis();
                        if (axis.isSkipZero() && (value == null || value.floatValue() == 0.0f)) {
                            value = null;
                        }
                        if (value != null) {
                            if (axis.isCrop()) {
                                ((GraphImpl.Bounds)this.bounds.get(axis)).update(value);
                            }
                            last.put(plot, value);
                        } else {
                            value = (Number)last.get(plot);
                        }
                        ((DataSetBuilder)builders.get(axis)).add(value, (Comparable)((Object)plot.getMessage()), (Comparable)label);
                    }
                }
                return builders;
            }
        };
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": instruction=" + this.instruction + " branch=" + this.branch + " complexity=" + this.complexity + " line=" + this.line + " method=" + this.method + " class=" + this.clazz;
    }

    abstract class GraphImpl
    extends Graph {
        private CoverageObject<SELF> obj;
        private CoverageGraphLayout layout;
        protected Map<CoverageGraphLayout.Axis, hudson.plugins.jacoco.model.CoverageObject$GraphImpl.Bounds> bounds;

        public GraphImpl(CoverageObject<SELF> obj, Calendar timestamp, int defaultW, int defaultH, CoverageGraphLayout layout) {
            super(timestamp, defaultW, defaultH);
            this.bounds = new HashMap<CoverageGraphLayout.Axis, hudson.plugins.jacoco.model.CoverageObject$GraphImpl.Bounds>();
            this.obj = obj;
            this.layout = layout;
        }

        protected abstract Map<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>> createDataSetBuilder(CoverageObject<SELF> var1);

        public JFreeChart getGraph() {
            return this.createGraph();
        }

        protected JFreeChart createGraph() {
            LinkedHashMap<CoverageGraphLayout.Axis, CategoryDataset> dataSets = new LinkedHashMap<CoverageGraphLayout.Axis, CategoryDataset>();
            Map<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>> dataSetBuilders = this.createDataSetBuilder(this.obj);
            for (Map.Entry<CoverageGraphLayout.Axis, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>> e : dataSetBuilders.entrySet()) {
                dataSets.put(e.getKey(), e.getValue().build());
            }
            ArrayList axes = new ArrayList(dataSets.keySet());
            boolean onlyOneBuild = ((CategoryDataset)dataSets.entrySet().iterator().next().getValue()).getColumnCount() < 2;
            JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)((CategoryDataset)dataSets.get(axes.get(0))), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            CategoryPlot plot = chart.getCategoryPlot();
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(onlyOneBuild ? 0.5 : 0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            int axisId = 0;
            for (CoverageGraphLayout.Axis axis : axes) {
                int di = axisId;
                plot.setDataset(di, (CategoryDataset)dataSets.get(axis));
                plot.mapDatasetToRangeAxis(di, axisId);
                NumberAxis numberAxis = new NumberAxis(axis.getLabel());
                plot.setRangeAxis(axisId, (ValueAxis)numberAxis);
                numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                this.setBounds(axis, (ValueAxis)numberAxis);
                ++axisId;
            }
            this.layout.apply(chart, onlyOneBuild);
            return chart;
        }

        private void setBounds(CoverageGraphLayout.Axis a, ValueAxis axis) {
            if (!a.isCrop()) {
                return;
            }
            Bounds bounds = (Bounds)this.bounds.get(a);
            float border = (bounds.max - bounds.min) / 100.0f * (float)a.getCrop();
            axis.setUpperBound((double)(bounds.max + border));
            axis.setLowerBound((double)Math.max(0.0f, bounds.min - border));
        }

        protected class Bounds {
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;

            protected Bounds() {
            }

            public void update(Number value) {
                float v = value.floatValue();
                if (this.min > v) {
                    this.min = v;
                }
                if (this.max < v) {
                    this.max = v + 1.0f;
                }
            }
        }
    }
}

