/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.AggregatedReport;
import java.io.IOException;

public abstract class AbstractReport<PARENT extends AggregatedReport<?, PARENT, ?>, SELF extends CoverageObject<SELF>>
extends CoverageObject<SELF>
implements ModelObject {
    private String name;
    private PARENT parent;

    public void addCoverage(CoverageElement cv) throws IOException {
        cv.addTo(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = AbstractReport.sanitizeName(name);
    }

    protected static String sanitizeName(String name) {
        return name.replace(':', '_').replace(';', '_').replace('&', '_').replace('%', '_').replace('<', '_').replace('>', '_');
    }

    public String getDisplayName() {
        return this.getName();
    }

    protected void setParent(PARENT p) {
        this.parent = p;
    }

    public PARENT getParent() {
        return this.parent;
    }

    @Override
    public SELF getPreviousResult() {
        CoverageObject prev;
        Object p = this.parent;
        do {
            if ((p = (AggregatedReport)((AbstractReport)p).getPreviousResult()) != null) continue;
            return null;
        } while ((prev = (CoverageObject)((AggregatedReport)p).getChildren().get(this.name)) == null);
        return (SELF)prev;
    }

    @Override
    public Run<?, ?> getBuild() {
        return ((AbstractReport)this.parent).getBuild();
    }
}

