/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceNode;

public class SourceAnnotator {
    private final File src;

    public SourceAnnotator(File src) {
        this.src = src;
    }

    private List<String> readLines() throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.src), StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> aList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                aList.add(line.replaceAll("\\t", "&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp").replaceAll("<", "&lt").replaceAll(">", "&gt"));
            }
            ArrayList<String> arrayList = aList;
            return arrayList;
        }
    }

    public void printHighlightedSrcFile(ISourceNode cov, Writer output) {
        try {
            List<String> sourceLines;
            StringBuilder buf = new StringBuilder();
            try {
                sourceLines = this.readLines();
            }
            catch (IOException e) {
                e.printStackTrace();
                output.write("ERROR: Error while reading the sourcefile!");
                return;
            }
            output.write("<code style=\"white-space:pre;\">");
            for (int i = 1; i <= sourceLines.size(); ++i) {
                buf.setLength(0);
                ILine line = cov.getLine(i);
                ICounter branches = line.getBranchCounter();
                int status = line.getStatus();
                if (status != 0) {
                    this.printHighlightedLine(buf, i, branches, sourceLines.get(i - 1), status);
                } else {
                    buf.append(i).append(": ").append(sourceLines.get(i - 1)).append("<br>");
                }
                output.write(buf.toString());
            }
            output.write("</code>");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printHighlightedLine(StringBuilder buf, int lineNumber, ICounter cov, String sourceLine, int status) {
        buf.append(lineNumber).append(":");
        String tooltip = this.getTooltip(cov);
        if (tooltip != null) {
            buf.append("\u2022<SPAN title=\"").append(tooltip).append("\"");
        } else {
            buf.append(" <SPAN");
        }
        buf.append(" style=\"BACKGROUND-COLOR: ").append(this.getStatusColor(status)).append("\">").append(sourceLine).append("</SPAN>").append("<br>");
    }

    private String getTooltip(ICounter cov) {
        switch (cov.getStatus()) {
            case 2: {
                return "All " + cov.getTotalCount() + " branches covered.";
            }
            case 3: {
                return cov.getMissedCount() + " of " + cov.getTotalCount() + " branches missed.";
            }
            case 1: {
                return "All " + cov.getTotalCount() + " branches missed.";
            }
        }
        return null;
    }

    private String getStatusColor(int status) {
        switch (status) {
            case 2: {
                return "#ccffcc";
            }
            case 3: {
                return "#ffff80";
            }
            case 1: {
                return "#ffaaaa";
            }
        }
        return "none";
    }
}

