/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.AbstractBuildParameters;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.filters.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBuildParameters
extends AbstractBuildParameters {
    private final String propertiesFile;

    @DataBoundConstructor
    public FileBuildParameters(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener, AbstractProject project) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        String resolvedPropertiesFile = env.expand(this.propertiesFile);
        FilePath f = build.getWorkspace().child(resolvedPropertiesFile);
        if (!f.exists()) {
            listener.getLogger().println("[parameterizedtrigger] Could not trigger downstream project, as properties file " + resolvedPropertiesFile + " did not exist.");
            return null;
        }
        String s = f.readToString();
        s = env.expand(s);
        Properties p = new Properties();
        p.load((InputStream)new StringInputStream(s));
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            values.add(new StringParameterValue(entry.getKey().toString(), entry.getValue().toString()));
        }
        return new ParametersAction(values);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Parameters from properties file";
        }
    }
}

