/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectBuilderContributionAction;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobBuilder
extends Builder
implements DependecyDeclarer {
    private String phaseName;
    private List<PhaseJobsConfig> phaseJobs;
    private ContinuationCondition continuationCondition = ContinuationCondition.SUCCESSFUL;

    @DataBoundConstructor
    public MultiJobBuilder(String phaseName, List<PhaseJobsConfig> phaseJobs, ContinuationCondition continuationCondition) {
        this.phaseName = phaseName;
        this.phaseJobs = Util.fixNull(phaseJobs);
        this.continuationCondition = continuationCondition;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Jenkins jenkins = Jenkins.getInstance();
        MultiJobBuild multiJobBuild = (MultiJobBuild)build;
        MultiJobProject thisProject = (MultiJobProject)multiJobBuild.getProject();
        HashMap<PhaseSubJob, PhaseJobsConfig> phaseSubJobs = new HashMap<PhaseSubJob, PhaseJobsConfig>(this.phaseJobs.size());
        for (PhaseJobsConfig phaseJobConfig : this.phaseJobs) {
            Item item = jenkins.getItemByFullName(phaseJobConfig.getJobName());
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject job = (AbstractProject)item;
            phaseSubJobs.put(new PhaseSubJob(job), phaseJobConfig);
        }
        ArrayList<SubTask> subTasks = new ArrayList<SubTask>();
        for (PhaseSubJob phaseSubJob : phaseSubJobs.keySet()) {
            AbstractProject subJob = phaseSubJob.job;
            if (subJob.isDisabled()) {
                listener.getLogger().println(String.format("Skipping %s. This Job has been disabled.", subJob.getName()));
                continue;
            }
            this.reportStart(listener, subJob);
            PhaseJobsConfig phaseConfig = (PhaseJobsConfig)phaseSubJobs.get(phaseSubJob);
            ArrayList<Action> actions = new ArrayList<Action>();
            this.prepareActions((AbstractBuild)multiJobBuild, subJob, phaseConfig, listener, actions);
            while (subJob.isInQueue()) {
                TimeUnit.SECONDS.sleep(subJob.getQuietPeriod());
            }
            QueueTaskFuture future = null;
            if (!phaseConfig.isDisableJob()) {
                future = subJob.scheduleBuild2(subJob.getQuietPeriod(), (Cause)new Cause.UpstreamCause((Run)multiJobBuild), actions.toArray(new Action[0]));
            }
            if (future != null) {
                subTasks.add(new SubTask((Future<AbstractBuild>)future, phaseConfig));
                continue;
            }
            listener.getLogger().println(String.format("Warning: %s sub job is disabled.", subJob.getName()));
        }
        if (subTasks.size() < 1) {
            return true;
        }
        ExecutorService executor = Executors.newFixedThreadPool(subTasks.size());
        HashSet<Result> jobResults = new HashSet<Result>();
        ArrayBlockingQueue<SubTask> queue = new ArrayBlockingQueue<SubTask>(subTasks.size());
        for (SubTask subTask : subTasks) {
            SubJobWorker worker = new SubJobWorker(thisProject, multiJobBuild, listener, subTask, queue);
            executor.execute(worker);
        }
        executor.shutdown();
        int resultCounter = 0;
        while (!executor.isTerminated()) {
            SubTask subTask;
            subTask = (SubTask)queue.take();
            ++resultCounter;
            if (subTask.result != null) {
                jobResults.add(subTask.result);
                this.checkPhaseTermination(subTask, subTasks);
            }
            if (subTasks.size() != resultCounter) continue;
            break;
        }
        executor.shutdownNow();
        for (Result result : jobResults) {
            if (this.continuationCondition.isContinue(result)) continue;
            return false;
        }
        return true;
    }

    boolean checkPhaseTermination(SubTask subTask, List<SubTask> subTasks) {
        try {
            PhaseJobsConfig.KillPhaseOnJobResultCondition killCondition = subTask.phaseConfig.getKillPhaseOnJobResultCondition();
            if (killCondition.equals((Object)PhaseJobsConfig.KillPhaseOnJobResultCondition.NEVER)) {
                return false;
            }
            if (killCondition.isKillPhase(subTask.result)) {
                for (SubTask _subTask : subTasks) {
                    _subTask.future.cancel(true);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void reportStart(BuildListener listener, AbstractProject subJob) {
        listener.getLogger().printf("Starting build job %s.\n", HyperlinkNote.encodeTo((String)('/' + subJob.getUrl()), (String)subJob.getFullName()));
    }

    private void reportFinish(BuildListener listener, AbstractBuild jobBuild, Result result) {
        listener.getLogger().println("Finished Build : " + HyperlinkNote.encodeTo((String)("/" + jobBuild.getUrl() + "/"), (String)String.valueOf(jobBuild.getDisplayName())) + " of Job : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getProject().getUrl()), (String)jobBuild.getProject().getFullName()) + " with status :" + HyperlinkNote.encodeTo((String)('/' + jobBuild.getUrl() + "/console"), (String)result.toString()));
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, PhaseJobsConfig phaseConfig) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), phaseConfig.getJobName(), 0, this.phaseName, null, BallColor.NOTBUILT.getImage(), "not built", "");
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, null, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl());
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild, Result result) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, result, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl());
        multiJobBuild.addSubBuild(subBuild);
    }

    private void addBuildEnvironmentVariables(MultiJobBuild thisBuild, AbstractBuild jobBuild, BuildListener listener) {
        HashMap<String, String> variables = new HashMap<String, String>();
        String jobName = jobBuild.getProject().getName();
        String jobNameSafe = jobName.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
        String buildNumber = Integer.toString(jobBuild.getNumber());
        String buildResult = jobBuild.getResult().toString();
        variables.put("LAST_TRIGGERED_JOB_NAME", jobName);
        variables.put(jobNameSafe + "_BUILD_NUMBER", buildNumber);
        variables.put(jobNameSafe + "_BUILD_RESULT", buildResult);
        if (variables.get("TRIGGERED_JOB_NAMES") == null) {
            variables.put("TRIGGERED_JOB_NAMES", jobName);
        } else {
            String triggeredJobNames = (String)variables.get("TRIGGERED_JOB_NAMES") + "," + jobName;
            variables.put("TRIGGERED_JOB_NAMES", triggeredJobNames);
        }
        if (variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe) == null) {
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, "1");
        } else {
            String runCount = Integer.toString(Integer.parseInt((String)variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe)) + 1);
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, runCount);
        }
        this.injectEnvVars((AbstractBuild<?, ?>)thisBuild, listener, (Map<String, String>)variables);
    }

    private void injectEnvVars(AbstractBuild<?, ?> build, BuildListener listener, Map<String, String> incomingVars) {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        FilePath ws = build.getWorkspace();
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        try {
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            Map previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
            HashMap variables = new HashMap(previousEnvVars);
            Map resultVariables = envInjectEnvVarsService.getMergedVariables(variables, incomingVars);
            build.addAction((Action)new EnvInjectBuilderContributionAction(resultVariables));
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
        }
        catch (Throwable throwable) {
            listener.getLogger().println("[MultiJob] - [ERROR] - Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
        }
    }

    private void prepareActions(AbstractBuild build, AbstractProject project, PhaseJobsConfig projectConfig, BuildListener listener, List<Action> actions) throws IOException, InterruptedException {
        List<Action> parametersActions = null;
        parametersActions = projectConfig.getActions(build, (TaskListener)listener, project, projectConfig.isCurrParams());
        actions.addAll(parametersActions);
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public List<PhaseJobsConfig> getPhaseJobs() {
        return this.phaseJobs;
    }

    public void setPhaseJobs(List<PhaseJobsConfig> phaseJobs) {
        this.phaseJobs = phaseJobs;
    }

    public boolean phaseNameExist(String phaseName) {
        for (PhaseJobsConfig phaseJob : this.phaseJobs) {
            if (!phaseJob.getDisplayName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        Jenkins jenkins = Jenkins.getInstance();
        List<PhaseJobsConfig> phaseJobsConfigs = this.getPhaseJobs();
        if (phaseJobsConfigs == null) {
            return;
        }
        for (PhaseJobsConfig project : phaseJobsConfigs) {
            Item topLevelItem = jenkins.getItemByFullName(project.getJobName());
            if (!(topLevelItem instanceof AbstractProject)) continue;
            DependencyGraph.Dependency dependency = new DependencyGraph.Dependency(owner, (AbstractProject)topLevelItem){

                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    return false;
                }
            };
            graph.addDependency(dependency);
        }
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        Iterator<PhaseJobsConfig> i = this.phaseJobs.iterator();
        while (i.hasNext()) {
            PhaseJobsConfig phaseJobs = i.next();
            String jobName = phaseJobs.getJobName();
            if (!jobName.trim().equals(oldName)) continue;
            if (newName != null) {
                phaseJobs.setJobName(newName);
                changed = true;
                continue;
            }
            i.remove();
            changed = true;
        }
        return changed;
    }

    public boolean onJobDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public ContinuationCondition getContinuationCondition() {
        return this.continuationCondition;
    }

    public void setContinuationCondition(ContinuationCondition continuationCondition) {
        this.continuationCondition = continuationCondition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContinuationCondition {
        SUCCESSFUL("Successful"){

            public boolean isContinue(Result result) {
                return result.equals(Result.SUCCESS);
            }
        }
        ,
        UNSTABLE("Stable or Unstable but not Failed"){

            public boolean isContinue(Result result) {
                return result.isBetterOrEqualTo(Result.UNSTABLE);
            }
        }
        ,
        COMPLETED("Complete (always continue)"){

            public boolean isContinue(Result result) {
                return result.equals(Result.ABORTED) ? true : result.isBetterOrEqualTo(Result.FAILURE);
            }
        }
        ,
        FAILURE("Failed"){

            public boolean isContinue(Result result) {
                return result.equals(Result.ABORTED) || result.isBetterOrEqualTo(Result.FAILURE);
            }
        };

        private final String label;

        public abstract boolean isContinue(Result var1);

        private ContinuationCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType.equals(MultiJobProject.class);
        }

        public String getDisplayName() {
            return "MultiJob Phase";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(MultiJobBuilder.class, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.save();
            return true;
        }
    }

    private static final class PhaseSubJob {
        AbstractProject job;

        PhaseSubJob(AbstractProject job) {
            this.job = job;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubTask {
        Future<AbstractBuild> future;
        PhaseJobsConfig phaseConfig;
        Result result;

        SubTask(Future<AbstractBuild> future, PhaseJobsConfig phaseConfig) {
            this.future = future;
            this.phaseConfig = phaseConfig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubJobWorker
    extends Thread {
        MultiJobProject multiJobProject;
        MultiJobBuild multiJobBuild;
        BuildListener listener;
        SubTask subTask;
        BlockingQueue<SubTask> queue;

        SubJobWorker(MultiJobProject multiJobProject, MultiJobBuild multiJobBuild, BuildListener listener, SubTask subTask, BlockingQueue<SubTask> queue) {
            this.multiJobBuild = multiJobBuild;
            this.multiJobProject = multiJobProject;
            this.listener = listener;
            this.subTask = subTask;
            this.queue = queue;
        }

        @Override
        public void run() {
            Result result = null;
            AbstractBuild jobBuild = null;
            try {
                QueueTaskFuture future = (QueueTaskFuture)this.subTask.future;
                while (!future.isCancelled() || jobBuild != null) {
                    try {
                        jobBuild = (AbstractBuild)future.getStartCondition().get(5L, TimeUnit.SECONDS);
                        MultiJobBuilder.this.updateSubBuild(this.multiJobBuild, this.multiJobProject, jobBuild);
                    }
                    catch (Exception e) {
                        if (e instanceof TimeoutException) continue;
                        throw e;
                    }
                    if (future.isDone()) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        future.cancel(true);
                        throw new InterruptedException();
                    }
                }
                if (jobBuild != null) {
                    result = jobBuild.getResult();
                    MultiJobBuilder.this.updateSubBuild(this.multiJobBuild, this.multiJobProject, jobBuild, result);
                    ChangeLogSet changeLogSet = jobBuild.getChangeSet();
                    this.multiJobBuild.addChangeLogSet((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                    MultiJobBuilder.this.reportFinish(this.listener, jobBuild, result);
                    MultiJobBuilder.this.addBuildEnvironmentVariables(this.multiJobBuild, jobBuild, this.listener);
                    this.subTask.result = result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (jobBuild == null) {
                MultiJobBuilder.this.updateSubBuild(this.multiJobBuild, this.multiJobProject, this.subTask.phaseConfig);
            }
            this.queue.add(this.subTask);
        }
    }
}

