/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.views;

import com.tikal.jenkins.plugins.multijob.views.AbstractWrapper;
import com.tikal.jenkins.plugins.multijob.views.BuildState;
import hudson.model.AbstractBuild;
import hudson.model.BallColor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseWrapper
extends AbstractWrapper {
    final int nestLevel;
    final String phaseName;
    final boolean isConditional;
    List<BuildState> childrenBuildState = new ArrayList<BuildState>();

    public PhaseWrapper(int nestLevel, String phaseName, boolean isConditional) {
        this.nestLevel = nestLevel;
        this.phaseName = phaseName;
        this.isConditional = isConditional;
    }

    public Collection<? extends Job> getAllJobs() {
        return Collections.EMPTY_LIST;
    }

    public String getName() {
        return this.phaseName;
    }

    public String getFullName() {
        return this.phaseName;
    }

    public String getDisplayName() {
        return this.phaseName;
    }

    public String getFullDisplayName() {
        return this.phaseName;
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    public boolean isConditional() {
        return this.isConditional;
    }

    public BallColor getIconColor() {
        try {
            Result result = null;
            AbstractBuild worseBuild = null;
            for (BuildState buildState : this.childrenBuildState) {
                Job project = (Job)Jenkins.getInstance().getItemByFullName(buildState.getJobName());
                AbstractBuild build = (AbstractBuild)project.getBuildByNumber(buildState.getLastBuildNumber());
                if (build == null) continue;
                if (result == null) {
                    result = build.getResult();
                    worseBuild = build;
                    continue;
                }
                if (!build.getResult().isWorseThan(worseBuild.getResult())) continue;
                worseBuild = build;
            }
            if (worseBuild != null) {
                return worseBuild.getIconColor();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String getCss() {
        StringBuilder builder = new StringBuilder();
        builder.append("padding-left:");
        builder.append(String.valueOf((this.getNestLevel() + 1) * 20));
        builder.append("px;");
        builder.append("font-style:italic;font-size:smaller;font-weight:bold;");
        return builder.toString();
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public boolean isPhase() {
        return true;
    }

    public void addChildBuildState(BuildState jobBuildState) {
        this.childrenBuildState.add(jobBuildState);
    }

    public String getRelativeNameFrom(ItemGroup g) {
        return null;
    }

    public String getRelativeNameFrom(Item item) {
        return null;
    }
}

