/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobChangeLogSet;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.MultiJobResumeBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobTestResults;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.scm.ChangeLogSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class MultiJobBuild
extends Build<MultiJobProject, MultiJobBuild> {
    private List<SubBuild> subBuilds;
    private MultiJobChangeLogSet changeSets = new MultiJobChangeLogSet((AbstractBuild)this);
    private Map<String, SubBuild> subBuildsMap = new HashMap<String, SubBuild>();
    private MultiJobTestResults multiJobTestResults;

    public MultiJobBuild(MultiJobProject project) throws IOException {
        super((Project)project);
    }

    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        return super.getChangeSet();
    }

    public void addChangeLogSet(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet) {
        if (changeLogSet != null) {
            this.changeSets.addChangeLogSet(changeLogSet);
        }
    }

    public MultiJobBuild(MultiJobProject project, File buildDir) throws IOException {
        super((Project)project, buildDir);
    }

    public synchronized void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        super.doStop(req, rsp);
    }

    public void addAction(Action a) {
        super.addAction(a);
    }

    public void run() {
        this.execute((Run.RunExecution)new MultiJobRunnerImpl());
    }

    public List<SubBuild> getBuilders() {
        MultiJobBuild multiJobBuild = (MultiJobBuild)((MultiJobProject)this.getParent()).getNearestBuild(this.getNumber());
        return multiJobBuild.getSubBuilds();
    }

    public String getBuildParams(SubBuild subBuild) {
        try {
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItem(subBuild.getJobName(), (Item)this.getParent(), AbstractProject.class);
            AbstractBuild build = project.getBuildByNumber(subBuild.getBuildNumber());
            ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
            List parameters = action.getParameters();
            StringBuffer buffer = new StringBuffer();
            for (ParameterValue parameterValue : parameters) {
                StringParameterValue stringParameter;
                try {
                    stringParameter = (StringParameterValue)parameterValue;
                }
                catch (Exception e) {
                    continue;
                }
                String value = stringParameter.getValue();
                String name = stringParameter.getName();
                buffer.append("<input type='text' size='15' value='").append(name).append("' readonly/>").append("&nbsp;").append("<input type='text' size='35' value='").append(value).append("'/ readonly>").append("</br>");
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return "Failed to retrieve build parameters.";
        }
    }

    public void addSubBuild(SubBuild subBuild) {
        String key = subBuild.getPhaseName().concat(subBuild.getJobName()).concat(String.valueOf(subBuild.getBuildNumber()));
        if (this.subBuildsMap.containsKey(key)) {
            SubBuild e = this.subBuildsMap.get(key);
            Collections.replaceAll(this.getSubBuilds(), e, subBuild);
        } else {
            this.getSubBuilds().add(subBuild);
        }
        this.subBuildsMap.put(key, subBuild);
    }

    @Exported
    public List<SubBuild> getSubBuilds() {
        if (this.subBuilds == null) {
            this.subBuilds = new CopyOnWriteArrayList<SubBuild>();
        }
        return this.subBuilds;
    }

    public MultiJobTestResults getMultiJobTestResults() {
        return this.multiJobTestResults;
    }

    public void addTestsResult() {
        this.multiJobTestResults = new MultiJobTestResults();
        this.addAction((Action)this.multiJobTestResults);
    }

    protected class MultiJobRunnerImpl
    extends Build.BuildExecution {
        protected MultiJobRunnerImpl() {
            super((Build)MultiJobBuild.this);
        }

        public Result run(BuildListener listener) throws Exception {
            Result result = super.run(listener);
            if (this.isAborted()) {
                result = Result.ABORTED;
            } else if (this.isNotBuilt()) {
                result = Result.NOT_BUILT;
            } else if (this.isFailure()) {
                result = Result.FAILURE;
            } else if (this.isUnstable()) {
                result = Result.UNSTABLE;
            }
            if (!Result.SUCCESS.equals(result)) {
                MultiJobResumeBuild action = new MultiJobResumeBuild(super.getBuild());
                ((MultiJobBuild)super.getBuild()).addAction((Action)action);
            }
            return result;
        }

        private boolean isAborted() {
            return this.evaluateResult(Result.NOT_BUILT);
        }

        private boolean isNotBuilt() {
            return this.evaluateResult(Result.FAILURE);
        }

        private boolean isFailure() {
            return this.evaluateResult(Result.UNSTABLE);
        }

        private boolean isUnstable() {
            return this.evaluateResult(Result.SUCCESS);
        }

        private boolean evaluateResult(Result result) {
            List<SubBuild> builders = MultiJobBuild.this.getBuilders();
            for (SubBuild subBuild : builders) {
                Result buildResult;
                if (subBuild.isRetry() || subBuild.isAbort() || (buildResult = subBuild.getResult()) == null || !buildResult.isWorseThan(result)) continue;
                return true;
            }
            return false;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class SubBuild {
        private final String parentJobName;
        private final int parentBuildNumber;
        private final String jobName;
        private final String jobAlias;
        private final int buildNumber;
        private final String phaseName;
        private final Result result;
        private final String icon;
        private final String duration;
        private final String url;
        private final boolean retry;
        private final boolean aborted;
        private String buildID;

        public SubBuild(String parentJobName, int parentBuildNumber, String jobName, String jobAlias, int buildNumber, String phaseName, Result result, String icon, String duration, String url, Run<?, ?> build) {
            this.parentJobName = parentJobName;
            this.parentBuildNumber = parentBuildNumber;
            this.jobName = jobName;
            this.jobAlias = jobAlias;
            this.buildNumber = buildNumber;
            this.phaseName = phaseName;
            this.result = result;
            this.icon = icon;
            this.duration = duration;
            this.url = url;
            this.retry = false;
            this.aborted = false;
            this.buildID = build.getExternalizableId();
        }

        public SubBuild(String parentJobName, int parentBuildNumber, String jobName, String jobAlias, int buildNumber, String phaseName, Result result, String icon, String duration, String url, boolean retry, boolean aborted, Run<?, ?> build) {
            this.parentJobName = parentJobName;
            this.parentBuildNumber = parentBuildNumber;
            this.jobName = jobName;
            this.jobAlias = jobAlias;
            this.buildNumber = buildNumber;
            this.phaseName = phaseName;
            this.result = result;
            this.icon = icon;
            this.duration = duration;
            this.url = url;
            this.retry = retry;
            this.aborted = aborted;
            this.buildID = build.getExternalizableId();
        }

        @Exported
        public String getDuration() {
            return this.duration;
        }

        @Exported
        public boolean isRetry() {
            return this.retry;
        }

        @Exported
        public boolean isAbort() {
            return this.aborted;
        }

        @Exported
        public String getIcon() {
            return this.icon;
        }

        @Exported
        public String getUrl() {
            return this.url;
        }

        @Exported
        public String getPhaseName() {
            return this.phaseName;
        }

        @Exported
        public String getParentJobName() {
            return this.parentJobName;
        }

        @Exported
        public int getParentBuildNumber() {
            return this.parentBuildNumber;
        }

        @Exported
        public String getJobName() {
            return this.jobName;
        }

        @Exported
        public String getJobAlias() {
            if (this.jobAlias == null) {
                return "";
            }
            return this.jobAlias;
        }

        @Exported
        public int getBuildNumber() {
            return this.buildNumber;
        }

        @Exported
        public Result getResult() {
            return this.result;
        }

        public String toString() {
            return "SubBuild [parentJobName=" + this.parentJobName + ", parentBuildNumber=" + this.parentBuildNumber + ", jobName=" + this.jobName + ", jobAlias=" + this.jobAlias + ", buildNumber=" + this.buildNumber + "]";
        }

        @Exported
        public String getBuildID() {
            return this.buildID;
        }

        @Exported
        @CheckForNull
        public Run<?, ?> getBuild() {
            if (this.buildID != null) {
                return Run.fromExternalizableId((String)this.buildID);
            }
            return null;
        }

        @Exported
        public boolean isMultiJobBuild() {
            Run build;
            return this.buildID != null && (build = Run.fromExternalizableId((String)this.buildID)) instanceof MultiJobBuild;
        }
    }
}

