/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobTestResults;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.SurefireAggregatedReport;
import hudson.maven.reporters.SurefireReport;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.concurrent.ExecutionException;

public class MultiJobTestAggregator {
    public static void aggregateResultsFromBuild(Run subbuild, MultiJobTestResults testResults, BuildListener listener) throws ExecutionException, InterruptedException {
        if (subbuild == null) {
            return;
        }
        listener.getLogger().println("Starting to gather test results!");
        if (subbuild instanceof MatrixBuild) {
            MultiJobTestAggregator.aggregateResultsFromMatrixJob((MatrixBuild)subbuild, testResults, listener);
        } else if (subbuild instanceof MavenModuleSetBuild) {
            MultiJobTestAggregator.aggregateResultsFromMavenMultiModuleJob(subbuild, testResults, listener);
        } else {
            MultiJobTestAggregator.addTestResultFromBuild(subbuild, testResults, listener);
        }
    }

    private static void aggregateResultsFromMatrixJob(MatrixBuild run, MultiJobTestResults testResults, BuildListener listener) {
        listener.getLogger().println("Going to gather results from matrix job " + run);
        for (MatrixRun matrixRun : run.getRuns()) {
            MultiJobTestAggregator.addTestResultFromBuild((Run)matrixRun, testResults, listener);
        }
    }

    private static void aggregateResultsFromMavenMultiModuleJob(Run<?, ?> subbuild, MultiJobTestResults testResults, BuildListener listener) {
        listener.getLogger().println("Going to gather results from Maven multi module job " + subbuild);
        SurefireAggregatedReport aggregatedTestReport = (SurefireAggregatedReport)subbuild.getAction(SurefireAggregatedReport.class);
        if (aggregatedTestReport != null) {
            listener.getLogger().println("Adding test result for job " + subbuild);
            for (AggregatedTestResultAction.Child child : aggregatedTestReport.children) {
                SurefireReport testResult = aggregatedTestReport.getChildReport(child);
                testResults.add((AbstractTestResultAction)testResult);
            }
        }
    }

    private static void addTestResultFromBuild(Run subbuild, MultiJobTestResults testResults, BuildListener listener) {
        TestResultAction testResult = (TestResultAction)subbuild.getAction(TestResultAction.class);
        if (testResult != null) {
            listener.getLogger().println("Adding test result for job " + subbuild);
            testResults.add((AbstractTestResultAction)testResult);
        }
    }
}

