/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.FileBuildParameters;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobParametersAction;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.ParserRuleFile;
import com.tikal.jenkins.plugins.multijob.PredefinedBuildParameters;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.FileParameterValue;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.StringParameterDefinition;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PhaseJobsConfig
implements Describable<PhaseJobsConfig> {
    private String jobName;
    private String jobAlias;
    private String jobProperties;
    private boolean currParams;
    private boolean aggregatedTestResults;
    private boolean exposedSCM;
    private boolean disableJob;
    private String parsingRulesPath;
    private int maxRetries;
    private boolean enableRetryStrategy;
    private boolean enableCondition;
    private boolean abortAllJob;
    private String condition;
    private List<AbstractBuildParameters> configs;
    private KillPhaseOnJobResultCondition killPhaseOnJobResultCondition = KillPhaseOnJobResultCondition.NEVER;
    private boolean buildOnlyIfSCMChanges = false;
    private boolean applyConditionOnlyIfNoSCMChanges = false;

    public boolean isBuildOnlyIfSCMChanges() {
        return this.buildOnlyIfSCMChanges;
    }

    public void setBuildOnlyIfSCMChanges(boolean triggerOnlyIfSCMChanges) {
        this.buildOnlyIfSCMChanges = triggerOnlyIfSCMChanges;
    }

    public boolean isApplyConditionOnlyIfNoSCMChanges() {
        return this.applyConditionOnlyIfNoSCMChanges;
    }

    public void setApplyConditionOnlyIfNoSCMChanges(boolean applyConditionOnlyIfNoSCMChanges) {
        this.applyConditionOnlyIfNoSCMChanges = applyConditionOnlyIfNoSCMChanges;
    }

    public void setParsingRulesPath(String parsingRulesPath) {
        this.parsingRulesPath = parsingRulesPath;
    }

    public String getParsingRulesPath() {
        return this.parsingRulesPath;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setEnableRetryStrategy(boolean enableRetryStrategy) {
        this.enableRetryStrategy = enableRetryStrategy;
    }

    public boolean getEnableRetryStrategy() {
        return this.enableRetryStrategy;
    }

    public void setEnableCondition(boolean enableCondition) {
        this.enableCondition = enableCondition;
    }

    public boolean getEnableCondition() {
        return this.enableCondition;
    }

    public void setAbortAllJob(boolean abortAllJob) {
        this.abortAllJob = abortAllJob;
    }

    public boolean getAbortAllJob() {
        return this.abortAllJob;
    }

    public boolean isDisableJob() {
        return this.disableJob;
    }

    public void setDisableJob(boolean disableJob) {
        this.disableJob = disableJob;
    }

    public KillPhaseOnJobResultCondition getKillPhaseOnJobResultCondition() {
        return this.killPhaseOnJobResultCondition;
    }

    public void setKillPhaseOnJobResultCondition(KillPhaseOnJobResultCondition killPhaseOnJobResultCondition) {
        this.killPhaseOnJobResultCondition = killPhaseOnJobResultCondition;
    }

    public boolean isExposedSCM() {
        return this.exposedSCM;
    }

    public void setExposedSCM(boolean exposedSCM) {
        this.exposedSCM = exposedSCM;
    }

    public boolean isCurrParams() {
        return this.currParams;
    }

    public void setCurrParams(boolean currParams) {
        this.currParams = currParams;
    }

    public boolean isAggregatedTestResults() {
        return this.aggregatedTestResults;
    }

    public void setAggregatedTestResults(boolean aggregatedTestResults) {
        this.aggregatedTestResults = aggregatedTestResults;
    }

    public String getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(String jobProperties) {
        this.jobProperties = jobProperties;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobAlias() {
        if (this.jobAlias == null) {
            return "";
        }
        return this.jobAlias;
    }

    public void setJobAlias(String jobAlias) {
        this.jobAlias = jobAlias;
    }

    public Descriptor<PhaseJobsConfig> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    public PhaseJobsConfig(String jobName, String jobAlias, String jobProperties, boolean currParams, List<AbstractBuildParameters> configs, KillPhaseOnJobResultCondition killPhaseOnJobResultCondition, boolean disableJob, boolean enableRetryStrategy, String parsingRulesPath, int maxRetries, boolean enableCondition, boolean abortAllJob, String condition, boolean buildOnlyIfSCMChanges, boolean applyConditionOnlyIfNoSCMChanges) {
        this(jobName, jobAlias, jobProperties, currParams, configs, killPhaseOnJobResultCondition, disableJob, enableRetryStrategy, parsingRulesPath, maxRetries, enableCondition, abortAllJob, condition, buildOnlyIfSCMChanges, applyConditionOnlyIfNoSCMChanges, false);
    }

    @DataBoundConstructor
    public PhaseJobsConfig(String jobName, String jobAlias, String jobProperties, boolean currParams, List<AbstractBuildParameters> configs, KillPhaseOnJobResultCondition killPhaseOnJobResultCondition, boolean disableJob, boolean enableRetryStrategy, String parsingRulesPath, int maxRetries, boolean enableCondition, boolean abortAllJob, String condition, boolean buildOnlyIfSCMChanges, boolean applyConditionOnlyIfNoSCMChanges, boolean aggregatedTestResults) {
        this.jobName = jobName;
        this.jobAlias = jobAlias;
        this.jobProperties = jobProperties;
        this.currParams = currParams;
        this.killPhaseOnJobResultCondition = killPhaseOnJobResultCondition;
        this.disableJob = disableJob;
        this.configs = Util.fixNull(configs);
        this.enableRetryStrategy = enableRetryStrategy;
        this.maxRetries = maxRetries;
        if (this.maxRetries < 0) {
            this.maxRetries = 0;
        }
        this.parsingRulesPath = Util.fixNull((String)parsingRulesPath);
        this.enableCondition = enableCondition;
        this.abortAllJob = abortAllJob;
        this.condition = Util.fixNull((String)condition);
        this.buildOnlyIfSCMChanges = buildOnlyIfSCMChanges;
        this.applyConditionOnlyIfNoSCMChanges = applyConditionOnlyIfNoSCMChanges;
        this.aggregatedTestResults = aggregatedTestResults;
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<ParameterValue> getJobParameters(AbstractBuild<?, ?> build, TaskListener listener) {
        ParametersAction action = (ParametersAction)build.getAction(ParametersAction.class);
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>(action.getParameters().size());
        for (ParameterValue value : action.getParameters()) {
            if (value instanceof FileParameterValue) continue;
            values.add(value);
        }
        return values;
    }

    private static MultiJobParametersAction mergeParameters(MultiJobParametersAction base, MultiJobParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            if (param == null) continue;
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new MultiJobParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    public List<Action> getActions(AbstractBuild build, TaskListener listener, Job project, boolean isCurrentInclude) throws IOException, InterruptedException {
        ParametersAction defaultParameters;
        ArrayList<Action> actions = new ArrayList<Action>();
        MultiJobParametersAction params = null;
        LinkedList<ParameterValue> paramsValuesList = new LinkedList<ParameterValue>();
        Map originalActions = project.getProperties();
        ParametersDefinitionProperty parameters = null;
        for (Object object : originalActions.values()) {
            if (!(object instanceof ParametersDefinitionProperty)) continue;
            parameters = (ParametersDefinitionProperty)object;
        }
        if (parameters != null) {
            for (ParameterDefinition parameterdef : parameters.getParameterDefinitions()) {
                if (parameterdef.getDefaultParameterValue() == null) continue;
                paramsValuesList.add(parameterdef.getDefaultParameterValue());
            }
            params = new MultiJobParametersAction(paramsValuesList.toArray(new ParameterValue[paramsValuesList.size()]));
        }
        if (isCurrentInclude && (defaultParameters = (ParametersAction)build.getAction(ParametersAction.class)) != null) {
            MultiJobParametersAction mjpa = new MultiJobParametersAction(defaultParameters.getParameters());
            params = params != null ? PhaseJobsConfig.mergeParameters(params, mjpa) : mjpa;
        }
        if (this.configs != null) {
            for (AbstractBuildParameters config : this.configs) {
                try {
                    Action a = config.getAction(build, listener);
                    if (a instanceof ParametersAction) {
                        MultiJobParametersAction mjpa = new MultiJobParametersAction(((ParametersAction)a).getParameters());
                        if (params == null) {
                            params = mjpa;
                            continue;
                        }
                        params = PhaseJobsConfig.mergeParameters(params, mjpa);
                        continue;
                    }
                    if (a == null) continue;
                    actions.add(a);
                }
                catch (AbstractBuildParameters.DontTriggerException e) {
                    listener.getLogger().println("[multiJob] DontTriggerException: " + (Object)((Object)e));
                }
            }
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    public boolean hasProperties() {
        return this.jobProperties != null && !this.jobProperties.isEmpty();
    }

    public Object readResolve() {
        if (this.hasProperties()) {
            hudson.plugins.parameterizedtrigger.PredefinedBuildParameters buildParameters = new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(this.jobProperties);
            if (this.configs == null) {
                this.configs = new ArrayList<AbstractBuildParameters>();
            }
            this.configs.add((AbstractBuildParameters)buildParameters);
        }
        ArrayList<Object> oldParams = new ArrayList<Object>();
        if (this.configs != null && this.configs.size() > 0) {
            Iterator<AbstractBuildParameters> parametersIterator = this.configs.iterator();
            while (parametersIterator.hasNext()) {
                AbstractBuildParameters param = parametersIterator.next();
                if (param instanceof PredefinedBuildParameters) {
                    PredefinedBuildParameters previosStringParam = (PredefinedBuildParameters)param;
                    parametersIterator.remove();
                    oldParams.add(new hudson.plugins.parameterizedtrigger.PredefinedBuildParameters(previosStringParam.getJobProperties()));
                    continue;
                }
                if (!(param instanceof FileBuildParameters)) continue;
                FileBuildParameters previosFileParam = (FileBuildParameters)param;
                parametersIterator.remove();
                oldParams.add(new hudson.plugins.parameterizedtrigger.FileBuildParameters(previosFileParam.getPropertiesFile()));
            }
            this.configs.addAll(oldParams);
        }
        return this;
    }

    public static enum KillPhaseOnJobResultCondition {
        FAILURE("Failure (stop the phase execution if the job is failed)"){

            @Override
            public boolean isKillPhase(Result result) {
                return result.isWorseOrEqualTo(Result.FAILURE);
            }
        }
        ,
        NEVER("Never (ignore the job result and continue the phase execution)"){

            @Override
            public boolean isKillPhase(Result result) {
                return result.equals(Result.ABORTED);
            }
        }
        ,
        UNSTABLE("Unstable (stop the phase execution if the job is unstable)"){

            @Override
            public boolean isKillPhase(Result result) {
                return result.isWorseOrEqualTo(Result.UNSTABLE);
            }
        };

        private final String label;

        public abstract boolean isKillPhase(Result var1);

        private KillPhaseOnJobResultCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<PhaseJobsConfig> {
        private ParserRuleFile[] parsingRulesGlobal = new ParserRuleFile[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Phase Jobs Config";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public AutoCompletionCandidates doAutoCompleteJobName(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            for (String localJobName : Hudson.getInstance().getJobNames()) {
                if (!localJobName.toLowerCase().startsWith(value.toLowerCase())) continue;
                c.add(localJobName);
            }
            return c;
        }

        private void savePhaseJobConfigParameters(String localJobName) {
            MultiJobProject parentProject;
            List builders;
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItemByFullName(localJobName);
            List<ParameterDefinition> parameterDefinitions = this.getParameterDefinition(project);
            StringBuilder sb = new StringBuilder();
            for (ParameterDefinition pdef : parameterDefinitions) {
                String paramValue = null;
                if (pdef instanceof StringParameterDefinition) {
                    StringParameterDefinition stringParameterDefinition = (StringParameterDefinition)pdef;
                    paramValue = stringParameterDefinition.getDefaultParameterValue().getValue();
                } else if (pdef instanceof BooleanParameterDefinition) {
                    BooleanParameterDefinition booleanParameterDefinition = (BooleanParameterDefinition)pdef;
                    paramValue = String.valueOf(booleanParameterDefinition.getDefaultParameterValue().getValue());
                }
                sb.append(pdef.getName()).append("=").append(paramValue).append("\n");
            }
            AbstractProject item = DescriptorImpl.getCurrentJob();
            if (item instanceof MultiJobProject && (builders = (parentProject = (MultiJobProject)item).getBuilders()) != null) {
                for (Builder builder : builders) {
                    if (!(builder instanceof MultiJobBuilder)) continue;
                    MultiJobBuilder multiJobBuilder = (MultiJobBuilder)builder;
                    List<PhaseJobsConfig> phaseJobs = multiJobBuilder.getPhaseJobs();
                    for (PhaseJobsConfig phaseJob : phaseJobs) {
                        if (!phaseJob.getJobName().equals(localJobName)) continue;
                        phaseJob.setJobProperties(sb.toString());
                        this.save();
                    }
                }
            }
        }

        private static String getCurrentJobName() {
            String path = Descriptor.getCurrentDescriptorByNameUrl();
            String[] parts = path.split("/");
            StringBuilder builder = new StringBuilder();
            for (int i = 2; i < parts.length; i += 2) {
                if (i > 2) {
                    builder.append('/');
                }
                builder.append(parts[i]);
            }
            return builder.toString();
        }

        private static AbstractProject getCurrentJob() {
            String jobName = DescriptorImpl.getCurrentJobName();
            return (AbstractProject)Jenkins.getInstance().getItemByFullName(jobName);
        }

        public List<ParameterDefinition> getParameterDefinition(AbstractProject project) {
            ArrayList<ParameterDefinition> list = new ArrayList<ParameterDefinition>();
            Map map = project.getProperties();
            for (Map.Entry entry : map.entrySet()) {
                JobProperty property = (JobProperty)entry.getValue();
                if (!(property instanceof ParametersDefinitionProperty)) continue;
                ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)property;
                for (ParameterDefinition parameterDefinition : pdp.getParameterDefinitions()) {
                    if (!(parameterDefinition instanceof StringParameterDefinition) && !(parameterDefinition instanceof BooleanParameterDefinition) && !(parameterDefinition instanceof ChoiceParameterDefinition)) continue;
                    list.add(parameterDefinition);
                }
            }
            return list;
        }

        public String doFillJobProperties(@QueryParameter String jobName) {
            return "fill=in";
        }

        public ParserRuleFile[] getParsingRulesGlobal() {
            return Arrays.copyOf(this.parsingRulesGlobal, this.parsingRulesGlobal.length);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.parsingRulesGlobal = req.bindParametersToList(ParserRuleFile.class, "jenkins-multijob-plugin.").toArray(new ParserRuleFile[0]);
            this.save();
            return true;
        }
    }
}

