/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import groovy.util.Eval;
import hudson.model.BuildListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuietPeriodCalculator {
    private static final Logger LOG = Logger.getLogger(QuietPeriodCalculator.class.getName());
    private static final String INDEX = "index";
    private final BuildListener listener;
    private final String displayName;

    public QuietPeriodCalculator() {
        this(null, null);
    }

    QuietPeriodCalculator(BuildListener listener, String displayNameOrNull) {
        this.listener = listener;
        this.displayName = displayNameOrNull == null ? "" : displayNameOrNull + ": ";
    }

    public int calculate(String quietPeriodGroovy, int index) {
        if (quietPeriodGroovy == null) {
            return 0;
        }
        QuietPeriodCalculator.assertPositiveIndex(index);
        try {
            return this.calculateOrThrow(quietPeriodGroovy, index);
        }
        catch (Throwable t) {
            String message = "Error calculating quiet time for index " + index + " and quietPeriodGroovy [" + quietPeriodGroovy + "]: " + t.getMessage() + "; returning 0";
            LOG.log(Level.WARNING, message, t);
            this.log(message);
            return 0;
        }
    }

    public int calculateOrThrow(String quietPeriodGroovy, int index) {
        QuietPeriodCalculator.assertPositiveIndex(index);
        Integer quietPeriod = (Integer)Eval.me((String)INDEX, (Object)index, (String)quietPeriodGroovy);
        this.log(this.displayName + "Quiet period groovy=[" + quietPeriodGroovy + "], index=" + index + " -> quietPeriodGroovy=" + quietPeriod);
        return quietPeriod;
    }

    private static void assertPositiveIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("positive index expected, got " + index);
        }
    }

    private void log(String s) {
        if (this.listener != null) {
            this.listener.getLogger().println(s);
        }
    }
}

