/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import com.tikal.jenkins.plugins.multijob.QuietPeriodCalculator;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import java.util.List;
import jenkins.model.ParameterizedJobMixIn;

public final class SubTask {
    public final Job subJob;
    public final PhaseJobsConfig phaseConfig;
    public final List<Action> actions;
    public QueueTaskFuture<? extends Queue.Executable> future;
    public final MultiJobBuild multiJobBuild;
    private final int enabledIndex;
    private final String quietPeriodGroovy;
    private final BuildListener listener;
    public Result result;
    private boolean cancel;
    private boolean isShouldTrigger;

    SubTask(Job subJob, PhaseJobsConfig phaseConfig, List<Action> actions, MultiJobBuild multiJobBuild, boolean isShouldTrigger, int enabledIndex, String quietPeriodGroovy, BuildListener listener) {
        this.subJob = subJob;
        this.phaseConfig = phaseConfig;
        this.actions = actions;
        this.multiJobBuild = multiJobBuild;
        this.enabledIndex = enabledIndex;
        this.quietPeriodGroovy = quietPeriodGroovy;
        this.listener = listener;
        this.cancel = false;
        this.isShouldTrigger = isShouldTrigger;
    }

    public boolean isShouldTrigger() {
        return this.isShouldTrigger;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void cancelJob() {
        this.cancel = true;
    }

    public void generateFuture() {
        Cause.UpstreamCause cause = new Cause.UpstreamCause((Run)this.multiJobBuild);
        List<Action> queueActions = this.actions;
        if (cause != null) {
            queueActions.add((Action)new CauseAction((Cause)cause));
        }
        if (this.subJob instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn parameterizedJobMixIn = new ParameterizedJobMixIn(){

                protected Job<?, ?> asJob() {
                    return SubTask.this.subJob;
                }
            };
            ((ParameterizedJobMixIn.ParameterizedJob)this.subJob).isDisabled();
            String subJobName = this.subJob.getName();
            int quietPeriod = new QuietPeriodCalculator(this.listener, subJobName).calculate(this.quietPeriodGroovy, this.enabledIndex);
            this.listener.getLogger().printf("quiet period for %s is %d seconds.", subJobName, quietPeriod);
            this.future = parameterizedJobMixIn.scheduleBuild2(quietPeriod, queueActions.toArray(new Action[queueActions.size()]));
        }
    }
}

