/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.counters;

import com.tikal.jenkins.plugins.multijob.counters.CounterKey;
import hudson.model.BuildListener;
import java.util.HashMap;
import java.util.Map;

public final class CounterHelper {
    private CounterHelper() {
    }

    public static synchronized Map<String, String> putPhaseAddMultijobAndMergeTheRest(BuildListener listener, String phaseName, Map<String, String> incomingVars, Map<String, String> previousEnvVars) {
        String safePhaseName = phaseName.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
        HashMap<String, String> mixtured = new HashMap<String, String>(previousEnvVars);
        for (Map.Entry<String, String> entry : incomingVars.entrySet()) {
            String key = entry.getKey();
            CounterKey counterKey = CounterKey.safetyValueOf(key);
            String incomingValue = entry.getValue();
            if (counterKey == null) {
                mixtured.put(key, incomingValue);
                continue;
            }
            key = counterKey.getPhaseKey();
            String previousValue = CounterHelper.zeroIfNull(previousEnvVars.get(key));
            incomingValue = CounterHelper.zeroIfNull(incomingValue);
            mixtured.put(key, incomingValue);
            mixtured.put(safePhaseName + "_" + counterKey.name(), incomingValue);
            key = counterKey.getMultiJobKey();
            previousValue = CounterHelper.zeroIfNull(previousEnvVars.get(key));
            mixtured.put(key, String.valueOf(Integer.parseInt(incomingValue) + Integer.parseInt(previousValue)));
        }
        if (mixtured.containsKey("PHASE_RESULT")) {
            mixtured.put(safePhaseName + "_RESULT", (String)mixtured.get("PHASE_RESULT"));
        }
        return mixtured;
    }

    private static String zeroIfNull(String value) {
        if (value == null || value.trim().length() == 0) {
            return "0";
        }
        return value;
    }
}

