/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.counters;

import hudson.model.Result;

public enum CounterKey {
    SUCCESSFUL{

        @Override
        public boolean appliesTo(Result result) {
            return result.isBetterOrEqualTo(Result.UNSTABLE);
        }
    }
    ,
    STABLE{

        @Override
        public boolean appliesTo(Result result) {
            return Result.SUCCESS.equals(result);
        }
    }
    ,
    UNSTABLE{

        @Override
        public boolean appliesTo(Result result) {
            return Result.UNSTABLE.equals(result);
        }
    }
    ,
    FAILED{

        @Override
        public boolean appliesTo(Result result) {
            return Result.FAILURE.equals(result);
        }
    }
    ,
    ABORTED{

        @Override
        public boolean appliesTo(Result result) {
            return Result.ABORTED.equals(result);
        }
    }
    ,
    SKIPPED{

        @Override
        public boolean appliesTo(Result result) {
            return false;
        }
    };

    public static final String[] KEYS;
    private final String multiJobKey = "MULTIJOB_" + this.name();
    private final String phaseKey = "PHASE_" + this.name();

    public abstract boolean appliesTo(Result var1);

    public String getMultiJobKey() {
        return this.multiJobKey;
    }

    public String getPhaseKey() {
        return this.phaseKey;
    }

    public static CounterKey safetyValueOf(String key) {
        try {
            return CounterKey.valueOf(key);
        }
        catch (IllegalArgumentException cause) {
            return null;
        }
    }

    static {
        String[] keys = new String[CounterKey.values().length * 2];
        int index = 0;
        for (CounterKey key : CounterKey.values()) {
            keys[index++] = key.getMultiJobKey();
            keys[index++] = key.getPhaseKey();
        }
        KEYS = keys;
    }
}

