/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.counters;

import com.tikal.jenkins.plugins.multijob.counters.CounterKey;
import hudson.model.Result;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class CounterManager {
    public static final String PHASE_RESULT = "PHASE_RESULT";
    private final Map<CounterKey, AtomicInteger> counters;
    private Result phaseResult = Result.SUCCESS;

    public CounterManager() {
        HashMap<CounterKey, AtomicInteger> counters = new HashMap<CounterKey, AtomicInteger>(CounterKey.values().length);
        for (CounterKey key : CounterKey.values()) {
            counters.put(key, new AtomicInteger(0));
        }
        this.counters = counters;
    }

    public void process(Result result) {
        for (CounterKey key : CounterKey.values()) {
            if (!key.appliesTo(result)) continue;
            this.counters.get((Object)key).incrementAndGet();
        }
        if (result.isWorseThan(this.phaseResult)) {
            this.phaseResult = result;
        }
    }

    public void processSkipped() {
        this.counters.get((Object)CounterKey.SKIPPED).incrementAndGet();
    }

    public void processAborted() {
        this.counters.get((Object)CounterKey.ABORTED).incrementAndGet();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.counters.size());
        map.put(PHASE_RESULT, this.phaseResult.toString());
        for (CounterKey key : CounterKey.values()) {
            map.put(key.name(), String.valueOf(this.counters.get((Object)key)));
        }
        return map;
    }

    public String toString() {
        return this.counters.toString();
    }
}

