/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob.views;

import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobBuilder;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import com.tikal.jenkins.plugins.multijob.views.BuildState;
import com.tikal.jenkins.plugins.multijob.views.MultiJobListViewColumn;
import com.tikal.jenkins.plugins.multijob.views.PhaseWrapper;
import com.tikal.jenkins.plugins.multijob.views.ProjectWrapper;
import hudson.Extension;
import hudson.Indenter;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuilder;
import org.jenkinsci.plugins.conditionalbuildstep.singlestep.SingleConditionalBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MultiJobView
extends ListView {
    private static final Logger LOG = Logger.getLogger(MultiJobView.class.getName());

    @DataBoundConstructor
    public MultiJobView(String name) {
        super(name);
    }

    public MultiJobView(String name, ViewGroup owner) {
        super(name, owner);
    }

    public List<TopLevelItem> getItems() {
        List items = Jenkins.getInstance().getItems();
        ArrayList<TopLevelItem> out = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : items) {
            if (!(item instanceof MultiJobProject)) continue;
            MultiJobProject project = (MultiJobProject)item;
            this.addTopLevelProject(project, out);
        }
        return out;
    }

    public List<TopLevelItem> getRootItem(MultiJobProject multiJobProject) {
        ArrayList<TopLevelItem> out = new ArrayList<TopLevelItem>();
        this.addTopLevelProject(multiJobProject, out);
        return out;
    }

    private void addTopLevelProject(MultiJobProject project, List<TopLevelItem> out) {
        if (project.getBuilds().isEmpty()) {
            this.addMultiProject(null, project, this.createBuildState(project), 0, null, out);
        } else {
            this.addMultiProject(null, (MultiJobBuild)project.getLastBuild(), this.createBuildState(project), 0, out);
        }
    }

    private void addMultiProject(MultiJobProject parent, MultiJobProject project, BuildState buildState, int nestLevel, String phaseName, List<TopLevelItem> out) {
        out.add(new ProjectWrapper(parent, (Job)project, buildState, nestLevel, (Run)(nestLevel == 0 ? project.getLastBuild() : null)));
        List builders = project.getBuilders();
        for (Builder builder : builders) {
            BuildStep buildStep;
            int phaseNestLevel = nestLevel + 1;
            if (builder instanceof MultiJobBuilder) {
                this.addProjectFromBuilder(project, buildState, out, (BuildStep)builder, phaseNestLevel, false);
                continue;
            }
            if (builder instanceof ConditionalBuilder) {
                List conditionalbuilders = ((ConditionalBuilder)builder).getConditionalbuilders();
                for (BuildStep buildStep2 : conditionalbuilders) {
                    if (!(buildStep2 instanceof MultiJobBuilder)) continue;
                    this.addProjectFromBuilder(project, buildState, out, buildStep2, phaseNestLevel, true);
                }
                continue;
            }
            if (!(builder instanceof SingleConditionalBuilder) || !((buildStep = ((SingleConditionalBuilder)builder).getBuildStep()) instanceof MultiJobBuilder)) continue;
            this.addProjectFromBuilder(project, buildState, out, buildStep, phaseNestLevel, true);
        }
    }

    private void addMultiProject(MultiJobBuild parentBuild, MultiJobBuild build, BuildState buildState, int nestLevel, List<TopLevelItem> out) {
        out.add(new ProjectWrapper(parentBuild != null ? (MultiJobProject)parentBuild.getProject() : null, (Job)(build != null ? build.getProject() : null), buildState, nestLevel, (Run)build));
        List builders = Optional.ofNullable(build).map(AbstractBuild::getProject).map(Project::getBuilders).orElseGet(Collections::emptyList);
        for (Builder builder : builders) {
            BuildStep buildStep;
            int phaseNestLevel = nestLevel + 1;
            if (builder instanceof MultiJobBuilder) {
                this.addProjectFromBuilder(build, buildState, out, (BuildStep)builder, phaseNestLevel, false);
                continue;
            }
            if (builder instanceof ConditionalBuilder) {
                List conditionalbuilders = ((ConditionalBuilder)builder).getConditionalbuilders();
                for (BuildStep buildStep2 : conditionalbuilders) {
                    if (!(buildStep2 instanceof MultiJobBuilder)) continue;
                    this.addProjectFromBuilder(build, buildState, out, buildStep2, phaseNestLevel, true);
                }
                continue;
            }
            if (!(builder instanceof SingleConditionalBuilder) || !((buildStep = ((SingleConditionalBuilder)builder).getBuildStep()) instanceof MultiJobBuilder)) continue;
            this.addProjectFromBuilder(build, buildState, out, buildStep, phaseNestLevel, true);
        }
    }

    private void addProjectFromBuilder(MultiJobProject project, BuildState buildState, List<TopLevelItem> out, BuildStep builder, int phaseNestLevel, boolean isConditional) {
        MultiJobBuilder reactorBuilder = (MultiJobBuilder)builder;
        List<PhaseJobsConfig> subProjects = reactorBuilder.getPhaseJobs();
        String currentPhaseName = reactorBuilder.getPhaseName();
        PhaseWrapper phaseWrapper = new PhaseWrapper((Job)project, phaseNestLevel, currentPhaseName, isConditional);
        out.add(phaseWrapper);
        for (PhaseJobsConfig projectConfig : subProjects) {
            MultiJobProject subProject;
            Item tli = Jenkins.getInstance().getItem(projectConfig.getJobName(), project.getParent(), AbstractProject.class);
            if (tli == null) continue;
            BuildState jobBuildState = this.createBuildState(buildState, project, null, projectConfig);
            phaseWrapper.addChildBuildState(jobBuildState);
            if (tli instanceof MultiJobProject) {
                subProject = (MultiJobProject)tli;
                this.addMultiProject(project, subProject, jobBuildState, phaseNestLevel + 1, currentPhaseName, out);
                continue;
            }
            subProject = (Job)tli;
            this.addSimpleProject(project, (Job)subProject, jobBuildState, phaseNestLevel + 1, out, null);
        }
    }

    private void addProjectFromBuilder(MultiJobBuild build, BuildState buildState, List<TopLevelItem> out, BuildStep builder, int phaseNestLevel, boolean isConditional) {
        MultiJobBuilder reactorBuilder = (MultiJobBuilder)builder;
        List<PhaseJobsConfig> subProjects = reactorBuilder.getPhaseJobs();
        String currentPhaseName = reactorBuilder.getPhaseName();
        PhaseWrapper phaseWrapper = new PhaseWrapper((Job)build.getProject(), phaseNestLevel, currentPhaseName, isConditional);
        out.add(phaseWrapper);
        for (PhaseJobsConfig projectConfig : subProjects) {
            Item abstractProject = Jenkins.getInstance().getItem(projectConfig.getJobName(), (Item)build.getParent(), Job.class);
            if (abstractProject == null) continue;
            MultiJobBuild.SubBuild sb = this.searchBuildnumberFromMultijobbuild(build, projectConfig, null);
            Run<?, ?> subBuild = sb == null ? null : sb.getBuild();
            BuildState jobBuildState = this.createBuildState(buildState, (MultiJobProject)build.getProject(), subBuild, projectConfig);
            phaseWrapper.addChildBuildState(jobBuildState);
            if (abstractProject instanceof MultiJobProject) {
                if (subBuild == null) {
                    this.addMultiProject((MultiJobProject)build.getProject(), (MultiJobProject)abstractProject, jobBuildState, phaseNestLevel + 1, currentPhaseName, out);
                    continue;
                }
                this.addMultiProject(build, (MultiJobBuild)subBuild, jobBuildState, phaseNestLevel + 1, out);
                continue;
            }
            this.addSimpleProject((MultiJobProject)build.getProject(), subBuild == null ? (Job)abstractProject : subBuild.getParent(), jobBuildState, phaseNestLevel + 1, out, subBuild);
        }
    }

    private void addSimpleProject(MultiJobProject parent, Job project, BuildState buildState, int nestLevel, List<TopLevelItem> out, Run build) {
        out.add(new ProjectWrapper(parent, project, buildState, nestLevel, build));
    }

    private MultiJobBuild.SubBuild searchBuildnumberFromMultijobbuild(MultiJobBuild multiJobBuild, PhaseJobsConfig config, Result result) {
        for (MultiJobBuild.SubBuild subBuild : multiJobBuild.getSubBuilds()) {
            if (!subBuild.getJobName().equals(config.getJobName()) || !subBuild.getJobAlias().equals(config.getJobAlias())) continue;
            if (result != null) {
                if (!result.equals(subBuild.getResult())) continue;
                return subBuild;
            }
            return subBuild;
        }
        return null;
    }

    private BuildState createBuildState(BuildState parentBuildState, MultiJobProject multiJobProject, Run abstractBuild, PhaseJobsConfig config) {
        Object sb;
        int previousBuildNumber = 0;
        int lastBuildNumber = 0;
        int lastSuccessBuildNumber = 0;
        int lastFailureBuildNumber = 0;
        MultiJobBuild previousParentBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getPreviousBuildNumber());
        MultiJobBuild lastParentBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastBuildNumber());
        MultiJobBuild lastParentSuccessBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastSuccessBuildNumber());
        MultiJobBuild lastParentFailureBuild = (MultiJobBuild)multiJobProject.getBuildByNumber(parentBuildState.getLastFailureBuildNumber());
        if (abstractBuild != null) {
            MultiJobBuild multiJobBuild;
            MultiJobBuild.SubBuild sb2;
            if (Result.SUCCESS.equals(abstractBuild.getResult())) {
                lastSuccessBuildNumber = abstractBuild.getNumber();
                if (lastParentFailureBuild != null) {
                    sb = this.searchBuildnumberFromMultijobbuild(lastParentFailureBuild, config, Result.FAILURE);
                    int n = lastFailureBuildNumber = sb == null ? 0 : ((MultiJobBuild.SubBuild)sb).getBuildNumber();
                }
                if (lastFailureBuildNumber == 0) {
                    sb = multiJobProject.getBuilds().iterator();
                    while (sb.hasNext() && (lastFailureBuildNumber = (sb2 = this.searchBuildnumberFromMultijobbuild(multiJobBuild = (MultiJobBuild)((Object)sb.next()), config, Result.FAILURE)) == null ? 0 : sb2.getBuildNumber()) == 0) {
                    }
                }
            }
            if (Result.FAILURE.equals(abstractBuild.getResult())) {
                lastFailureBuildNumber = abstractBuild.getNumber();
                if (lastParentSuccessBuild != null) {
                    sb = this.searchBuildnumberFromMultijobbuild(lastParentSuccessBuild, config, Result.SUCCESS);
                    int n = lastSuccessBuildNumber = sb == null ? 0 : ((MultiJobBuild.SubBuild)sb).getBuildNumber();
                }
                if (lastSuccessBuildNumber == 0) {
                    sb = multiJobProject.getBuilds().iterator();
                    while (sb.hasNext() && (lastSuccessBuildNumber = (sb2 = this.searchBuildnumberFromMultijobbuild(multiJobBuild = (MultiJobBuild)((Object)sb.next()), config, Result.SUCCESS)) == null ? 0 : sb2.getBuildNumber()) == 0) {
                    }
                }
            }
        }
        if (previousParentBuild != null) {
            sb = this.searchBuildnumberFromMultijobbuild(previousParentBuild, config, null);
            int n = previousBuildNumber = sb == null ? 0 : ((MultiJobBuild.SubBuild)sb).getBuildNumber();
        }
        if (lastParentBuild != null) {
            sb = this.searchBuildnumberFromMultijobbuild(lastParentBuild, config, null);
            lastBuildNumber = sb == null ? 0 : ((MultiJobBuild.SubBuild)sb).getBuildNumber();
        }
        return new BuildState(config.getJobName(), config.getJobAlias(), previousBuildNumber, lastBuildNumber, lastSuccessBuildNumber, lastFailureBuildNumber);
    }

    private BuildState createBuildState(MultiJobProject project) {
        MultiJobBuild lastBuild = (MultiJobBuild)project.getLastBuild();
        MultiJobBuild previousBuild = lastBuild == null ? null : (MultiJobBuild)lastBuild.getPreviousBuild();
        MultiJobBuild lastSuccessfulBuild = (MultiJobBuild)project.getLastSuccessfulBuild();
        MultiJobBuild lastFailedBuild = (MultiJobBuild)project.getLastFailedBuild();
        return new BuildState(project.getName(), null, previousBuild == null ? 0 : previousBuild.getNumber(), lastBuild == null ? 0 : lastBuild.getNumber(), lastSuccessfulBuild == null ? 0 : lastSuccessfulBuild.getNumber(), lastFailedBuild == null ? 0 : lastFailedBuild.getNumber());
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
    }

    protected void initColumns() {
        super.initColumns();
        try {
            this.getColumns().replaceBy(MultiJobListViewColumn.createDefaultInitialColumnList());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to initialize columns", e);
        }
    }

    public Indenter<Job> createIndenter() {
        return new Indenter<Job>(){

            protected int getNestLevel(Job job) {
                if ((TopLevelItem)job instanceof ProjectWrapper) {
                    ProjectWrapper projectWrapper = (ProjectWrapper)((TopLevelItem)job);
                    return projectWrapper.getNestLevel();
                }
                return 0;
            }
        };
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "MultiJob View";
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

