/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.CommonBuilder;
import com.atlassian.httpclient.apache.httpcomponents.DefaultMessage;
import com.atlassian.httpclient.apache.httpcomponents.Headers;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.ResponsePromise;
import io.atlassian.fugue.Option;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultRequest
extends DefaultMessage
implements Request {
    private final URI uri;
    private final boolean cacheDisabled;
    private final Map<String, String> attributes;
    private final Request.Method method;
    private final Option<Long> contentLength;

    private DefaultRequest(URI uri, boolean cacheDisabled, Map<String, String> attributes, Headers headers, Request.Method method, InputStream entityStream, Option<Long> contentLength) {
        super(headers, entityStream, (Option<Long>)Option.none());
        this.uri = uri;
        this.cacheDisabled = cacheDisabled;
        this.attributes = attributes;
        this.method = method;
        this.contentLength = contentLength;
    }

    public static DefaultRequestBuilder builder(HttpClient httpClient) {
        return new DefaultRequestBuilder(httpClient);
    }

    public Request.Method getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getAccept() {
        return super.getAccept();
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Option<Long> getContentLength() {
        return this.contentLength;
    }

    public boolean isCacheDisabled() {
        return this.cacheDisabled;
    }

    public Request validate() {
        super.validate();
        Objects.nonNull(this.uri);
        Objects.nonNull(this.method);
        switch (this.method) {
            case GET: 
            case DELETE: 
            case HEAD: {
                if (!this.hasEntity()) break;
                throw new IllegalStateException("Request method " + this.method + " does not support an entity");
            }
        }
        return this;
    }

    public static class DefaultRequestBuilder
    implements Request.Builder {
        private final HttpClient httpClient;
        private final Map<String, String> attributes;
        private final CommonBuilder<DefaultRequest> commonBuilder;
        private URI uri;
        private boolean cacheDisabled;
        private Request.Method method;
        private Option<Long> contentLength;

        public DefaultRequestBuilder(HttpClient httpClient) {
            this.httpClient = httpClient;
            this.attributes = new HashMap<String, String>();
            this.commonBuilder = new CommonBuilder();
            this.setAccept("*/*");
            this.contentLength = Option.none();
        }

        public DefaultRequestBuilder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public DefaultRequestBuilder setAccept(String accept) {
            this.setHeader("Accept", accept);
            return this;
        }

        public DefaultRequestBuilder setCacheDisabled() {
            this.cacheDisabled = true;
            return this;
        }

        public DefaultRequestBuilder setAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public DefaultRequestBuilder setAttributes(Map<String, String> properties) {
            this.attributes.putAll(properties);
            return this;
        }

        public DefaultRequestBuilder setEntity(EntityBuilder entityBuilder) {
            EntityBuilder.Entity entity = entityBuilder.build();
            Map headers = entity.getHeaders();
            for (Map.Entry headerEntry : headers.entrySet()) {
                this.setHeader((String)headerEntry.getKey(), (String)headerEntry.getValue());
            }
            this.setEntityStream(entity.getInputStream());
            return this;
        }

        public DefaultRequestBuilder setHeader(String name, String value) {
            this.commonBuilder.setHeader(name, value);
            return this;
        }

        public DefaultRequestBuilder setHeaders(Map<String, String> headers) {
            this.commonBuilder.setHeaders((Map)headers);
            return this;
        }

        public DefaultRequestBuilder setEntity(String entity) {
            this.commonBuilder.setEntity(entity);
            this.setContentLength(entity.length());
            return this;
        }

        public DefaultRequestBuilder setEntityStream(InputStream entityStream) {
            this.commonBuilder.setEntityStream(entityStream);
            return this;
        }

        public DefaultRequestBuilder setContentCharset(String contentCharset) {
            this.commonBuilder.setContentCharset(contentCharset);
            return this;
        }

        public DefaultRequestBuilder setContentType(String contentType) {
            this.commonBuilder.setContentType(contentType);
            return this;
        }

        public DefaultRequestBuilder setEntityStream(InputStream entityStream, String charset) {
            this.setEntityStream(entityStream);
            this.commonBuilder.setContentCharset(charset);
            return this;
        }

        public DefaultRequestBuilder setContentLength(long contentLength) {
            if (contentLength < 0L) {
                throw new IllegalArgumentException("Content length must be greater than or equal to 0");
            }
            this.contentLength = Option.some((Object)contentLength);
            return this;
        }

        public DefaultRequest build() {
            return new DefaultRequest(this.uri, this.cacheDisabled, this.attributes, this.commonBuilder.getHeaders(), this.method, this.commonBuilder.getEntityStream(), this.contentLength);
        }

        public ResponsePromise get() {
            return this.execute(Request.Method.GET);
        }

        public ResponsePromise post() {
            return this.execute(Request.Method.POST);
        }

        public ResponsePromise put() {
            return this.execute(Request.Method.PUT);
        }

        public ResponsePromise delete() {
            return this.execute(Request.Method.DELETE);
        }

        public ResponsePromise options() {
            return this.execute(Request.Method.OPTIONS);
        }

        public ResponsePromise head() {
            return this.execute(Request.Method.HEAD);
        }

        public ResponsePromise trace() {
            return this.execute(Request.Method.TRACE);
        }

        public ResponsePromise execute(Request.Method method) {
            Objects.nonNull(method);
            this.setMethod(method);
            return this.httpClient.execute(this.build().validate());
        }

        public void setMethod(Request.Method method) {
            this.method = method;
        }
    }
}

