/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MavenUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtils.class);
    private static final String UNKNOWN_VERSION = "unknown";

    MavenUtils() {
    }

    static String getVersion(String groupId, String artifactId) {
        String string;
        block8: {
            Properties props = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(MavenUtils.getPomFilePath(groupId, artifactId));
            try {
                props.load(is);
                string = props.getProperty("version", UNKNOWN_VERSION);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.debug("Could not find version for maven artifact {}:{}", (Object)groupId, (Object)artifactId);
                    logger.debug("Got the following exception:", (Throwable)e);
                    return UNKNOWN_VERSION;
                }
            }
            is.close();
        }
        return string;
    }

    private static String getPomFilePath(String groupId, String artifactId) {
        return String.format("META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
    }
}

