/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraEnvironmentContributingAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.plugins.jira.selector.DefaultIssueSelector;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraEnvironmentVariableBuilder
extends Builder {
    private AbstractIssueSelector issueSelector;

    @DataBoundConstructor
    public JiraEnvironmentVariableBuilder(AbstractIssueSelector issueSelector) {
        this.issueSelector = issueSelector;
    }

    public AbstractIssueSelector getIssueSelector() {
        AbstractIssueSelector uis = this.issueSelector;
        if (uis == null) {
            uis = new DefaultIssueSelector();
        }
        this.issueSelector = uis;
        return this.issueSelector;
    }

    JiraSite getSiteForProject(AbstractProject<?, ?> project) {
        return JiraSite.get(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        JiraSite site = this.getSiteForProject(build.getProject());
        if (site == null) {
            throw new AbortException(Messages.JiraEnvironmentVariableBuilder_NoJiraSite());
        }
        Set<String> ids = this.getIssueSelector().findIssueIds((Run<?, ?>)build, site, (TaskListener)listener);
        String idList = StringUtils.join(ids, (String)",");
        listener.getLogger().println(Messages.JiraEnvironmentVariableBuilder_Updating("JIRA_ISSUES", idList));
        build.addAction((Action)new JiraEnvironmentContributingAction(idList, site.getName()));
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> klass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraEnvironmentVariableBuilder_DisplayName();
        }
    }
}

