/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Component;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Permissions;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ProxyConfiguration;
import hudson.plugins.jira.extension.ExtendedJiraRestClient;
import hudson.plugins.jira.extension.ExtendedVersion;
import hudson.plugins.jira.extension.ExtendedVersionInput;
import hudson.plugins.jira.model.JiraIssueField;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JiraRestService {
    private static final Logger LOGGER = Logger.getLogger(JiraRestService.class.getName());
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final String BASE_API_PATH = "rest/api/2";
    static final long BUG_ISSUE_TYPE_ID = 1L;
    private final URI uri;
    private final ExtendedJiraRestClient jiraRestClient;
    private final ObjectMapper objectMapper;
    private final String authHeader;
    private final String baseApiPath;
    private final int timeout;

    @Deprecated
    public JiraRestService(URI uri, ExtendedJiraRestClient jiraRestClient, String username, String password) {
        this(uri, jiraRestClient, username, password, 10);
    }

    public JiraRestService(URI uri, ExtendedJiraRestClient jiraRestClient, String username, String password, int timeout) {
        this.uri = uri;
        this.objectMapper = new ObjectMapper();
        this.timeout = timeout;
        String login = username + ":" + password;
        try {
            byte[] encodeBase64 = Base64.encodeBase64((byte[])login.getBytes("UTF-8"));
            this.authHeader = "Basic " + new String(encodeBase64, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warning("Jira REST encode username:password error. cause: " + e.getMessage());
            throw new RuntimeException("failed to encode username:password using Base64");
        }
        this.jiraRestClient = jiraRestClient;
        this.baseApiPath = this.buildBaseApiPath(uri);
    }

    public JiraRestService(URI uri, ExtendedJiraRestClient jiraRestClient, String token, int timeout) {
        this.uri = uri;
        this.objectMapper = new ObjectMapper();
        this.timeout = timeout;
        this.authHeader = "Bearer " + token;
        this.jiraRestClient = jiraRestClient;
        this.baseApiPath = this.buildBaseApiPath(uri);
    }

    private String buildBaseApiPath(URI uri) {
        StringBuilder builder = new StringBuilder();
        if (uri.getPath() != null) {
            builder.append(uri.getPath());
            if (!uri.getPath().endsWith("/")) {
                builder.append('/');
            }
        } else {
            builder.append('/');
        }
        builder.append(BASE_API_PATH);
        return builder.toString();
    }

    public void addComment(String issueId, String commentBody, String groupVisibility, String roleVisibility) {
        URIBuilder builder = new URIBuilder(this.uri).setPath(String.format("%s/issue/%s/comment", this.baseApiPath, issueId));
        Comment comment = StringUtils.isNotBlank((String)groupVisibility) ? Comment.createWithGroupLevel((String)commentBody, (String)groupVisibility) : (StringUtils.isNotBlank((String)roleVisibility) ? Comment.createWithRoleLevel((String)commentBody, (String)roleVisibility) : Comment.valueOf((String)commentBody));
        try {
            this.jiraRestClient.getIssueClient().addComment(builder.build(), comment).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client add comment error. cause: " + e.getMessage(), e);
        }
    }

    public Issue getIssue(String issueKey) {
        try {
            return (Issue)this.jiraRestClient.getIssueClient().getIssue(issueKey).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof RestClientException && ((RestClientException)e.getCause()).getStatusCode().isPresent() && (Integer)((RestClientException)e.getCause()).getStatusCode().get() == 404) {
                LOGGER.log(Level.INFO, "Issue '" + issueKey + "' not found in Jira.");
            } else {
                LOGGER.log(Level.WARNING, "Jira REST client get issue error. cause: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public List<IssueType> getIssueTypes() {
        try {
            return StreamSupport.stream(((Iterable)this.jiraRestClient.getMetadataClient().getIssueTypes().get((long)this.timeout, TimeUnit.SECONDS)).spliterator(), false).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get issue types error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public List<Priority> getPriorities() {
        try {
            return StreamSupport.stream(((Iterable)this.jiraRestClient.getMetadataClient().getPriorities().get((long)this.timeout, TimeUnit.SECONDS)).spliterator(), false).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get priorities error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public List<String> getProjectsKeys() {
        Iterable<Object> projects = Collections.emptyList();
        try {
            projects = (Iterable)this.jiraRestClient.getProjectClient().getAllProjects().get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get project keys error. cause: " + e.getMessage(), e);
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (BasicProject basicProject : projects) {
            keys.add(basicProject.getKey());
        }
        return keys;
    }

    public List<Issue> getIssuesFromJqlSearch(String jqlSearch, Integer maxResults) throws TimeoutException {
        try {
            SearchResult searchResult = (SearchResult)this.jiraRestClient.getSearchClient().searchJql(jqlSearch, maxResults, Integer.valueOf(0), null).get((long)this.timeout, TimeUnit.SECONDS);
            return StreamSupport.stream(searchResult.getIssues().spliterator(), false).collect(Collectors.toList());
        }
        catch (TimeoutException e) {
            LOGGER.log(Level.WARNING, "Jira REST client timeout from jql search error. cause: " + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get issue from jql search error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public List<ExtendedVersion> getVersions(String projectKey) {
        URIBuilder builder = new URIBuilder(this.uri).setPath(String.format("%s/project/%s/versions", this.baseApiPath, projectKey));
        List decoded = Collections.emptyList();
        try {
            URI uri = builder.build();
            Content content = this.buildGetRequest(uri).execute().returnContent();
            decoded = (List)this.objectMapper.readValue(content.asString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get versions error. cause: " + e.getMessage(), e);
        }
        return decoded.stream().map(decodedVersion -> {
            DateTime startDate = decodedVersion.containsKey("startDate") ? DATE_TIME_FORMATTER.parseDateTime((String)decodedVersion.get("startDate")) : null;
            DateTime releaseDate = decodedVersion.containsKey("releaseDate") ? DATE_TIME_FORMATTER.parseDateTime((String)decodedVersion.get("releaseDate")) : null;
            return new ExtendedVersion(URI.create((String)decodedVersion.get("self")), Long.parseLong((String)decodedVersion.get("id")), (String)decodedVersion.get("name"), (String)decodedVersion.get("description"), (Boolean)decodedVersion.get("archived"), (Boolean)decodedVersion.get("released"), startDate, releaseDate);
        }).collect(Collectors.toList());
    }

    public Version addVersion(String projectKey, String versionName) {
        ExtendedVersionInput versionInput = new ExtendedVersionInput(projectKey, versionName, null, DateTime.now(), null, false, false);
        try {
            return (Version)this.jiraRestClient.getExtendedVersionRestClient().createExtendedVersion(versionInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client add version error. cause: " + e.getMessage(), e);
            return null;
        }
    }

    public void releaseVersion(String projectKey, ExtendedVersion version) {
        URIBuilder builder = new URIBuilder(this.uri).setPath(String.format("%s/version/%s", this.baseApiPath, version.getId()));
        ExtendedVersionInput versionInput = new ExtendedVersionInput(projectKey, version.getName(), version.getDescription(), version.getStartDate(), version.getReleaseDate(), version.isArchived(), version.isReleased());
        try {
            this.jiraRestClient.getExtendedVersionRestClient().updateExtendedVersion(builder.build(), versionInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client release version error. cause: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public BasicIssue createIssue(String projectKey, String description, String assignee, Iterable<String> components, String summary) {
        return this.createIssue(projectKey, description, assignee, components, summary, 1L, null);
    }

    public BasicIssue createIssue(String projectKey, String description, String assignee, Iterable<String> components, String summary, @NonNull Long issueTypeId, @Nullable Long priorityId) {
        IssueInputBuilder builder = new IssueInputBuilder();
        builder.setProjectKey(projectKey).setDescription(description).setIssueTypeId(issueTypeId).setSummary(summary);
        if (priorityId != null) {
            builder.setPriorityId(priorityId);
        }
        if (StringUtils.isNotBlank((String)assignee)) {
            HashMap<String, String> valuesMap = new HashMap<String, String>(2);
            valuesMap.put("name", assignee);
            valuesMap.put("accountId", assignee);
            builder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)new ComplexIssueInputFieldValue(valuesMap)));
        }
        if (StreamSupport.stream(components.spliterator(), false).count() > 0L) {
            builder.setComponentsNames(components);
        }
        IssueInput issueInput = builder.build();
        try {
            return (BasicIssue)this.jiraRestClient.getIssueClient().createIssue(issueInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST createIssue error: " + e.getMessage(), e);
            return null;
        }
    }

    public User getUser(String username) {
        try {
            return (User)this.jiraRestClient.getUserClient().getUser(username).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof RestClientException && ((RestClientException)e.getCause()).getStatusCode().isPresent() && (Integer)((RestClientException)e.getCause()).getStatusCode().get() == 404) {
                LOGGER.log(Level.INFO, "User '" + username + "' not found in Jira.");
            } else {
                LOGGER.log(Level.WARNING, "Jira REST client get user error. cause: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public void updateIssue(String issueKey, List<Version> fixVersions) {
        IssueInput issueInput = new IssueInputBuilder().setFixVersions(fixVersions).build();
        try {
            this.jiraRestClient.getIssueClient().updateIssue(issueKey, issueInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client update issue error. cause: " + e.getMessage(), e);
        }
    }

    public void setIssueLabels(String issueKey, List<String> labels) {
        IssueInput issueInput = new IssueInputBuilder().setFieldValue(IssueFieldId.LABELS_FIELD.id, labels).build();
        try {
            this.jiraRestClient.getIssueClient().updateIssue(issueKey, issueInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client update labels error for issue " + issueKey, e);
        }
    }

    public void setIssueFields(String issueKey, List<JiraIssueField> fields) {
        IssueInputBuilder builder = new IssueInputBuilder();
        for (JiraIssueField field : fields) {
            builder.setFieldValue(field.getId(), field.getValue());
        }
        IssueInput issueInput = builder.build();
        try {
            this.jiraRestClient.getIssueClient().updateIssue(issueKey, issueInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client update fields error for issue " + issueKey, e);
        }
    }

    public Issue progressWorkflowAction(String issueKey, Integer actionId) {
        TransitionInput transitionInput = new TransitionInput(actionId.intValue());
        Issue issue = this.getIssue(issueKey);
        try {
            this.jiraRestClient.getIssueClient().transition(issue, transitionInput).get((long)this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client process workflow action error. cause: " + e.getMessage(), e);
        }
        return issue;
    }

    public List<Transition> getAvailableActions(String issueKey) {
        Issue issue = this.getIssue(issueKey);
        try {
            Iterable transitions = (Iterable)this.jiraRestClient.getIssueClient().getTransitions(issue).get((long)this.timeout, TimeUnit.SECONDS);
            return StreamSupport.stream(transitions.spliterator(), false).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get available actions error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public List<Status> getStatuses() {
        try {
            Iterable statuses = (Iterable)this.jiraRestClient.getMetadataClient().getStatuses().get((long)this.timeout, TimeUnit.SECONDS);
            return StreamSupport.stream(statuses.spliterator(), false).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client get statuses error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public List<Component> getComponents(String projectKey) {
        URIBuilder builder = new URIBuilder(this.uri).setPath(String.format("%s/project/%s/components", this.baseApiPath, projectKey));
        try {
            Content content = this.buildGetRequest(builder.build()).execute().returnContent();
            List decoded = (List)this.objectMapper.readValue(content.asString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            ArrayList<Component> components = new ArrayList<Component>();
            for (Map decodeComponent : decoded) {
                BasicUser lead = null;
                if (decodeComponent.containsKey("lead")) {
                    Map decodedLead = (Map)decodeComponent.get("lead");
                    lead = new BasicUser(URI.create((String)decodedLead.get("self")), (String)decodedLead.get("name"), (String)decodedLead.get("displayName"), (String)decodedLead.get("accountId"));
                }
                Component component = new Component(URI.create((String)decodeComponent.get("self")), Long.valueOf(Long.parseLong((String)decodeComponent.get("id"))), (String)decodeComponent.get("name"), (String)decodeComponent.get("description"), lead);
                components.add(component);
            }
            return components;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Jira REST client process workflow action error. cause: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private Request buildGetRequest(URI uri) {
        Request request = Request.Get((URI)uri);
        ProxyConfiguration proxyConfiguration = Jenkins.get().proxy;
        if (proxyConfiguration != null) {
            HttpHost proxyHost = new HttpHost(proxyConfiguration.name, proxyConfiguration.port);
            boolean shouldByPassProxy = proxyConfiguration.getNoProxyHostPatterns().stream().anyMatch(it -> it.matcher(uri.getHost()).matches());
            if (!shouldByPassProxy) {
                request.viaProxy(proxyHost);
            }
        }
        return request.connectTimeout(this.timeoutInMilliseconds()).socketTimeout(this.timeoutInMilliseconds()).addHeader("Authorization", this.authHeader).addHeader("Content-Type", "application/json");
    }

    protected int timeoutInMilliseconds() {
        return (int)TimeUnit.SECONDS.toMillis(this.timeout);
    }

    public String getBaseApiPath() {
        return this.baseApiPath;
    }

    public Permissions getMyPermissions() throws RestClientException {
        return (Permissions)this.jiraRestClient.getExtendedMyPermissionsRestClient().getMyPermissions().claim();
    }
}

