/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Component;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Permissions;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.Version;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.plugins.jira.JiraRestService;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.extension.ExtendedVersion;
import hudson.plugins.jira.model.JiraIssueField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class JiraSession {
    private static final Logger LOGGER = Logger.getLogger(JiraSession.class.getName());
    public final JiraRestService service;
    private Set<String> projectKeys;
    private final String jiraSiteName;
    private Map<Long, String> knownStatuses = null;

    JiraSession(JiraSite site, JiraRestService jiraRestService) {
        this.service = jiraRestService;
        this.jiraSiteName = site.getName();
    }

    public Set<String> getProjectKeys() {
        if (this.projectKeys == null) {
            LOGGER.fine("Fetching remote project key list from " + this.jiraSiteName);
            List<String> keys = this.service.getProjectsKeys();
            this.projectKeys = new HashSet<String>(keys);
            LOGGER.fine("Project list=" + this.projectKeys);
        }
        return this.projectKeys;
    }

    public void addComment(String issueId, String comment, String groupVisibility, String roleVisibility) {
        this.service.addComment(issueId, comment, groupVisibility, roleVisibility);
    }

    public void addLabels(String issueId, List<String> labels) {
        ArrayList<String> newLabels = new ArrayList<String>();
        Issue existingIssue = this.service.getIssue(issueId);
        if (existingIssue.getLabels() != null) {
            newLabels.addAll(existingIssue.getLabels());
        }
        boolean changed = false;
        for (String label : labels) {
            if (newLabels.contains(label)) continue;
            newLabels.add(label);
            changed = true;
        }
        if (changed) {
            this.service.setIssueLabels(issueId, newLabels);
        }
    }

    public void addFields(String issueId, List<JiraIssueField> fields) {
        this.service.setIssueFields(issueId, fields);
    }

    public Issue getIssue(String id) {
        return this.service.getIssue(id);
    }

    public List<Issue> getIssuesFromJqlSearch(String jqlSearch) throws TimeoutException {
        return this.service.getIssuesFromJqlSearch(jqlSearch, Integer.MAX_VALUE);
    }

    public List<ExtendedVersion> getVersions(String projectKey) {
        LOGGER.fine("Fetching versions from project: " + projectKey);
        return this.service.getVersions(projectKey);
    }

    public ExtendedVersion getVersionByName(String projectKey, String name) {
        LOGGER.fine("Fetching versions from project: " + projectKey);
        List<ExtendedVersion> versions = this.getVersions(projectKey);
        if (versions == null) {
            return null;
        }
        for (ExtendedVersion version : versions) {
            if (!version.getName().equals(name)) continue;
            return version;
        }
        return null;
    }

    public List<Issue> getIssuesWithFixVersion(String projectKey, String version) throws TimeoutException {
        return this.getIssuesWithFixVersion(projectKey, version, "");
    }

    public List<Issue> getIssuesWithFixVersion(String projectKey, String version, String filter) throws TimeoutException {
        LOGGER.fine("Fetching versions from project: " + projectKey + " with fixVersion:" + version);
        if (StringUtils.isNotEmpty((String)filter)) {
            return this.service.getIssuesFromJqlSearch(String.format("project = \"%s\" and fixVersion = \"%s\" and " + filter, projectKey, version), Integer.MAX_VALUE);
        }
        return this.service.getIssuesFromJqlSearch(String.format("project = \"%s\" and fixVersion = \"%s\"", projectKey, version), Integer.MAX_VALUE);
    }

    public List<IssueType> getIssueTypes() {
        LOGGER.fine("Fetching issue types");
        return this.service.getIssueTypes();
    }

    public List<Priority> getPriorities() {
        LOGGER.fine("Fetching priorities");
        return this.service.getPriorities();
    }

    public void releaseVersion(String projectKey, ExtendedVersion version) {
        LOGGER.fine("Releasing version: " + version.getName());
        this.service.releaseVersion(projectKey, version);
    }

    public void migrateIssuesToFixVersion(String projectKey, String version, String query) throws TimeoutException {
        ExtendedVersion newVersion = this.getVersionByName(projectKey, version);
        if (newVersion == null) {
            LOGGER.warning("Version " + version + " was not found");
            return;
        }
        LOGGER.fine("Fetching versions with JQL:" + query);
        List<Issue> issues = this.service.getIssuesFromJqlSearch(query, Integer.MAX_VALUE);
        if (issues == null || issues.isEmpty()) {
            return;
        }
        LOGGER.fine("Found issues: " + issues.size());
        issues.stream().forEach(issue -> {
            LOGGER.fine("Migrating issue: " + issue.getKey());
            this.service.updateIssue(issue.getKey(), Collections.singletonList(newVersion));
        });
    }

    public void replaceFixVersion(String projectKey, String fromVersion, String toVersion, String query) throws TimeoutException {
        ExtendedVersion newVersion = this.getVersionByName(projectKey, toVersion);
        if (newVersion == null) {
            LOGGER.warning("Version " + toVersion + " was not found");
            return;
        }
        LOGGER.fine("Fetching versions with JQL:" + query);
        List<Issue> issues = this.service.getIssuesFromJqlSearch(query, Integer.MAX_VALUE);
        if (issues == null) {
            return;
        }
        LOGGER.fine("Found issues: " + issues.size());
        for (Issue issue : issues) {
            HashSet<Version> newVersions = new HashSet<Version>();
            newVersions.add(newVersion);
            if (StringUtils.startsWith((String)fromVersion, (String)"/") && StringUtils.endsWith((String)fromVersion, (String)"/")) {
                String regEx = StringUtils.removeStart((String)fromVersion, (String)"/");
                regEx = StringUtils.removeEnd((String)regEx, (String)"/");
                LOGGER.fine("Using regular expression: " + regEx);
                Pattern fromVersionPattern = Pattern.compile(regEx);
                for (Version currentVersion : issue.getFixVersions()) {
                    Matcher versionToRemove = fromVersionPattern.matcher(currentVersion.getName());
                    if (versionToRemove.matches()) continue;
                    newVersions.add(currentVersion);
                }
            } else {
                for (Version currentVersion : issue.getFixVersions()) {
                    if (currentVersion.getName().equals(fromVersion)) continue;
                    newVersions.add(currentVersion);
                }
            }
            LOGGER.fine("Replacing version in issue: " + issue.getKey());
            this.service.updateIssue(issue.getKey(), new ArrayList<Version>(newVersions));
        }
    }

    public void addFixVersion(String projectKey, String version, String query) throws TimeoutException {
        ExtendedVersion newVersion = this.getVersionByName(projectKey, version);
        if (newVersion == null) {
            LOGGER.warning("Version " + version + " was not found");
            return;
        }
        LOGGER.fine("Fetching issues with JQL:" + query);
        List<Issue> issues = this.service.getIssuesFromJqlSearch(query, Integer.MAX_VALUE);
        if (issues == null || issues.isEmpty()) {
            return;
        }
        LOGGER.fine("Found issues: " + issues.size());
        for (Issue issue : issues) {
            LOGGER.fine("Adding version: " + newVersion.getName() + " to issue: " + issue.getKey());
            ArrayList<Version> fixVersions = new ArrayList<Version>();
            issue.getFixVersions().forEach(fixVersions::add);
            fixVersions.add(newVersion);
            this.service.updateIssue(issue.getKey(), fixVersions);
        }
    }

    public String progressWorkflowAction(String issueKey, Integer actionId) {
        LOGGER.fine("Progressing issue " + issueKey + " with workflow action: " + actionId);
        Issue issue = this.service.progressWorkflowAction(issueKey, actionId);
        this.getStatusById(issue.getStatus().getId());
        return this.getStatusById(issue.getStatus().getId());
    }

    public Integer getActionIdForIssue(String issueKey, String workflowAction) {
        List<Transition> actions = this.service.getAvailableActions(issueKey);
        if (actions != null) {
            for (Transition action : actions) {
                if (action.getName() == null || !action.getName().equalsIgnoreCase(workflowAction)) continue;
                return action.getId();
            }
        }
        return null;
    }

    public String getStatusById(Long statusId) {
        String status = this.getKnownStatuses().get(statusId);
        if (status == null) {
            LOGGER.warning("Jira status could not be found: " + statusId + ". Checking Jira for new status types.");
            this.knownStatuses = null;
            status = this.getKnownStatuses().get(statusId);
        }
        return status;
    }

    private Map<Long, String> getKnownStatuses() {
        if (this.knownStatuses == null) {
            List<Status> statuses = this.service.getStatuses();
            this.knownStatuses = new HashMap<Long, String>(statuses.size());
            statuses.stream().forEach(status -> this.knownStatuses.put(status.getId(), status.getName()));
        }
        return this.knownStatuses;
    }

    @Deprecated
    public Issue createIssue(String projectKey, String description, String assignee, Iterable<String> components, String summary) {
        return this.createIssue(projectKey, description, assignee, components, summary, null, null);
    }

    public Issue createIssue(String projectKey, String description, String assignee, Iterable<String> components, String summary, @NonNull Long issueTypeId, @Nullable Long priorityId) {
        BasicIssue basicIssue = this.service.createIssue(projectKey, description, assignee, components, summary, issueTypeId, priorityId);
        return this.service.getIssue(basicIssue.getKey());
    }

    public void addCommentWithoutConstrains(String issueId, String comment) {
        this.service.addComment(issueId, comment, null, null);
    }

    public Issue getIssueByKey(String issueId) {
        return this.service.getIssue(issueId);
    }

    public List<Component> getComponents(String projectKey) {
        return this.service.getComponents(projectKey);
    }

    public Version addVersion(String version, String projectKey) {
        return this.service.addVersion(projectKey, version);
    }

    public Permissions getMyPermissions() {
        return this.service.getMyPermissions();
    }
}

