/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.ApacheAsyncHttpClient;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClientFactory
implements HttpClientFactory,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager threadLocalContextManager;
    private static ApacheAsyncHttpClient httpClient;

    public DefaultHttpClientFactory(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager threadLocalContextManager) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.threadLocalContextManager = Objects.requireNonNull(threadLocalContextManager);
    }

    public HttpClient create(HttpClientOptions options) {
        return this.doCreate(options, this.threadLocalContextManager);
    }

    public HttpClient create(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        return this.doCreate(options, threadLocalContextManager);
    }

    public void dispose(@NonNull HttpClient httpClient) throws Exception {
        if (httpClient instanceof ApacheAsyncHttpClient) {
            ((ApacheAsyncHttpClient)httpClient).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient doCreate(HttpClientOptions options, ThreadLocalContextManager threadLocalContextManager) {
        Objects.requireNonNull(options);
        if (httpClient != null) {
            return httpClient;
        }
        DefaultHttpClientFactory defaultHttpClientFactory = this;
        synchronized (defaultHttpClientFactory) {
            httpClient = new ApacheAsyncHttpClient(this.eventPublisher, this.applicationProperties, threadLocalContextManager, options);
            return httpClient;
        }
    }

    public void destroy() throws Exception {
        httpClient.destroy();
    }
}

