/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public class CredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());

    @CheckForNull
    protected static StandardUsernamePasswordCredentials lookupSystemCredentials(@CheckForNull String credentialsId, @CheckForNull URL url) {
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)(url != null ? url.toExternalForm() : null)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    protected static StandardUsernamePasswordCredentials migrateCredentials(@NonNull String username, String password, @CheckForNull URL url) {
        List credentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)(url != null ? url.toExternalForm() : null)).build()), (CredentialsMatcher)CredentialsMatchers.withUsername((String)username));
        for (StandardUsernamePasswordCredentials c : credentials) {
            if (!StringUtils.equals((String)password, (String)Secret.toString((Secret)c.getPassword()))) continue;
            return c;
        }
        UsernamePasswordCredentialsImpl newCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, "Migrated by Jira Plugin", username, password);
        SystemCredentialsProvider.getInstance().getCredentials().add(newCredentials);
        try {
            SystemCredentialsProvider.getInstance().save();
            LOGGER.log(Level.INFO, "Provided username and password were successfully migrated and stored as {0}", newCredentials.getId());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to store migrated credentials", e);
        }
        return newCredentials;
    }

    protected static ListBoxModel doFillCredentialsIdItems(Item item, String credentialsId, String uri) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)uri).build(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)})).includeCurrentValue(credentialsId);
    }

    protected static FormValidation doCheckFillCredentialsId(Item item, String credentialsId, String uri) {
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (StringUtils.isEmpty((String)credentialsId)) {
            return FormValidation.ok();
        }
        if (!CredentialsHelper.findCredentials(item, credentialsId, uri).isPresent()) {
            return FormValidation.error((String)"Cannot find currently selected credentials");
        }
        return FormValidation.ok();
    }

    protected static Optional<StandardUsernamePasswordCredentials> findCredentials(Item item, String credentialsId, String uri) {
        return Optional.ofNullable((StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)));
    }
}

