/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.domain.User;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.plugins.jira.JiraGlobalConfiguration;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.tasks.MailAddressResolver;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class JiraMailAddressResolver
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(JiraMailAddressResolver.class.getName());
    public static boolean disabled = Boolean.getBoolean(JiraMailAddressResolver.class.getName() + ".disabled");
    private static final String PRE = "[( \\[<_{\"=]+";
    private static final String POST = "[) \\]>_}\"=]+";
    private static final Pattern AT = Pattern.compile("[( \\[<_{\"=]+[aA][tT][) \\]>_}\"=]+");
    private static final Pattern DOT = Pattern.compile("[( \\[<_{\"=]+[dD][oO0][tT][) \\]>_}\"=]+");

    public String findMailAddressFor(hudson.model.User u) {
        if (disabled) {
            return null;
        }
        String username = u.getId();
        Job job = null;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            job = (Job)req.findAncestorObject(Job.class);
        }
        List<JiraSite> sites = job == null ? JiraGlobalConfiguration.get().getSites() : JiraSite.getJiraSites(job);
        for (JiraSite site : sites) {
            String email;
            User user;
            JiraSession session = site.getSession((Item)job);
            if (session == null || (user = session.service.getUser(username)) == null || (email = user.getEmailAddress()) == null) continue;
            email = JiraMailAddressResolver.unmaskEmail(email);
            return email;
        }
        return null;
    }

    static String unmaskEmail(String email) {
        email = AT.matcher(email).replaceAll("@");
        email = DOT.matcher(email).replaceAll(".");
        return email;
    }
}

