/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.extension;

import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import hudson.plugins.jira.extension.ExtendedVersion;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class ExtendedVersionJsonParser
implements JsonObjectParser<ExtendedVersion> {
    public ExtendedVersion parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri((JSONObject)json);
        Long id = JsonParseUtil.getOptionalLong((JSONObject)json, (String)"id");
        String name = json.getString("name");
        String description = JsonParseUtil.getOptionalString((JSONObject)json, (String)"description");
        boolean isArchived = json.getBoolean("archived");
        boolean isReleased = json.getBoolean("released");
        String startDateStr = JsonParseUtil.getOptionalString((JSONObject)json, (String)"startDate");
        String releaseDateStr = JsonParseUtil.getOptionalString((JSONObject)json, (String)"releaseDate");
        DateTime startDate = this.parseDate(startDateStr);
        DateTime releaseDate = this.parseDate(releaseDateStr);
        return new ExtendedVersion(self, id, name, description, isArchived, isReleased, startDate, releaseDate);
    }

    private DateTime parseDate(String dateStr) {
        if (dateStr != null) {
            return dateStr.length() > "YYYY-MM-RR".length() ? JsonParseUtil.parseDateTime((String)dateStr) : JsonParseUtil.parseDate((String)dateStr);
        }
        return null;
    }
}

