/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.selector;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraCarryOverAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.RunScmChangeExtractor;
import hudson.plugins.jira.listissuesparameter.JiraIssueParameterValue;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultIssueSelector
extends AbstractIssueSelector {
    private static final Logger LOGGER = Logger.getLogger(DefaultIssueSelector.class.getName());

    @DataBoundConstructor
    public DefaultIssueSelector() {
    }

    @Override
    public Set<String> findIssueIds(@NonNull Run<?, ?> run, @NonNull JiraSite site, @NonNull TaskListener listener) {
        LinkedHashSet<String> issuesIds = new LinkedHashSet<String>();
        this.addIssuesRecursive(run, site, listener, issuesIds);
        return issuesIds;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected static void findIssues(Run<?, ?> build, Set<String> issueIds, Pattern pattern, TaskListener listener) {
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : RunScmChangeExtractor.getChanges(build)) {
            for (ChangeLogSet.Entry change : set) {
                LOGGER.fine("Looking for Jira ID in " + change.getMsg());
                Matcher m = pattern.matcher(change.getMsg());
                while (m.find()) {
                    if (m.groupCount() >= 1) {
                        String content = StringUtils.upperCase((String)m.group(1));
                        issueIds.add(content);
                        continue;
                    }
                    listener.getLogger().println("Warning: The Jira pattern " + pattern + " doesn't define a capturing group!");
                }
            }
        }
    }

    protected void addIssuesFromChangeLog(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issueIds) {
        Pattern pattern = site.getIssuePattern();
        DefaultIssueSelector.findIssues(build, issueIds, pattern, listener);
    }

    protected void addIssuesRecursive(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issuesIds) {
        this.addIssuesCarriedOverFromPreviousBuild(build, site, listener, issuesIds);
        this.addIssuesFromCurrentBuild(build, site, listener, issuesIds);
        this.addIssuesFromDependentBuilds(build, site, listener, issuesIds);
    }

    protected void addIssuesFromCurrentBuild(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issueIds) {
        this.addIssuesFromChangeLog(build, site, listener, issueIds);
        this.addIssuesFromParameters(build, site, listener, issueIds);
    }

    protected void addIssuesFromDependentBuilds(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issueIds) {
        Pattern pattern = site.getIssuePattern();
        for (AbstractBuild.DependencyChange depc : RunScmChangeExtractor.getDependencyChanges(build).values()) {
            for (AbstractBuild b : depc.getBuilds()) {
                this.getLogger().finer("Searching for Jira issues in dependency " + b + " of " + build);
                DefaultIssueSelector.findIssues(b, issueIds, pattern, listener);
            }
        }
    }

    protected void addIssuesFromParameters(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> issueIds) {
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            for (ParameterValue val : parameters.getParameters()) {
                String issueId;
                if (!(val instanceof JiraIssueParameterValue) || !issueIds.add(issueId = ((JiraIssueParameterValue)val).getValue().toString())) continue;
                this.getLogger().finer("Added perforce issue " + issueId + " from build " + build);
            }
        }
    }

    protected void addIssuesCarriedOverFromPreviousBuild(Run<?, ?> build, JiraSite site, TaskListener listener, Set<String> ids) {
        JiraCarryOverAction a;
        Run prev = build.getPreviousCompletedBuild();
        if (prev != null && (a = (JiraCarryOverAction)prev.getAction(JiraCarryOverAction.class)) != null) {
            this.getLogger().finer("Searching for Jira issues in previously failed build " + prev.number);
            Collection<String> jobIDs = a.getIDs();
            ids.addAll(jobIDs);
            if (this.getLogger().isLoggable(Level.FINER)) {
                for (String jobId : a.getIDs()) {
                    this.getLogger().finer("Adding job " + jobId);
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AbstractIssueSelector> {
        public String getDisplayName() {
            return Messages.DefaultIssueSelector_DisplayName();
        }
    }
}

