/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.selector;

import com.atlassian.jira.rest.client.api.domain.Issue;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.EnvironmentExpander;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.kohsuke.stapler.DataBoundConstructor;

public class JqlIssueSelector
extends AbstractIssueSelector {
    private String jql;

    @DataBoundConstructor
    public JqlIssueSelector(String jql) {
        this.jql = jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public String getJql() {
        return this.jql;
    }

    @Override
    public Set<String> findIssueIds(Run<?, ?> run, JiraSite site, TaskListener listener) {
        try {
            JiraSession session = site.getSession((Item)run.getParent());
            if (session == null) {
                throw new IllegalStateException("Remote access for Jira isn't configured in Jenkins");
            }
            String expandedJql = EnvironmentExpander.expandVariable(this.jql, run, listener);
            List<Issue> issues = session.getIssuesFromJqlSearch(expandedJql);
            ArrayList<String> issueKeys = new ArrayList<String>();
            for (Issue issue : Util.fixNull(issues)) {
                issueKeys.add(issue.getKey());
            }
            return new HashSet<String>(issueKeys);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Can't open rest session to Jira site " + (Object)((Object)site), e);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AbstractIssueSelector> {
        public String getDisplayName() {
            return Messages.IssueSelector_JqlIssueSelector_DisplayName();
        }
    }
}

